/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.CommandReturnType;
import org.enodeframework.common.io.Task;
import org.enodeframework.queue.PointToPointEventBus;
import org.enodeframework.queue.SendReplyService;
import org.enodeframework.queue.domainevent.DomainEventHandledMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/enodeframework/queue/DefaultSendReplyService;", "Lio/vertx/core/AbstractVerticle;", "Lorg/enodeframework/queue/SendReplyService;", "()V", "pointEventBus", "Lorg/enodeframework/queue/PointToPointEventBus;", "started", "", "stoped", "sendCommandReply", "Ljava/util/concurrent/CompletableFuture;", "commandResult", "Lorg/enodeframework/commanding/CommandResult;", "address", "", "sendEventReply", "eventHandledMessage", "Lorg/enodeframework/queue/domainevent/DomainEventHandledMessage;", "sendReply", "replyMessage", "Lio/vertx/core/json/JsonObject;", "start", "", "stop", "enode"})
public final class DefaultSendReplyService
extends AbstractVerticle
implements SendReplyService {
    private boolean started;
    private boolean stoped;
    private PointToPointEventBus pointEventBus;

    public void start() {
        if (!this.started) {
            this.pointEventBus = new PointToPointEventBus(this.vertx, new VertxOptions());
            this.started = true;
        }
    }

    public void stop() {
        if (!this.stoped) {
            PointToPointEventBus pointToPointEventBus = this.pointEventBus;
            if (pointToPointEventBus == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pointEventBus");
                pointToPointEventBus = null;
            }
            pointToPointEventBus.close();
            this.stoped = true;
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> sendCommandReply(@NotNull CommandResult commandResult, @NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)commandResult, (String)"commandResult");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        JsonObject replyMessage = new JsonObject();
        replyMessage.put("code", (Object)CommandReturnType.CommandExecuted.getValue());
        replyMessage.put("commandResult", (Object)commandResult);
        return this.sendReply(replyMessage, address);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> sendEventReply(@NotNull DomainEventHandledMessage eventHandledMessage, @NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)eventHandledMessage, (String)"eventHandledMessage");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        JsonObject replyMessage = new JsonObject();
        replyMessage.put("code", (Object)CommandReturnType.EventHandled.getValue());
        replyMessage.put("eventHandledMessage", (Object)eventHandledMessage);
        return this.sendReply(replyMessage, address);
    }

    private final CompletableFuture<Boolean> sendReply(JsonObject replyMessage, String address) {
        PointToPointEventBus pointToPointEventBus = this.pointEventBus;
        if (pointToPointEventBus == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pointEventBus");
            pointToPointEventBus = null;
        }
        pointToPointEventBus.send(address, replyMessage);
        return Task.completedTask;
    }
}

