/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.command;

import com.google.common.base.Strings;
import java.util.HashMap;
import org.enodeframework.commanding.CommandMessage;
import org.enodeframework.commanding.CommandProcessor;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.commanding.impl.DefaultCommandExecuteContext;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.domain.AggregateStorage;
import org.enodeframework.domain.Repository;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.enodeframework.queue.MessageContext;
import org.enodeframework.queue.MessageHandler;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.SendReplyService;
import org.enodeframework.queue.command.GenericCommandMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommandMessageHandler
implements MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCommandMessageHandler.class);
    private final SendReplyService sendReplyService;
    private final TypeNameProvider typeNameProvider;
    private final CommandProcessor commandProcessor;
    private final Repository repository;
    private final AggregateStorage aggregateRootStorage;
    private final SerializeService serializeService;

    public DefaultCommandMessageHandler(SendReplyService sendReplyService, TypeNameProvider typeNameProvider, CommandProcessor commandProcessor, Repository repository, AggregateStorage aggregateRootStorage, SerializeService serializeService) {
        this.sendReplyService = sendReplyService;
        this.typeNameProvider = typeNameProvider;
        this.commandProcessor = commandProcessor;
        this.repository = repository;
        this.aggregateRootStorage = aggregateRootStorage;
        this.serializeService = serializeService;
    }

    @Override
    public void handle(QueueMessage queueMessage, MessageContext context) {
        logger.info("Received command message: {}", (Object)queueMessage);
        GenericCommandMessage commandMessage = this.serializeService.deserialize(queueMessage.getBody(), GenericCommandMessage.class);
        Class<?> commandType = this.typeNameProvider.getType(commandMessage.getCommandType());
        CommandMessage command = (CommandMessage)this.serializeService.deserialize(commandMessage.getCommandData(), commandType);
        DefaultCommandExecuteContext commandExecuteContext = new DefaultCommandExecuteContext(this.repository, this.aggregateRootStorage, queueMessage, context, commandMessage, this.sendReplyService);
        HashMap<String, Object> commandItems = new HashMap<String, Object>();
        String uri = commandMessage.getReplyAddress();
        if (!Strings.isNullOrEmpty((String)uri)) {
            commandItems.put("COMMAND_REPLY_ADDRESS", uri);
        }
        this.commandProcessor.process(new ProcessingCommand(command, commandExecuteContext, commandItems));
    }
}

