/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.publishableexceptions;

import org.enodeframework.common.exception.MessageInstanceCreateException;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.domain.DomainExceptionMessage;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.enodeframework.messaging.MessageDispatcher;
import org.enodeframework.queue.MessageContext;
import org.enodeframework.queue.MessageHandler;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.publishableexceptions.GenericPublishableExceptionMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPublishableExceptionMessageHandler
implements MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPublishableExceptionMessageHandler.class);
    private final TypeNameProvider typeNameProvider;
    private final MessageDispatcher messageDispatcher;
    private final SerializeService serializeService;

    public DefaultPublishableExceptionMessageHandler(TypeNameProvider typeNameProvider, MessageDispatcher messageDispatcher, SerializeService serializeService) {
        this.typeNameProvider = typeNameProvider;
        this.messageDispatcher = messageDispatcher;
        this.serializeService = serializeService;
    }

    @Override
    public void handle(QueueMessage queueMessage, MessageContext context) {
        DomainExceptionMessage exception;
        logger.info("Received domain exception message: {}", (Object)queueMessage);
        GenericPublishableExceptionMessage exceptionMessage = this.serializeService.deserialize(queueMessage.getBody(), GenericPublishableExceptionMessage.class);
        Class<?> exceptionType = this.typeNameProvider.getType(exceptionMessage.getExceptionType());
        try {
            exception = (DomainExceptionMessage)exceptionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MessageInstanceCreateException(e);
        }
        exception.setId(exceptionMessage.getUniqueId());
        exception.setTimestamp(exceptionMessage.getTimestamp());
        exception.setItems(exceptionMessage.getItems());
        exception.restoreFrom(exceptionMessage.getSerializableInfo());
        this.messageDispatcher.dispatchMessageAsync(exception).whenComplete((x, y) -> context.onMessageHandled(queueMessage));
    }
}

