/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.publishableexceptions;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.domain.DomainExceptionMessage;
import org.enodeframework.messaging.MessagePublisher;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.SendMessageService;
import org.enodeframework.queue.publishableexceptions.GenericPublishableExceptionMessage;

public class DefaultPublishableExceptionPublisher
implements MessagePublisher<DomainExceptionMessage> {
    private final String topic;
    private final String tag;
    private final SendMessageService sendMessageService;
    private final SerializeService serializeService;

    public DefaultPublishableExceptionPublisher(String topic, String tag, SendMessageService sendMessageService, SerializeService serializeService) {
        this.topic = topic;
        this.tag = tag;
        this.sendMessageService = sendMessageService;
        this.serializeService = serializeService;
    }

    protected QueueMessage createExceptionMessage(DomainExceptionMessage exception) {
        Assert.nonNull(this.topic, "topic");
        HashMap<String, Object> serializableInfo = new HashMap<String, Object>();
        exception.serializeTo(serializableInfo);
        GenericPublishableExceptionMessage exceptionMessage = new GenericPublishableExceptionMessage();
        exceptionMessage.setUniqueId(exception.getId());
        exceptionMessage.setExceptionType(exception.getClass().getName());
        exceptionMessage.setTimestamp(exception.getTimestamp());
        exceptionMessage.setSerializableInfo(serializableInfo);
        exceptionMessage.setItems(exception.getItems());
        String data = this.serializeService.serialize(exceptionMessage);
        String routeKey = exception.getId();
        QueueMessage queueMessage = new QueueMessage();
        queueMessage.setTopic(this.topic);
        queueMessage.setTag(this.tag);
        queueMessage.setBody(data);
        queueMessage.setRouteKey(routeKey);
        queueMessage.setKey(exceptionMessage.getUniqueId());
        return queueMessage;
    }

    @Override
    public CompletableFuture<Boolean> publishAsync(DomainExceptionMessage message) {
        return this.sendMessageService.sendMessageAsync(this.createExceptionMessage(message));
    }
}

