/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.commanding;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.commanding.ProcessingCommandHandler;
import org.enodeframework.common.extensions.SystemClock;
import org.enodeframework.common.io.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0003J\u0018\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0002J\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0018002\u0006\u00101\u001a\u00020(2\u0006\u00102\u001a\u000203J\b\u00104\u001a\u00020+H\u0002J\u000e\u00105\u001a\u00020+2\u0006\u00101\u001a\u00020(J\u0006\u00106\u001a\u00020+J\u0012\u00107\u001a\u0004\u0018\u00010(2\u0006\u00108\u001a\u00020'H\u0002J\u0006\u00109\u001a\u00020'J\u000e\u0010:\u001a\u00020\u00182\u0006\u0010;\u001a\u00020\tJ\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010<\u001a\u00020+J\u0006\u0010=\u001a\u00020+J\b\u0010>\u001a\u00020+H\u0002J\u0018\u0010?\u001a\u00020+2\u0006\u0010@\u001a\u00020'2\u0006\u0010A\u001a\u00020'H\u0002J\u000e\u0010B\u001a\u00020+2\u0006\u0010\u0012\u001a\u00020'J\u0006\u0010C\u001a\u00020+J\b\u0010D\u001a\u00020+H\u0002J\b\u0010E\u001a\u00020+H\u0002J\u0006\u0010F\u001a\u00020+J\u0006\u0010G\u001a\u00020\u0018R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n $*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/enodeframework/commanding/ProcessingCommandMailbox;", "", "aggregateRootId", "", "messageHandler", "Lorg/enodeframework/commanding/ProcessingCommandHandler;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "batchSize", "", "(Ljava/lang/String;Lorg/enodeframework/commanding/ProcessingCommandHandler;Lkotlinx/coroutines/CoroutineDispatcher;I)V", "getAggregateRootId", "()Ljava/lang/String;", "setAggregateRootId", "(Ljava/lang/String;)V", "asyncLockObj", "<set-?>", "Ljava/util/concurrent/atomic/AtomicLong;", "consumingSequence", "getConsumingSequence", "()Ljava/util/concurrent/atomic/AtomicLong;", "duplicateCommandIdDict", "Ljava/util/LinkedHashSet;", "isPauseRequested", "", "isPaused", "()Z", "isRemoved", "Ljava/util/concurrent/atomic/AtomicInteger;", "isRunning", "isUsing", "lastActiveTime", "Ljava/util/Date;", "lockObj", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "messageDict", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/enodeframework/commanding/ProcessingCommand;", "nextSequence", "addDuplicateCommandId", "", "commandId", "checkContains", "value", "completeMessage", "Ljava/util/concurrent/CompletableFuture;", "message", "result", "Lorg/enodeframework/commanding/CommandResult;", "completeRun", "enqueueMessage", "exitUsing", "getMessage", "sequence", "getTotalUnHandledMessageCount", "isInactive", "timeoutSeconds", "markAsRemoved", "pause", "processMessages", "processMessagesRecursively", "unHandledMessageCount", "scannedCount", "resetConsumingSequence", "resume", "setAsNotRunning", "setAsRunning", "tryRun", "tryUsing", "enode"})
@SourceDebugExtension(value={"SMAP\nProcessingCommandMailbox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessingCommandMailbox.kt\norg/enodeframework/commanding/ProcessingCommandMailbox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n1747#2,3:281\n*S KotlinDebug\n*F\n+ 1 ProcessingCommandMailbox.kt\norg/enodeframework/commanding/ProcessingCommandMailbox\n*L\n234#1:281,3\n*E\n"})
public final class ProcessingCommandMailbox {
    @NotNull
    private String aggregateRootId;
    @NotNull
    private final ProcessingCommandHandler messageHandler;
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    private final int batchSize;
    private final Logger logger;
    @NotNull
    private final Object lockObj;
    @NotNull
    private final Object asyncLockObj;
    @NotNull
    private ConcurrentHashMap<Long, ProcessingCommand> messageDict;
    @NotNull
    private LinkedHashSet<String> duplicateCommandIdDict;
    @NotNull
    private final AtomicInteger isUsing;
    @NotNull
    private final AtomicInteger isRemoved;
    @NotNull
    private Date lastActiveTime;
    private boolean isRunning;
    private boolean isPauseRequested;
    private boolean isPaused;
    private long nextSequence;
    @NotNull
    private AtomicLong consumingSequence;

    public ProcessingCommandMailbox(@NotNull String aggregateRootId, @NotNull ProcessingCommandHandler messageHandler, @NotNull CoroutineDispatcher coroutineDispatcher, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)messageHandler, (String)"messageHandler");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        this.aggregateRootId = aggregateRootId;
        this.messageHandler = messageHandler;
        this.coroutineDispatcher = coroutineDispatcher;
        this.batchSize = batchSize;
        this.logger = LoggerFactory.getLogger(ProcessingCommandMailbox.class);
        this.lockObj = new Object();
        this.asyncLockObj = new Object();
        this.messageDict = new ConcurrentHashMap();
        this.duplicateCommandIdDict = new LinkedHashSet();
        this.isUsing = new AtomicInteger(0);
        this.isRemoved = new AtomicInteger(0);
        this.consumingSequence = new AtomicLong(0L);
        this.lastActiveTime = new Date();
    }

    @NotNull
    public final String getAggregateRootId() {
        return this.aggregateRootId;
    }

    public final void setAggregateRootId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.aggregateRootId = string;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final boolean isPaused() {
        return this.isPaused;
    }

    @NotNull
    public final AtomicLong getConsumingSequence() {
        return this.consumingSequence;
    }

    public final long getTotalUnHandledMessageCount() {
        return this.nextSequence - this.consumingSequence.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueMessage(@NotNull ProcessingCommand message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            message.setSequence(this.nextSequence);
            message.setMailBox(this);
            if (this.messageDict.putIfAbsent(message.getSequence(), message) == null) {
                long l = this.nextSequence;
                this.nextSequence = l + 1L;
                if (this.logger.isDebugEnabled()) {
                    Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, message.getSequence()};
                    this.logger.debug("{} enqueued new message, aggregateRootId: {}, messageSequence: {}", objectArray);
                }
                this.lastActiveTime = new Date();
                this.tryRun();
            } else {
                Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, message.getMessage().getId(), message.getSequence()};
                this.logger.error("{} enqueue message failed, aggregateRootId: {}, messageId: {}, messageSequence: {}", objectArray);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tryRun() {
        Object object = this.lockObj;
        synchronized (object) {
            block8: {
                block7: {
                    boolean bl = false;
                    if (this.isRunning || this.isPauseRequested) break block7;
                    if (!this.isPaused) break block8;
                }
                return;
            }
            this.setAsRunning();
            if (this.logger.isDebugEnabled()) {
                Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, this.consumingSequence.get()};
                this.logger.debug("{} start run, aggregateRootId: {}, consumingSequence: {}", objectArray);
            }
            BuildersKt.async$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.coroutineDispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ProcessingCommandMailbox this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ProcessingCommandMailbox.access$processMessages(this.this$0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return;
        }
    }

    private final void completeRun() {
        this.lastActiveTime = new Date();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} complete run, aggregateRootId: {}", (Object)this.getClass().getName(), (Object)this.aggregateRootId);
        }
        this.setAsNotRunning();
        if (this.getTotalUnHandledMessageCount() > 0L) {
            this.tryRun();
        }
    }

    public final void pause() {
        this.isPauseRequested = true;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} pause requested, aggregateRootId: {}", (Object)this.getClass().getName(), (Object)this.aggregateRootId);
        }
        long count = 0L;
        while (this.isRunning) {
            Task.sleep(10L);
            long l = count;
            if ((count = l + 1L) % (long)100 != 0L || !this.logger.isDebugEnabled()) continue;
            Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, count};
            this.logger.debug("{} pause requested, but wait for too long to stop the current mailbox, aggregateRootId: {}, waitCount: {}", objectArray);
        }
        this.lastActiveTime = new Date();
        this.isPaused = true;
    }

    public final void resume() {
        this.isPauseRequested = false;
        this.isPaused = false;
        this.lastActiveTime = new Date();
        if (this.logger.isDebugEnabled()) {
            Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, this.consumingSequence.get()};
            this.logger.debug("{} resume requested, aggregateRootId: {}, consumingSequence: {}", objectArray);
        }
    }

    public final void addDuplicateCommandId(@NotNull String commandId) {
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        this.duplicateCommandIdDict.add(commandId);
    }

    public final void resetConsumingSequence(long consumingSequence) {
        this.consumingSequence.set(consumingSequence);
        this.lastActiveTime = new Date();
        if (this.logger.isDebugEnabled()) {
            Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, consumingSequence};
            this.logger.debug("{} reset consumingSequence, aggregateRootId: {}, consumingSequence: {}", objectArray);
        }
    }

    private final boolean checkContains(String value, String commandId) {
        if (value.length() < commandId.length()) {
            return false;
        }
        if (value.length() == commandId.length()) {
            return Intrinsics.areEqual((Object)value, (Object)commandId);
        }
        if (value.length() > 32 && commandId.length() >= 8) {
            return StringsKt.contains$default((CharSequence)value, (CharSequence)commandId, (boolean)false, (int)2, null);
        }
        return false;
    }

    @NotNull
    public final CompletableFuture<Boolean> completeMessage(@NotNull ProcessingCommand message, @NotNull CommandResult result) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        try {
            ProcessingCommand removed = this.messageDict.remove(message.getSequence());
            if (removed != null) {
                this.duplicateCommandIdDict.removeIf(arg_0 -> ProcessingCommandMailbox.completeMessage$lambda$2((Function1)new Function1<String, Boolean>(this, message){
                    final /* synthetic */ ProcessingCommandMailbox this$0;
                    final /* synthetic */ ProcessingCommand $message;
                    {
                        this.this$0 = $receiver;
                        this.$message = $message;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String x) {
                        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                        return ProcessingCommandMailbox.access$checkContains(this.this$0, x, this.$message.getMessage().getId());
                    }
                }, arg_0));
                this.lastActiveTime = new Date();
                return message.completeAsync(result);
            }
        }
        catch (Exception ex) {
            Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, message.getMessage().getId(), message.getSequence(), result, ex};
            this.logger.error("{} complete message with result failed, aggregateRootId: {}, messageId: {}, messageSequence: {}, result: {}", objectArray);
        }
        return Task.completedTask;
    }

    public final boolean isInactive(int timeoutSeconds) {
        return SystemClock.now() - this.lastActiveTime.getTime() >= (long)timeoutSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processMessages() {
        Object object = this.asyncLockObj;
        synchronized (object) {
            boolean bl = false;
            this.lastActiveTime = new Date();
            try {
                this.processMessagesRecursively(this.getTotalUnHandledMessageCount(), 0L);
            }
            catch (Exception ex) {
                Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, ex};
                this.logger.error("{} run has unknown exception, aggregateRootId: {}", objectArray);
                Task.sleep(1L);
                this.completeRun();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void processMessagesRecursively(long unHandledMessageCount, long scannedCount) {
        if (unHandledMessageCount <= 0L || scannedCount >= (long)this.batchSize || this.isPauseRequested) {
            this.completeRun();
            return;
        }
        ProcessingCommand message = this.getMessage(this.consumingSequence.get());
        if (message != null) {
            boolean bl;
            block7: {
                Iterable $this$any$iv = this.duplicateCommandIdDict;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String x = (String)element$iv;
                        boolean bl2 = false;
                        if (!this.checkContains(x, message.getMessage().getId())) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                message.setDuplicated(true);
            }
            this.messageHandler.handleAsync(message).whenComplete((arg_0, arg_1) -> ProcessingCommandMailbox.processMessagesRecursively$lambda$5((Function2)new Function2<Boolean, Throwable, Unit>(this, scannedCount){
                final /* synthetic */ ProcessingCommandMailbox this$0;
                final /* synthetic */ long $scannedCount;
                {
                    this.this$0 = $receiver;
                    this.$scannedCount = $scannedCount;
                    super(2);
                }

                public final void invoke(Boolean bl, Throwable throwable) {
                    this.this$0.getConsumingSequence().incrementAndGet();
                    ProcessingCommandMailbox.access$processMessagesRecursively(this.this$0, this.this$0.getTotalUnHandledMessageCount(), this.$scannedCount + 1L);
                }
            }, arg_0, arg_1));
        } else {
            this.consumingSequence.incrementAndGet();
            this.processMessagesRecursively(this.getTotalUnHandledMessageCount(), scannedCount + 1L);
        }
    }

    private final ProcessingCommand getMessage(long sequence) {
        return this.messageDict.get(sequence);
    }

    private final void setAsRunning() {
        this.isRunning = true;
    }

    public final boolean tryUsing() {
        return this.isUsing.compareAndSet(0, 1);
    }

    public final void exitUsing() {
        this.isUsing.set(0);
    }

    public final void markAsRemoved() {
        this.isRemoved.set(1);
    }

    public final boolean isRemoved() {
        return this.isRemoved.get() == 1;
    }

    private final void setAsNotRunning() {
        this.isRunning = false;
    }

    private static final boolean completeMessage$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void processMessagesRecursively$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ boolean access$checkContains(ProcessingCommandMailbox $this, String value, String commandId) {
        return $this.checkContains(value, commandId);
    }

    public static final /* synthetic */ void access$processMessagesRecursively(ProcessingCommandMailbox $this, long unHandledMessageCount, long scannedCount) {
        $this.processMessagesRecursively(unHandledMessageCount, scannedCount);
    }

    public static final /* synthetic */ void access$processMessages(ProcessingCommandMailbox $this) {
        $this.processMessages();
    }
}

