/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.commanding.impl;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.future.FutureKt;
import org.enodeframework.commanding.CommandExecuteContext;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.common.exception.AggregateRootAlreadyExistException;
import org.enodeframework.common.exception.AggregateRootNotFoundException;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.AggregateStorage;
import org.enodeframework.domain.Repository;
import org.enodeframework.messaging.ApplicationMessage;
import org.enodeframework.queue.MessageContext;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.SendReplyService;
import org.enodeframework.queue.command.GenericCommandMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010$\u001a\u00020\u001dH\u0016J\u0010\u0010)\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dH\u0002J\b\u0010*\u001a\u00020#H\u0016J3\u0010+\u001a\u0002H,\"\n\b\u0000\u0010,*\u0004\u0018\u00010\u001d2\u0006\u0010-\u001a\u00020\u00162\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H,0/H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J;\u0010+\u001a\u0002H,\"\n\b\u0000\u0010,*\u0004\u0018\u00010\u001d2\u0006\u0010-\u001a\u00020\u00162\u0006\u00101\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H,0/H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J0\u00103\u001a\b\u0012\u0004\u0012\u0002H,0'\"\n\b\u0000\u0010,*\u0004\u0018\u00010\u001d2\u0006\u0010-\u001a\u00020\u00162\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H,0/H\u0016J8\u00103\u001a\b\u0012\u0004\u0012\u0002H,0'\"\n\b\u0000\u0010,*\u0004\u0018\u00010\u001d2\u0006\u0010-\u001a\u00020\u00162\u0006\u00101\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H,0/H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u00105\u001a\u000206H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001d0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00067"}, d2={"Lorg/enodeframework/commanding/impl/DefaultCommandExecuteContext;", "Lorg/enodeframework/commanding/CommandExecuteContext;", "repository", "Lorg/enodeframework/domain/Repository;", "aggregateRootStorage", "Lorg/enodeframework/domain/AggregateStorage;", "queueMessage", "Lorg/enodeframework/queue/QueueMessage;", "messageContext", "Lorg/enodeframework/queue/MessageContext;", "genericCommandMessage", "Lorg/enodeframework/queue/command/GenericCommandMessage;", "sendReplyService", "Lorg/enodeframework/queue/SendReplyService;", "(Lorg/enodeframework/domain/Repository;Lorg/enodeframework/domain/AggregateStorage;Lorg/enodeframework/queue/QueueMessage;Lorg/enodeframework/queue/MessageContext;Lorg/enodeframework/queue/command/GenericCommandMessage;Lorg/enodeframework/queue/SendReplyService;)V", "applicationMessage", "Lorg/enodeframework/messaging/ApplicationMessage;", "getApplicationMessage", "()Lorg/enodeframework/messaging/ApplicationMessage;", "setApplicationMessage", "(Lorg/enodeframework/messaging/ApplicationMessage;)V", "result", "", "getResult", "()Ljava/lang/String;", "setResult", "(Ljava/lang/String;)V", "trackedAggregateRoots", "", "Lorg/enodeframework/domain/AggregateRoot;", "getTrackedAggregateRoots", "()Ljava/util/List;", "trackingAggregateRootDict", "Ljava/util/concurrent/ConcurrentMap;", "add", "", "aggregateRoot", "(Lorg/enodeframework/domain/AggregateRoot;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addAsync", "Ljava/util/concurrent/CompletableFuture;", "", "addInternal", "clear", "get", "T", "id", "aggregateRootType", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "firstFromCache", "(Ljava/lang/String;ZLjava/lang/Class;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAsync", "onCommandExecutedAsync", "commandResult", "Lorg/enodeframework/commanding/CommandResult;", "enode"})
public final class DefaultCommandExecuteContext
implements CommandExecuteContext {
    @NotNull
    private final ConcurrentMap<String, AggregateRoot> trackingAggregateRootDict;
    @NotNull
    private final Repository repository;
    @NotNull
    private final AggregateStorage aggregateRootStorage;
    @NotNull
    private final SendReplyService sendReplyService;
    @NotNull
    private final QueueMessage queueMessage;
    @NotNull
    private final MessageContext messageContext;
    @NotNull
    private final GenericCommandMessage genericCommandMessage;
    @NotNull
    private String result;
    @Nullable
    private ApplicationMessage applicationMessage;

    public DefaultCommandExecuteContext(@NotNull Repository repository, @NotNull AggregateStorage aggregateRootStorage, @NotNull QueueMessage queueMessage, @NotNull MessageContext messageContext, @NotNull GenericCommandMessage genericCommandMessage, @NotNull SendReplyService sendReplyService) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)aggregateRootStorage, (String)"aggregateRootStorage");
        Intrinsics.checkNotNullParameter((Object)queueMessage, (String)"queueMessage");
        Intrinsics.checkNotNullParameter((Object)messageContext, (String)"messageContext");
        Intrinsics.checkNotNullParameter((Object)genericCommandMessage, (String)"genericCommandMessage");
        Intrinsics.checkNotNullParameter((Object)sendReplyService, (String)"sendReplyService");
        this.result = "";
        this.trackingAggregateRootDict = new ConcurrentHashMap();
        this.repository = repository;
        this.aggregateRootStorage = aggregateRootStorage;
        this.sendReplyService = sendReplyService;
        this.queueMessage = queueMessage;
        this.genericCommandMessage = genericCommandMessage;
        this.messageContext = messageContext;
    }

    @Override
    @NotNull
    public String getResult() {
        return this.result;
    }

    @Override
    public void setResult(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.result = string;
    }

    @Override
    @Nullable
    public ApplicationMessage getApplicationMessage() {
        return this.applicationMessage;
    }

    @Override
    public void setApplicationMessage(@Nullable ApplicationMessage applicationMessage) {
        this.applicationMessage = applicationMessage;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> onCommandExecutedAsync(@NotNull CommandResult commandResult) {
        Intrinsics.checkNotNullParameter((Object)commandResult, (String)"commandResult");
        this.messageContext.onMessageHandled(this.queueMessage);
        return Strings.isNullOrEmpty((String)this.genericCommandMessage.getReplyAddress()) ? Task.completedTask : this.sendReplyService.sendCommandReply(commandResult, this.genericCommandMessage.getReplyAddress());
    }

    @Override
    @Nullable
    public Object add(@NotNull AggregateRoot aggregateRoot, @NotNull Continuation<? super Unit> $completion) {
        Object object = FutureKt.await((CompletionStage)this.addAsync(aggregateRoot), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void addInternal(AggregateRoot aggregateRoot) {
        Assert.nonNull(aggregateRoot, "aggregateRoot");
        if (this.trackingAggregateRootDict.containsKey(aggregateRoot.getUniqueId())) {
            throw new AggregateRootAlreadyExistException(aggregateRoot.getUniqueId(), aggregateRoot.getClass());
        }
        ((Map)this.trackingAggregateRootDict).put(aggregateRoot.getUniqueId(), aggregateRoot);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> addAsync(@NotNull AggregateRoot aggregateRoot) {
        Intrinsics.checkNotNullParameter((Object)aggregateRoot, (String)"aggregateRoot");
        this.addInternal(aggregateRoot);
        return Task.completedTask;
    }

    @Override
    @NotNull
    public <T extends AggregateRoot> CompletableFuture<T> getAsync(@NotNull String id, boolean firstFromCache, @NotNull Class<T> aggregateRootType) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        Assert.nonNull(id, "id");
        AggregateRoot trackingAggregateRoot = (AggregateRoot)this.trackingAggregateRootDict.get(id);
        CompletableFuture<AggregateRoot> future = new CompletableFuture<AggregateRoot>();
        if (trackingAggregateRoot != null) {
            future.complete(trackingAggregateRoot);
            return future;
        }
        future = firstFromCache ? this.repository.getAsync(aggregateRootType, id) : this.aggregateRootStorage.getAsync(aggregateRootType, id);
        CompletionStage completionStage = future.thenApply(arg_0 -> DefaultCommandExecuteContext.getAsync$lambda$0((Function1)new Function1<T, T>(id, aggregateRootType, this){
            final /* synthetic */ String $id;
            final /* synthetic */ Class<T> $aggregateRootType;
            final /* synthetic */ DefaultCommandExecuteContext this$0;
            {
                this.$id = $id;
                this.$aggregateRootType = $aggregateRootType;
                this.this$0 = $receiver;
                super(1);
            }

            public final T invoke(T aggregateRoot) {
                if (aggregateRoot == null) {
                    throw new AggregateRootNotFoundException(this.$id, this.$aggregateRootType);
                }
                ((Map)DefaultCommandExecuteContext.access$getTrackingAggregateRootDict$p(this.this$0)).put(aggregateRoot.getUniqueId(), aggregateRoot);
                DefaultCommandExecuteContext.access$getRepository$p(this.this$0).refreshAggregate(aggregateRoot);
                return aggregateRoot;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun <T : Aggreg\u2026egateRoot\n        }\n    }");
        return completionStage;
    }

    @Override
    @NotNull
    public <T extends AggregateRoot> CompletableFuture<T> getAsync(@NotNull String id, @NotNull Class<T> aggregateRootType) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        return this.getAsync(id, true, aggregateRootType);
    }

    @Override
    @Nullable
    public <T extends AggregateRoot> Object get(@NotNull String id, boolean firstFromCache, @NotNull Class<T> aggregateRootType, @NotNull Continuation<? super T> $completion) {
        return FutureKt.await((CompletionStage)this.getAsync(id, firstFromCache, aggregateRootType), $completion);
    }

    @Override
    @Nullable
    public <T extends AggregateRoot> Object get(@NotNull String id, @NotNull Class<T> aggregateRootType, @NotNull Continuation<? super T> $completion) {
        return FutureKt.await((CompletionStage)this.getAsync(id, aggregateRootType), $completion);
    }

    @Override
    @NotNull
    public List<AggregateRoot> getTrackedAggregateRoots() {
        return new ArrayList(this.trackingAggregateRootDict.values());
    }

    @Override
    public void clear() {
        this.trackingAggregateRootDict.clear();
        this.setResult("");
    }

    private static final AggregateRoot getAsync$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AggregateRoot)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ConcurrentMap access$getTrackingAggregateRootDict$p(DefaultCommandExecuteContext $this) {
        return $this.trackingAggregateRootDict;
    }

    public static final /* synthetic */ Repository access$getRepository$p(DefaultCommandExecuteContext $this) {
        return $this.repository;
    }
}

