/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.commanding.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import org.enodeframework.commanding.CommandProcessor;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.commanding.ProcessingCommandHandler;
import org.enodeframework.commanding.ProcessingCommandMailbox;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.scheduling.ScheduleService;
import org.enodeframework.common.utils.Assert;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0016R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/enodeframework/commanding/impl/DefaultCommandProcessor;", "Lorg/enodeframework/commanding/CommandProcessor;", "processingCommandHandler", "Lorg/enodeframework/commanding/ProcessingCommandHandler;", "scheduleService", "Lorg/enodeframework/common/scheduling/ScheduleService;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lorg/enodeframework/commanding/ProcessingCommandHandler;Lorg/enodeframework/common/scheduling/ScheduleService;Lkotlinx/coroutines/CoroutineDispatcher;)V", "scanExpiredAggregateIntervalMilliseconds", "", "aggregateRootMaxInactiveSeconds", "commandMailBoxPersistenceMaxBatchSize", "(Lorg/enodeframework/commanding/ProcessingCommandHandler;Lorg/enodeframework/common/scheduling/ScheduleService;Lkotlinx/coroutines/CoroutineDispatcher;III)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mailboxDict", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/enodeframework/commanding/ProcessingCommandMailbox;", "taskName", "cleanInactiveMailbox", "", "isMailBoxAllowRemove", "", "mailbox", "process", "processingCommand", "Lorg/enodeframework/commanding/ProcessingCommand;", "start", "stop", "enode"})
@SourceDebugExtension(value={"SMAP\nDefaultCommandProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCommandProcessor.kt\norg/enodeframework/commanding/impl/DefaultCommandProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n766#2:118\n857#2,2:119\n1855#2,2:121\n*S KotlinDebug\n*F\n+ 1 DefaultCommandProcessor.kt\norg/enodeframework/commanding/impl/DefaultCommandProcessor\n*L\n100#1:118\n100#1:119,2\n101#1:121,2\n*E\n"})
public final class DefaultCommandProcessor
implements CommandProcessor {
    @NotNull
    private final ProcessingCommandHandler processingCommandHandler;
    @NotNull
    private final ScheduleService scheduleService;
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    private final int scanExpiredAggregateIntervalMilliseconds;
    private final int aggregateRootMaxInactiveSeconds;
    private final int commandMailBoxPersistenceMaxBatchSize;
    private final Logger logger;
    @NotNull
    private final ConcurrentMap<String, ProcessingCommandMailbox> mailboxDict;
    @NotNull
    private final String taskName;

    public DefaultCommandProcessor(@NotNull ProcessingCommandHandler processingCommandHandler, @NotNull ScheduleService scheduleService, @NotNull CoroutineDispatcher coroutineDispatcher, int scanExpiredAggregateIntervalMilliseconds, int aggregateRootMaxInactiveSeconds, int commandMailBoxPersistenceMaxBatchSize) {
        Intrinsics.checkNotNullParameter((Object)processingCommandHandler, (String)"processingCommandHandler");
        Intrinsics.checkNotNullParameter((Object)scheduleService, (String)"scheduleService");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        this.processingCommandHandler = processingCommandHandler;
        this.scheduleService = scheduleService;
        this.coroutineDispatcher = coroutineDispatcher;
        this.scanExpiredAggregateIntervalMilliseconds = scanExpiredAggregateIntervalMilliseconds;
        this.aggregateRootMaxInactiveSeconds = aggregateRootMaxInactiveSeconds;
        this.commandMailBoxPersistenceMaxBatchSize = commandMailBoxPersistenceMaxBatchSize;
        this.logger = LoggerFactory.getLogger(DefaultCommandProcessor.class);
        this.mailboxDict = new ConcurrentHashMap();
        this.taskName = "CleanInactiveProcessingCommandMailBoxes_" + System.nanoTime() + new Random().nextInt(10000);
    }

    public /* synthetic */ DefaultCommandProcessor(ProcessingCommandHandler processingCommandHandler, ScheduleService scheduleService, CoroutineDispatcher coroutineDispatcher, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            n = 5000;
        }
        if ((n4 & 0x10) != 0) {
            n2 = 259200;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 1000;
        }
        this(processingCommandHandler, scheduleService, coroutineDispatcher, n, n2, n3);
    }

    public DefaultCommandProcessor(@NotNull ProcessingCommandHandler processingCommandHandler, @NotNull ScheduleService scheduleService, @NotNull CoroutineDispatcher coroutineDispatcher) {
        Intrinsics.checkNotNullParameter((Object)processingCommandHandler, (String)"processingCommandHandler");
        Intrinsics.checkNotNullParameter((Object)scheduleService, (String)"scheduleService");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        this(processingCommandHandler, scheduleService, coroutineDispatcher, 5000, 259200, 1000);
    }

    @Override
    public void process(@NotNull ProcessingCommand processingCommand) {
        Intrinsics.checkNotNullParameter((Object)processingCommand, (String)"processingCommand");
        String aggregateRootId = processingCommand.getMessage().getAggregateRootId();
        Assert.nonNullOrEmpty(aggregateRootId, "aggregateRootId of command, commandId: " + processingCommand.getMessage().getId());
        ProcessingCommandMailbox mailbox2 = this.mailboxDict.computeIfAbsent(aggregateRootId, arg_0 -> DefaultCommandProcessor.process$lambda$0((Function1)new Function1<String, ProcessingCommandMailbox>(this){
            final /* synthetic */ DefaultCommandProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final ProcessingCommandMailbox invoke(@NotNull String x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                return new ProcessingCommandMailbox(x, DefaultCommandProcessor.access$getProcessingCommandHandler$p(this.this$0), DefaultCommandProcessor.access$getCoroutineDispatcher$p(this.this$0), DefaultCommandProcessor.access$getCommandMailBoxPersistenceMaxBatchSize$p(this.this$0));
            }
        }, arg_0));
        long mailboxTryUsingCount = 0L;
        while (!mailbox2.tryUsing()) {
            Task.sleep(1L);
            long l = mailboxTryUsingCount;
            if ((mailboxTryUsingCount = l + 1L) % (long)10000 != 0L) continue;
            this.logger.warn("Command mailbox try using count: {}, aggregateRootId: {}", (Object)mailboxTryUsingCount, (Object)mailbox2.getAggregateRootId());
        }
        if (mailbox2.isRemoved()) {
            mailbox2 = this.mailboxDict.computeIfAbsent(aggregateRootId, arg_0 -> DefaultCommandProcessor.process$lambda$1((Function1)new Function1<String, ProcessingCommandMailbox>(this){
                final /* synthetic */ DefaultCommandProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final ProcessingCommandMailbox invoke(@NotNull String x) {
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    return new ProcessingCommandMailbox(x, DefaultCommandProcessor.access$getProcessingCommandHandler$p(this.this$0), DefaultCommandProcessor.access$getCoroutineDispatcher$p(this.this$0), DefaultCommandProcessor.access$getCommandMailBoxPersistenceMaxBatchSize$p(this.this$0));
                }
            }, arg_0));
        }
        mailbox2.enqueueMessage(processingCommand);
        mailbox2.exitUsing();
    }

    @Override
    public void start() {
        this.scheduleService.startTask(this.taskName, () -> DefaultCommandProcessor.start$lambda$2(this), this.scanExpiredAggregateIntervalMilliseconds, this.scanExpiredAggregateIntervalMilliseconds);
    }

    @Override
    public void stop() {
        this.scheduleService.stopTask(this.taskName);
    }

    private final boolean isMailBoxAllowRemove(ProcessingCommandMailbox mailbox2) {
        return mailbox2.isInactive(this.aggregateRootMaxInactiveSeconds) && !mailbox2.isRunning() && mailbox2.getTotalUnHandledMessageCount() == 0L;
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanInactiveMailbox() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.mailboxDict.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"entry.value");
            if (!this.isMailBoxAllowRemove((ProcessingCommandMailbox)v)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inactiveList = (List)destination$iv$iv;
        Iterable $this$forEach$iv = inactiveList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessingCommandMailbox removed;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            if (!this.isMailBoxAllowRemove((ProcessingCommandMailbox)entry.getValue()) || (removed = (ProcessingCommandMailbox)this.mailboxDict.remove(entry.getKey())) == null) continue;
            removed.markAsRemoved();
            this.logger.info("Removed inactive command mailbox, aggregateRootId: {}", entry.getKey());
        }
    }

    private static final ProcessingCommandMailbox process$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProcessingCommandMailbox)$tmp0.invoke(p0);
    }

    private static final ProcessingCommandMailbox process$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProcessingCommandMailbox)$tmp0.invoke(p0);
    }

    private static final void start$lambda$2(DefaultCommandProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cleanInactiveMailbox();
    }

    public static final /* synthetic */ ProcessingCommandHandler access$getProcessingCommandHandler$p(DefaultCommandProcessor $this) {
        return $this.processingCommandHandler;
    }

    public static final /* synthetic */ CoroutineDispatcher access$getCoroutineDispatcher$p(DefaultCommandProcessor $this) {
        return $this.coroutineDispatcher;
    }

    public static final /* synthetic */ int access$getCommandMailBoxPersistenceMaxBatchSize$p(DefaultCommandProcessor $this) {
        return $this.commandMailBoxPersistenceMaxBatchSize;
    }
}

