/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.common.extensions;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.enodeframework.common.extensions.ClassNameComparator;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathScanHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassPathScanHandler.class);
    private static final String CLASS_EXTENSION_NAME = ".class";
    private boolean excludeInner = true;
    private boolean checkInOrEx = true;
    private List<String> classFilters = null;
    private Reflections reflections = null;

    public ClassPathScanHandler(String ... scanPackages) {
        this.reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackages(scanPackages));
    }

    public ClassPathScanHandler(Boolean excludeInner, Boolean checkInOrEx, List<String> classFilters) {
        this.excludeInner = excludeInner;
        this.checkInOrEx = checkInOrEx;
        this.classFilters = classFilters;
    }

    public Set<Class<?>> getAllClassesWithAnnotation(Class<? extends Annotation> annotation, boolean honorInherited) {
        return this.reflections.getTypesAnnotatedWith(annotation, honorInherited);
    }

    public <T> Set<Class<? extends T>> getAllSubClassesByParent(Class<T> parent) {
        return this.reflections.getSubTypesOf(parent);
    }

    public Set<Class<?>> getPackageAllClasses(String basePackage, boolean recursive) {
        if (basePackage == null) {
            return new HashSet();
        }
        LinkedHashSet classes = new LinkedHashSet();
        String packageName = basePackage;
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.lastIndexOf(46));
        }
        String package2Path = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(package2Path);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    this.doScanPackageClassesByFile(classes, packageName, filePath, recursive);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                this.doScanPackageClassesByJar(packageName, url, recursive, classes);
            }
        }
        catch (IOException e) {
            LOGGER.error("ignore this IOException", (Throwable)e);
        }
        TreeSet sortedClasses = new TreeSet(new ClassNameComparator());
        sortedClasses.addAll(classes);
        return sortedClasses;
    }

    private void doScanPackageClassesByJar(String basePackage, URL url, boolean recursive, Set<Class<?>> classes) {
        String package2Path = basePackage.replace('.', '/');
        try {
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(package2Path) || entry.isDirectory() || !recursive && name.lastIndexOf(47) != package2Path.length()) continue;
                if (this.excludeInner && name.indexOf(36) != -1) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("exclude inner class with name: {}", (Object)name);
                    continue;
                }
                String classSimpleName = name.substring(name.lastIndexOf(47) + 1);
                if (!this.filterClassName(classSimpleName)) continue;
                String className = name.replace('/', '.');
                className = className.substring(0, className.length() - 6);
                try {
                    classes.add(Thread.currentThread().getContextClassLoader().loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class.forName error:URL is {}", (Object)url.getPath());
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException error:URL is {}", (Object)url.getPath());
        }
        catch (Throwable e) {
            LOGGER.error("ScanPackageClassesByJar error:URL is {}", (Object)url.getPath());
        }
    }

    private void doScanPackageClassesByFile(Set<Class<?>> classes, String packageName, String packagePath, boolean recursive) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles(pathname -> this.filterClassFileByCustomization(pathname, recursive));
        if (null == files) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.doScanPackageClassesByFile(classes, packageName + "." + file.getName(), file.getAbsolutePath(), recursive);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - CLASS_EXTENSION_NAME.length());
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("IOException error:");
            }
        }
    }

    private boolean filterClassFileByCustomization(@Nonnull File file, boolean recursive) {
        if (file.isDirectory()) {
            return recursive;
        }
        String filename = file.getName();
        if (this.excludeInner && filename.indexOf(36) != -1) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exclude inner class with name:{}", (Object)filename);
            }
            return false;
        }
        return this.filterClassName(filename);
    }

    private boolean filterClassName(String className) {
        String str;
        if (!className.endsWith(CLASS_EXTENSION_NAME)) {
            return false;
        }
        if (null == this.classFilters || this.classFilters.isEmpty()) {
            return true;
        }
        String tmpName = className.substring(0, className.length() - 6);
        boolean flag = false;
        Iterator<String> iterator = this.classFilters.iterator();
        while (iterator.hasNext() && !(flag = this.matchInnerClassname(tmpName, str = iterator.next()))) {
        }
        return this.checkInOrEx && flag || !this.checkInOrEx && !flag;
    }

    private boolean matchInnerClassname(String className, String filterString) {
        String reg = "^" + filterString.replace("*", ".*") + "$";
        Pattern p = Pattern.compile(reg);
        return p.matcher(className).find();
    }
}

