/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.common.extensions;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.enodeframework.messaging.Message;

public interface MessageMonitor<T extends Message> {
    public MonitorCallback onMessageIngested(T var1);

    default public Map<? super T, MonitorCallback> onMessagesIngested(Collection<? extends T> messages) {
        return messages.stream().collect(Collectors.toMap(msg -> msg, this::onMessageIngested));
    }

    public static interface MonitorCallback {
        public void reportSuccess();

        public void reportFailure(Throwable var1);

        public void reportIgnored();
    }
}

