/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.common.extensions;

import com.google.common.base.Strings;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import org.enodeframework.common.exception.IdGenerateException;
import org.enodeframework.common.extensions.SystemClock;

public class SnowFlake {
    private static final long START_STAMP = 1480166465631L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MACHINE_BIT = 5L;
    private static final long DATACENTER_BIT = 5L;
    private static final long MAX_DATACENTER_NUM = 31L;
    private static final long MAX_MACHINE_NUM = 31L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_LEFT = 12L;
    private static final long DATACENTER_LEFT = 17L;
    private static final long TIMESTAMP_LEFT = 22L;
    private final long datacenterId;
    private final long machineId;
    private long sequence = 0L;
    private long lastStamp = -1L;

    public SnowFlake() {
        this.datacenterId = this.getDatacenterId();
        this.machineId = this.getMachineId(this.datacenterId);
    }

    public SnowFlake(long datacenterId, long machineId) {
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException("datacenterId can't be greater than MAX_DATACENTER_NUM or less than 0");
        }
        if (machineId > 31L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than MAX_MACHINE_NUM or less than 0");
        }
        this.datacenterId = datacenterId;
        this.machineId = machineId;
    }

    private long getMachineId(long datacenterId) {
        StringBuilder machineId = new StringBuilder();
        machineId.append(datacenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (!Strings.isNullOrEmpty((String)name)) {
            machineId.append(name.split("@")[0]);
        }
        return (long)(machineId.toString().hashCode() & 0xFFFF) % 32L;
    }

    private long getDatacenterId() {
        long id = 0L;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                if (null != mac) {
                    id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
                    id %= 32L;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return id;
    }

    public synchronized long nextId() {
        long currStamp = this.getStamp();
        if (currStamp < this.lastStamp) {
            throw new IdGenerateException("Clock moved backwards. Refusing to generate id");
        }
        if (currStamp == this.lastStamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currStamp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStamp = currStamp;
        return currStamp - 1480166465631L << 22 | this.datacenterId << 17 | this.machineId << 12 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getStamp();
        while (mill <= this.lastStamp) {
            mill = this.getStamp();
        }
        return mill;
    }

    private long getStamp() {
        return SystemClock.now();
    }
}

