/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.common.io;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.exception.IORuntimeException;
import org.enodeframework.common.function.Action1;
import org.enodeframework.common.function.Action2;
import org.enodeframework.common.function.DelayedTask;
import org.enodeframework.common.function.Func;
import org.enodeframework.common.utils.Assert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jn\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J~\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0007Jn\u0010\u001a\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J0\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001c0\r\"\u0004\b\u0000\u0010\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0\r0\f2\u0006\u0010\u001e\u001a\u00020\nH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/enodeframework/common/io/IOHelper;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "tryAsyncActionRecursively", "", "TAsyncResult", "asyncActionName", "", "asyncAction", "Lorg/enodeframework/common/function/Func;", "Ljava/util/concurrent/CompletableFuture;", "successAction", "Lorg/enodeframework/common/function/Action1;", "getContextInfoFunc", "failedAction", "Lorg/enodeframework/common/function/Action2;", "", "retryTimes", "", "retryWhenFailed", "", "maxRetryTimes", "retryInterval", "tryAsyncActionRecursivelyWithoutResult", "tryIOFuncAsync", "T", "func", "funcName", "AsyncTaskExecutionContext", "enode"})
public final class IOHelper {
    @NotNull
    public static final IOHelper INSTANCE = new IOHelper();
    private static final Logger logger = LoggerFactory.getLogger(IOHelper.class);

    private IOHelper() {
    }

    @JvmStatic
    public static final <TAsyncResult> void tryAsyncActionRecursively(@NotNull String asyncActionName, @NotNull Func<CompletableFuture<TAsyncResult>> asyncAction, @NotNull Action1<TAsyncResult> successAction, @NotNull Func<String> getContextInfoFunc, @Nullable Action2<Throwable, String> failedAction, int retryTimes, boolean retryWhenFailed) {
        Intrinsics.checkNotNullParameter((Object)asyncActionName, (String)"asyncActionName");
        Intrinsics.checkNotNullParameter(asyncAction, (String)"asyncAction");
        Intrinsics.checkNotNullParameter(successAction, (String)"successAction");
        Intrinsics.checkNotNullParameter(getContextInfoFunc, (String)"getContextInfoFunc");
        IOHelper.tryAsyncActionRecursively(asyncActionName, asyncAction, successAction, getContextInfoFunc, failedAction, retryTimes, retryWhenFailed, 3, 1000);
    }

    @JvmStatic
    public static final <TAsyncResult> void tryAsyncActionRecursively(@NotNull String asyncActionName, @NotNull Func<CompletableFuture<TAsyncResult>> asyncAction, @NotNull Action1<TAsyncResult> successAction, @NotNull Func<String> getContextInfoFunc, @Nullable Action2<Throwable, String> failedAction, int retryTimes, boolean retryWhenFailed, int maxRetryTimes, int retryInterval) {
        Intrinsics.checkNotNullParameter((Object)asyncActionName, (String)"asyncActionName");
        Intrinsics.checkNotNullParameter(asyncAction, (String)"asyncAction");
        Intrinsics.checkNotNullParameter(successAction, (String)"successAction");
        Intrinsics.checkNotNullParameter(getContextInfoFunc, (String)"getContextInfoFunc");
        AsyncTaskExecutionContext<TAsyncResult> asyncTaskExecutionContext = new AsyncTaskExecutionContext<TAsyncResult>(asyncActionName, asyncAction, successAction, getContextInfoFunc, failedAction, retryTimes, retryWhenFailed, maxRetryTimes, retryInterval);
        asyncTaskExecutionContext.execute();
    }

    @JvmStatic
    public static final <TAsyncResult> void tryAsyncActionRecursivelyWithoutResult(@NotNull String asyncActionName, @NotNull Func<CompletableFuture<TAsyncResult>> asyncAction, @NotNull Action1<TAsyncResult> successAction, @NotNull Func<String> getContextInfoFunc, @Nullable Action2<Throwable, String> failedAction, int retryTimes, boolean retryWhenFailed) {
        Intrinsics.checkNotNullParameter((Object)asyncActionName, (String)"asyncActionName");
        Intrinsics.checkNotNullParameter(asyncAction, (String)"asyncAction");
        Intrinsics.checkNotNullParameter(successAction, (String)"successAction");
        Intrinsics.checkNotNullParameter(getContextInfoFunc, (String)"getContextInfoFunc");
        AsyncTaskExecutionContext<TAsyncResult> asyncTaskExecutionContext = new AsyncTaskExecutionContext<TAsyncResult>(asyncActionName, asyncAction, successAction, getContextInfoFunc, failedAction, retryTimes, retryWhenFailed, 3, 1000);
        asyncTaskExecutionContext.execute();
    }

    @JvmStatic
    @NotNull
    public static final <T> CompletableFuture<T> tryIOFuncAsync(@NotNull Func<CompletableFuture<T>> func, @NotNull String funcName) {
        CompletableFuture<T> completableFuture;
        Intrinsics.checkNotNullParameter(func, (String)"func");
        Intrinsics.checkNotNullParameter((Object)funcName, (String)"funcName");
        Assert.nonNull(func, "func");
        Assert.nonNull(funcName, "funcName");
        try {
            CompletableFuture<T> completableFuture2 = func.apply();
            Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"{\n            func.apply()\n        }");
            completableFuture = completableFuture2;
        }
        catch (Exception ex) {
            throw new IORuntimeException(funcName + " failed.", ex);
        }
        return completableFuture;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002Bu\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0017J\u001a\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u0015\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u0004\u0018\u00010\u00042\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/enodeframework/common/io/IOHelper$AsyncTaskExecutionContext;", "TAsyncResult", "", "actionName", "", "asyncAction", "Lorg/enodeframework/common/function/Func;", "Ljava/util/concurrent/CompletableFuture;", "successAction", "Lorg/enodeframework/common/function/Action1;", "contextInfoFunc", "failedAction", "Lorg/enodeframework/common/function/Action2;", "", "retryTimes", "", "retryWhenFailed", "", "maxRetryTimes", "retryInterval", "(Ljava/lang/String;Lorg/enodeframework/common/function/Func;Lorg/enodeframework/common/function/Action1;Lorg/enodeframework/common/function/Func;Lorg/enodeframework/common/function/Action2;IZII)V", "currentRetryTimes", "doRetry", "", "execute", "executeFailedAction", "e", "errorMessage", "executeRetryAction", "executeSuccessAction", "result", "(Ljava/lang/Object;)V", "getContextInfo", "func", "processTaskException", "exception", "enode"})
    public static final class AsyncTaskExecutionContext<TAsyncResult> {
        @NotNull
        private final String actionName;
        @NotNull
        private final Func<CompletableFuture<TAsyncResult>> asyncAction;
        @NotNull
        private final Action1<TAsyncResult> successAction;
        @NotNull
        private final Func<String> contextInfoFunc;
        @Nullable
        private final Action2<Throwable, String> failedAction;
        private int currentRetryTimes;
        private final boolean retryWhenFailed;
        private final int maxRetryTimes;
        private final int retryInterval;

        public AsyncTaskExecutionContext(@NotNull String actionName, @NotNull Func<CompletableFuture<TAsyncResult>> asyncAction, @NotNull Action1<TAsyncResult> successAction, @NotNull Func<String> contextInfoFunc, @Nullable Action2<Throwable, String> failedAction, int retryTimes, boolean retryWhenFailed, int maxRetryTimes, int retryInterval) {
            Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
            Intrinsics.checkNotNullParameter(asyncAction, (String)"asyncAction");
            Intrinsics.checkNotNullParameter(successAction, (String)"successAction");
            Intrinsics.checkNotNullParameter(contextInfoFunc, (String)"contextInfoFunc");
            this.actionName = actionName;
            this.successAction = successAction;
            this.contextInfoFunc = contextInfoFunc;
            this.failedAction = failedAction;
            this.currentRetryTimes = retryTimes;
            this.retryWhenFailed = retryWhenFailed;
            this.maxRetryTimes = maxRetryTimes;
            this.retryInterval = retryInterval;
            this.asyncAction = asyncAction;
        }

        public final void execute() {
            CompletableFuture<Object> asyncResult = new CompletableFuture();
            try {
                CompletableFuture<TAsyncResult> completableFuture = this.asyncAction.apply();
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"asyncAction.apply()");
                asyncResult = completableFuture;
            }
            catch (Exception ex) {
                asyncResult.completeExceptionally(ex);
            }
            if (asyncResult.isCancelled()) {
                asyncResult.exceptionally(arg_0 -> AsyncTaskExecutionContext.execute$lambda$0(this, arg_0));
                return;
            }
            ((CompletableFuture)asyncResult.thenAccept(arg_0 -> AsyncTaskExecutionContext.execute$lambda$1((Function1)new Function1<TAsyncResult, Unit>(this){
                final /* synthetic */ AsyncTaskExecutionContext<TAsyncResult> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(TAsyncResult result) {
                    AsyncTaskExecutionContext.access$executeSuccessAction(this.this$0, result);
                }
            }, arg_0))).exceptionally(arg_0 -> AsyncTaskExecutionContext.execute$lambda$2(this, arg_0));
        }

        private final void executeRetryAction() {
            try {
                if (this.currentRetryTimes >= this.maxRetryTimes) {
                    DelayedTask.startDelayedTask(Duration.ofMillis(this.retryInterval), () -> AsyncTaskExecutionContext.executeRetryAction$lambda$3(this));
                } else {
                    this.doRetry();
                }
            }
            catch (Exception ex) {
                Object[] objectArray = new Object[]{this.actionName, this.getContextInfo(this.contextInfoFunc), ex};
                logger.error("Failed to execute the retryAction, actionName:{}, contextInfo:{}", objectArray);
            }
        }

        private final void doRetry() {
            int n = this.currentRetryTimes;
            this.currentRetryTimes = n + 1;
            this.execute();
        }

        private final void executeSuccessAction(TAsyncResult result) {
            try {
                this.successAction.apply(result);
            }
            catch (Exception ex) {
                Object[] objectArray = new Object[]{this.actionName, this.getContextInfo(this.contextInfoFunc), ex};
                logger.error("Failed to execute the successAction, actionName:{}, contextInfo:{}", objectArray);
            }
        }

        private final void executeFailedAction(Throwable e, String errorMessage) {
            try {
                Action2<Throwable, String> action2 = this.failedAction;
                if (action2 != null) {
                    action2.apply(e, errorMessage);
                }
            }
            catch (Exception ex) {
                Object[] objectArray = new Object[]{this.actionName, this.getContextInfo(this.contextInfoFunc), ex};
                logger.error("Failed to execute the failedAction of action:{}, contextInfo:{}", objectArray);
            }
        }

        private final String getContextInfo(Func<String> func) {
            String string;
            try {
                string = func.apply();
            }
            catch (Exception ex) {
                logger.error("Failed to execute the getContextInfoFunc.", (Throwable)ex);
                string = "";
            }
            return string;
        }

        private final void processTaskException(Throwable exception) {
            if (exception instanceof IORuntimeException) {
                Object[] objectArray = new Object[]{this.actionName, this.getContextInfo(this.contextInfoFunc), this.currentRetryTimes, exception};
                logger.error("Async task '{}' has io exception, contextInfo:{}, current retryTimes:{}, try to run the async task again.", objectArray);
                this.executeRetryAction();
            } else if (exception instanceof CompletionException && exception.getCause() instanceof IORuntimeException) {
                Object[] objectArray = new Object[]{this.actionName, this.getContextInfo(this.contextInfoFunc), this.currentRetryTimes, exception};
                logger.error("Async task '{}' has io exception, contextInfo:{}, current retryTimes:{}, try to run the async task again.", objectArray);
                this.executeRetryAction();
            } else {
                Object[] objectArray = new Object[]{this.actionName, this.getContextInfo(this.contextInfoFunc), this.currentRetryTimes, exception};
                logger.error("Task '{}' has unknown exception, contextInfo:{}, current retryTimes:{}", objectArray);
                if (this.retryWhenFailed) {
                    this.executeRetryAction();
                } else {
                    this.executeFailedAction(exception, exception.getMessage());
                }
            }
        }

        private static final Object execute$lambda$0(AsyncTaskExecutionContext this$0, Throwable ex) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            Object[] objectArray = new Object[]{this$0.actionName, this$0.getContextInfo(this$0.contextInfoFunc), this$0.currentRetryTimes, ex};
            logger.error("Task '{}' was cancelled, contextInfo: {}, current retryTimes: {}.", objectArray);
            this$0.executeFailedAction(ex, "Task '" + this$0.actionName + "' was cancelled.");
            return null;
        }

        private static final void execute$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final Void execute$lambda$2(AsyncTaskExecutionContext this$0, Throwable ex) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            this$0.processTaskException(ex);
            return null;
        }

        private static final void executeRetryAction$lambda$3(AsyncTaskExecutionContext this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.doRetry();
        }

        public static final /* synthetic */ void access$executeSuccessAction(AsyncTaskExecutionContext $this, Object result) {
            $this.executeSuccessAction(result);
        }
    }
}

