/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.common.io;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.exception.EnodeInterruptException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u0004H\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/enodeframework/common/io/Task;", "", "()V", "completedTask", "Ljava/util/concurrent/CompletableFuture;", "", "emptyTask", "", "await", "T", "future", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/Object;", "", "latch", "Ljava/util/concurrent/CountDownLatch;", "sleep", "sleepMilliseconds", "", "enode"})
public final class Task {
    @NotNull
    public static final Task INSTANCE = new Task();
    @JvmField
    @NotNull
    public static CompletableFuture<Boolean> completedTask;
    @JvmField
    @NotNull
    public static CompletableFuture emptyTask;

    private Task() {
    }

    @JvmStatic
    public static final void await(@NotNull CountDownLatch latch) {
        Intrinsics.checkNotNullParameter((Object)latch, (String)"latch");
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new EnodeInterruptException(e);
        }
    }

    @JvmStatic
    public static final <T> T await(@NotNull CompletableFuture<T> future) {
        Intrinsics.checkNotNullParameter(future, (String)"future");
        return future.join();
    }

    @JvmStatic
    public static final void sleep(long sleepMilliseconds) {
        try {
            Thread.sleep(sleepMilliseconds);
        }
        catch (InterruptedException e) {
            throw new EnodeInterruptException(e);
        }
    }

    static {
        CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(true);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(true)");
        completedTask = completableFuture;
        CompletableFuture<Object> completableFuture2 = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(null)");
        emptyTask = completableFuture2;
    }
}

