/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.common.scheduling;

import org.enodeframework.common.function.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker {
    private static final Logger logger = LoggerFactory.getLogger(Worker.class);
    private final Object lockObject = new Object();
    private final String actionName;
    private final Action action;
    private Status status;
    private Thread thread;

    public Worker(String actionName, Action action) {
        this.actionName = actionName;
        this.action = action;
        this.status = Status.Initial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worker start() {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.status.equals((Object)Status.Running)) {
                return this;
            }
            this.status = Status.Running;
            this.thread = new Thread(this::loop, String.format("%s.Worker", this.actionName));
            this.thread.setDaemon(true);
            this.thread.start();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worker stop() {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.status.equals((Object)Status.StopRequested)) {
                return this;
            }
            this.status = Status.StopRequested;
            logger.info("Worker thread shutdown, thread id:{}", (Object)this.thread.getName());
            this.thread.interrupt();
            return this;
        }
    }

    private void loop() {
        while (this.status == Status.Running) {
            try {
                this.action.apply();
            }
            catch (Exception ex) {
                logger.error("Worker thread has exception, actionName: {}", (Object)this.actionName, (Object)ex);
            }
        }
    }

    static enum Status {
        Initial,
        Running,
        StopRequested;

    }
}

