/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.common.serializing;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.exception.EnodeException;
import org.enodeframework.common.serializing.SerializeService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/enodeframework/common/serializing/DefaultSerializeService;", "Lorg/enodeframework/common/serializing/SerializeService;", "()V", "deserialize", "T", "value", "", "type", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "serialize", "target", "", "Companion", "enode"})
public final class DefaultSerializeService
implements SerializeService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(MapperFeature.AUTO_DETECT_FIELDS, true)).build();

    @Override
    public <T> T deserialize(@NotNull String value, @NotNull Class<T> type) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        try {
            object = MAPPER.readValue(value, type);
        }
        catch (JsonProcessingException e) {
            throw new EnodeException(e);
        }
        return (T)object;
    }

    @Override
    @NotNull
    public String serialize(@NotNull Object target) {
        String string;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        try {
            String string2 = MAPPER.writeValueAsString(target);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            MAPPER.wri\u2026sString(target)\n        }");
            string = string2;
        }
        catch (JsonProcessingException e) {
            throw new EnodeException(e);
        }
        return string;
    }

    static {
        MAPPER.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/common/serializing/DefaultSerializeService$Companion;", "", "()V", "MAPPER", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

