/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.enodeframework.common.function.Action2;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.impl.DefaultAggregateRootInternalHandlerProvider;
import org.enodeframework.eventing.DomainEventMessage;
import org.enodeframework.eventing.DomainEventStream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAggregateRoot
implements AggregateRoot {
    private final List<DomainEventMessage> emptyEvents = Collections.emptyList();
    protected String id;
    protected int version;
    private Queue<DomainEventMessage> uncommittedEvents = new ConcurrentLinkedQueue<DomainEventMessage>();

    protected AbstractAggregateRoot() {
    }

    protected AbstractAggregateRoot(String id) {
        this(id, 0);
    }

    protected AbstractAggregateRoot(String id, int version) {
        this();
        Assert.nonNull(id, "id");
        this.id = id;
        if (version < 0) {
            throw new IllegalArgumentException(String.format("Version cannot small than zero, aggregateRootId: %s, version: %d", id, version));
        }
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    protected void applyEvent(DomainEventMessage domainEvent) {
        Assert.nonNull(domainEvent, "domainEvent");
        Assert.nonNull(this.id, "AggregateRootId");
        domainEvent.setAggregateRootId(this.id);
        domainEvent.setVersion(this.version + 1);
        this.handleEvent(domainEvent);
        this.appendUncommittedEvent(domainEvent);
    }

    protected void applyEvents(List<DomainEventMessage> domainEvents) {
        for (DomainEventMessage domainEvent : domainEvents) {
            this.applyEvent(domainEvent);
        }
    }

    private void handleEvent(DomainEventMessage domainEvent) {
        Action2<AggregateRoot, DomainEventMessage> handler = DefaultAggregateRootInternalHandlerProvider.Dict.getInternalEventHandler(this.getClass(), domainEvent.getClass());
        if (this.id == null && domainEvent.getVersion() == 1) {
            this.id = domainEvent.getAggregateRootId();
        }
        handler.apply(this, domainEvent);
    }

    private void appendUncommittedEvent(DomainEventMessage domainEvent) {
        if (this.uncommittedEvents == null) {
            this.uncommittedEvents = new ConcurrentLinkedQueue<DomainEventMessage>();
        }
        if (this.uncommittedEvents.stream().anyMatch(x -> x.getClass().equals(domainEvent.getClass()))) {
            throw new UnsupportedOperationException(String.format("Cannot apply duplicated domain event type: %s, current aggregateRoot type: %s, id: %s", domainEvent.getClass(), this.getClass().getName(), this.id));
        }
        this.uncommittedEvents.add(domainEvent);
    }

    private void verifyEvent(DomainEventStream domainEventStream) {
        if (domainEventStream.getVersion() > 1 && !domainEventStream.getAggregateRootId().equals(this.id)) {
            throw new UnsupportedOperationException(String.format("Invalid domain event stream, aggregateRootId:%s, expected aggregateRootId:%s, type:%s", domainEventStream.getAggregateRootId(), this.id, this.getClass().getName()));
        }
        if (domainEventStream.getVersion() != this.getVersion() + 1) {
            throw new UnsupportedOperationException(String.format("Invalid domain event stream, version:%d, expected version:%d, current aggregateRoot type:%s, id:%s", domainEventStream.getVersion(), this.getVersion(), this.getClass().getName(), this.id));
        }
    }

    @Override
    @NotNull
    public String getUniqueId() {
        return Objects.toString(this.id, "");
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public List<DomainEventMessage> getChanges() {
        if (this.uncommittedEvents == null) {
            return this.emptyEvents;
        }
        return Lists.newArrayList(this.uncommittedEvents);
    }

    @Override
    public void acceptChanges() {
        if (this.uncommittedEvents == null || this.uncommittedEvents.isEmpty()) {
            return;
        }
        this.version = this.uncommittedEvents.peek().getVersion();
        this.uncommittedEvents.clear();
    }

    @Override
    public void replayEvents(List<DomainEventStream> domainEventStreams) {
        if (domainEventStreams == null || domainEventStreams.isEmpty()) {
            return;
        }
        domainEventStreams.forEach(eventStream -> {
            this.verifyEvent((DomainEventStream)eventStream);
            eventStream.getEvents().forEach(this::handleEvent);
            this.version = eventStream.getVersion();
        });
    }
}

