/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain;

import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.extensions.SystemClock;
import org.enodeframework.domain.AggregateRoot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/enodeframework/domain/AggregateCacheInfo;", "", "aggregateRoot", "Lorg/enodeframework/domain/AggregateRoot;", "(Lorg/enodeframework/domain/AggregateRoot;)V", "getAggregateRoot", "()Lorg/enodeframework/domain/AggregateRoot;", "setAggregateRoot", "lastUpdateTime", "Ljava/util/Date;", "isExpired", "", "timeoutSeconds", "", "updateAggregateRoot", "", "enode"})
public final class AggregateCacheInfo {
    @NotNull
    private AggregateRoot aggregateRoot;
    @NotNull
    private Date lastUpdateTime;

    public AggregateCacheInfo(@NotNull AggregateRoot aggregateRoot) {
        Intrinsics.checkNotNullParameter((Object)aggregateRoot, (String)"aggregateRoot");
        this.aggregateRoot = aggregateRoot;
        this.lastUpdateTime = new Date();
    }

    @NotNull
    public final AggregateRoot getAggregateRoot() {
        return this.aggregateRoot;
    }

    public final void setAggregateRoot(@NotNull AggregateRoot aggregateRoot) {
        Intrinsics.checkNotNullParameter((Object)aggregateRoot, (String)"<set-?>");
        this.aggregateRoot = aggregateRoot;
    }

    public final void updateAggregateRoot(@NotNull AggregateRoot aggregateRoot) {
        Intrinsics.checkNotNullParameter((Object)aggregateRoot, (String)"aggregateRoot");
        this.aggregateRoot = aggregateRoot;
        this.lastUpdateTime = new Date();
    }

    public final boolean isExpired(int timeoutSeconds) {
        return (SystemClock.now() - this.lastUpdateTime.getTime()) / (long)1000 >= (long)timeoutSeconds;
    }
}

