/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.enodeframework.common.exception.AggregateRootReferenceChangedException;
import org.enodeframework.common.exception.AggregateRootTypeNotMatchException;
import org.enodeframework.common.scheduling.ScheduleService;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.domain.AggregateCacheInfo;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.AggregateStorage;
import org.enodeframework.domain.MemoryCache;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\u0016\u001a\u00020\u0017\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u0002H\u0018H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0017H\u0002J0\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001e\"\n\b\u0000\u0010\u0018*\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00180!H\u0016J\u001f\u0010\"\u001a\u00020\u0017\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u0002H\u0018H\u0016\u00a2\u0006\u0002\u0010\u001bJ0\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001e\"\n\b\u0000\u0010\u0018*\u0004\u0018\u00010\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00180!2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J*\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001e\"\n\b\u0000\u0010\u0018*\u0004\u0018\u00010\u00192\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J&\u0010%\u001a\u00020\u00172\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\u001f\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010&\u001a\u00020\u0017H\u0016J\b\u0010'\u001a\u00020\u0017H\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/enodeframework/domain/impl/DefaultMemoryCache;", "Lorg/enodeframework/domain/MemoryCache;", "aggregateStorage", "Lorg/enodeframework/domain/AggregateStorage;", "scheduleService", "Lorg/enodeframework/common/scheduling/ScheduleService;", "typeNameProvider", "Lorg/enodeframework/infrastructure/TypeNameProvider;", "(Lorg/enodeframework/domain/AggregateStorage;Lorg/enodeframework/common/scheduling/ScheduleService;Lorg/enodeframework/infrastructure/TypeNameProvider;)V", "aggregateRootInfoDict", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/enodeframework/domain/AggregateCacheInfo;", "lockObj", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scanExpiredAggregateIntervalMilliseconds", "", "taskName", "timeoutSeconds", "acceptAggregateRootChanges", "", "T", "Lorg/enodeframework/domain/AggregateRoot;", "aggregateRoot", "(Lorg/enodeframework/domain/AggregateRoot;)V", "cleanInactiveAggregateRoot", "getAsync", "Ljava/util/concurrent/CompletableFuture;", "aggregateRootId", "aggregateRootType", "Ljava/lang/Class;", "refreshAggregate", "refreshAggregateFromEventStoreAsync", "aggregateRootTypeName", "resetAggregateRootCache", "start", "stop", "enode"})
@SourceDebugExtension(value={"SMAP\nDefaultMemoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultMemoryCache.kt\norg/enodeframework/domain/impl/DefaultMemoryCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n766#2:209\n857#2,2:210\n1855#2,2:212\n*S KotlinDebug\n*F\n+ 1 DefaultMemoryCache.kt\norg/enodeframework/domain/impl/DefaultMemoryCache\n*L\n194#1:209\n194#1:210,2\n195#1:212,2\n*E\n"})
public final class DefaultMemoryCache
implements MemoryCache {
    @NotNull
    private final AggregateStorage aggregateStorage;
    @NotNull
    private final ScheduleService scheduleService;
    @NotNull
    private final TypeNameProvider typeNameProvider;
    @NotNull
    private final ConcurrentMap<String, AggregateCacheInfo> aggregateRootInfoDict;
    @NotNull
    private final Object lockObj;
    @NotNull
    private final String taskName;
    private int timeoutSeconds;
    private int scanExpiredAggregateIntervalMilliseconds;
    private final Logger logger;

    public DefaultMemoryCache(@NotNull AggregateStorage aggregateStorage, @NotNull ScheduleService scheduleService, @NotNull TypeNameProvider typeNameProvider) {
        Intrinsics.checkNotNullParameter((Object)aggregateStorage, (String)"aggregateStorage");
        Intrinsics.checkNotNullParameter((Object)scheduleService, (String)"scheduleService");
        Intrinsics.checkNotNullParameter((Object)typeNameProvider, (String)"typeNameProvider");
        this.aggregateStorage = aggregateStorage;
        this.scheduleService = scheduleService;
        this.typeNameProvider = typeNameProvider;
        this.lockObj = new Object();
        this.timeoutSeconds = 5000;
        this.scanExpiredAggregateIntervalMilliseconds = 5000;
        this.logger = LoggerFactory.getLogger(DefaultMemoryCache.class);
        this.aggregateRootInfoDict = new ConcurrentHashMap();
        this.taskName = "CleanInactiveAggregates_" + System.nanoTime() + new Random().nextInt(10000);
    }

    @Override
    @NotNull
    public <T extends AggregateRoot> CompletableFuture<T> getAsync(@NotNull String aggregateRootId, @NotNull Class<T> aggregateRootType) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        Assert.nonNull(aggregateRootId, "aggregateRootId");
        Assert.nonNull(aggregateRootType, "aggregateRootType");
        CompletableFuture<AggregateRoot> future = new CompletableFuture<AggregateRoot>();
        AggregateCacheInfo aggregateRootInfo = (AggregateCacheInfo)this.aggregateRootInfoDict.get(aggregateRootId);
        if (aggregateRootInfo == null) {
            future.complete(null);
            return future;
        }
        if (!Intrinsics.areEqual(aggregateRootInfo.getAggregateRoot().getClass(), aggregateRootType)) {
            throw new AggregateRootTypeNotMatchException("Incorrect aggregate root type, aggregateRootId:" + aggregateRootId + ", type:" + aggregateRootInfo.getAggregateRoot().getClass() + ", expecting type:" + aggregateRootType);
        }
        if (!((Collection)aggregateRootInfo.getAggregateRoot().getChanges()).isEmpty()) {
            CompletableFuture<T> latestAggregateRootFuture = this.aggregateStorage.getAsync(aggregateRootType, aggregateRootId);
            CompletionStage completionStage = latestAggregateRootFuture.thenApply(arg_0 -> DefaultMemoryCache.getAsync$lambda$0((Function1)new Function1<AggregateRoot, T>(this, aggregateRootType, aggregateRootId){
                final /* synthetic */ DefaultMemoryCache this$0;
                final /* synthetic */ Class<T> $aggregateRootType;
                final /* synthetic */ String $aggregateRootId;
                {
                    this.this$0 = $receiver;
                    this.$aggregateRootType = $aggregateRootType;
                    this.$aggregateRootId = $aggregateRootId;
                    super(1);
                }

                public final T invoke(@Nullable AggregateRoot latestAggregateRoot) {
                    if (latestAggregateRoot != null) {
                        DefaultMemoryCache.access$resetAggregateRootCache(this.this$0, this.$aggregateRootType, this.$aggregateRootId, latestAggregateRoot);
                    }
                    return (T)latestAggregateRoot;
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun <T : Aggreg\u2026      return future\n    }");
            return completionStage;
        }
        future.complete(aggregateRootInfo.getAggregateRoot());
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends AggregateRoot> void acceptAggregateRootChanges(@NotNull T aggregateRoot) {
        Intrinsics.checkNotNullParameter(aggregateRoot, (String)"aggregateRoot");
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            AtomicBoolean cacheReset = new AtomicBoolean(false);
            AggregateCacheInfo cacheInfo2 = this.aggregateRootInfoDict.computeIfAbsent(aggregateRoot.getUniqueId(), arg_0 -> DefaultMemoryCache.acceptAggregateRootChanges$lambda$2$lambda$1((Function1)new Function1<String, AggregateCacheInfo>(aggregateRoot, cacheReset, this){
                final /* synthetic */ T $aggregateRoot;
                final /* synthetic */ AtomicBoolean $cacheReset;
                final /* synthetic */ DefaultMemoryCache this$0;
                {
                    this.$aggregateRoot = $aggregateRoot;
                    this.$cacheReset = $cacheReset;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final AggregateCacheInfo invoke(String it) {
                    this.$aggregateRoot.acceptChanges();
                    this.$cacheReset.set(true);
                    Object[] objectArray = new Object[]{this.$aggregateRoot.getClass().getName(), this.$aggregateRoot.getUniqueId(), this.$aggregateRoot.getVersion()};
                    DefaultMemoryCache.access$getLogger$p(this.this$0).info("Aggregate root in-memory cache initialized, aggregateRootType: {}, aggregateRootId: {}, aggregateRootVersion: {}", objectArray);
                    return new AggregateCacheInfo((AggregateRoot)this.$aggregateRoot);
                }
            }, arg_0));
            if (cacheReset.get()) {
                return;
            }
            AggregateCacheInfo aggregateCacheInfo = cacheInfo2;
            Intrinsics.checkNotNull((Object)aggregateCacheInfo);
            int aggregateRootOldVersion = aggregateCacheInfo.getAggregateRoot().getVersion();
            if (aggregateRoot.getVersion() > 1 && cacheInfo2.getAggregateRoot() != aggregateRoot) {
                throw new AggregateRootReferenceChangedException(aggregateRoot);
            }
            aggregateRoot.acceptChanges();
            cacheInfo2.updateAggregateRoot(aggregateRoot);
            Object[] objectArray = new Object[]{aggregateRoot.getClass().getName(), aggregateRoot.getUniqueId(), aggregateRoot.getVersion(), aggregateRootOldVersion};
            this.logger.info("Aggregate root in-memory cache changed, aggregateRootType: {}, aggregateRootId: {}, aggregateRootNewVersion: {}, aggregateRootOldVersion: {}", objectArray);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public <T extends AggregateRoot> void refreshAggregate(@NotNull T aggregateRoot) {
        Intrinsics.checkNotNullParameter(aggregateRoot, (String)"aggregateRoot");
        this.resetAggregateRootCache(aggregateRoot.getClass(), aggregateRoot.getUniqueId(), aggregateRoot);
    }

    @Override
    @NotNull
    public <T extends AggregateRoot> CompletableFuture<T> refreshAggregateFromEventStoreAsync(@NotNull String aggregateRootTypeName, @NotNull String aggregateRootId) {
        CompletableFuture<Object> completableFuture;
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Assert.nonNull(aggregateRootTypeName, "aggregateRootTypeName");
        CompletableFuture future = new CompletableFuture();
        try {
            Class<?> clazz = this.typeNameProvider.getType(aggregateRootTypeName);
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<T of org.enodeframework.domain.impl.DefaultMemoryCache.refreshAggregateFromEventStoreAsync>");
            Class<?> aggregateRootType = clazz;
            completableFuture = this.refreshAggregateFromEventStoreAsync(aggregateRootType, aggregateRootId);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            completableFuture = future;
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public <T extends AggregateRoot> CompletableFuture<T> refreshAggregateFromEventStoreAsync(@NotNull Class<T> aggregateRootType, @NotNull String aggregateRootId) {
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Assert.nonNull(aggregateRootId, "aggregateRootId");
        Assert.nonNull(aggregateRootType, "aggregateRootType");
        CompletionStage completionStage = ((CompletableFuture)this.aggregateStorage.getAsync(aggregateRootType, aggregateRootId).thenApply(arg_0 -> DefaultMemoryCache.refreshAggregateFromEventStoreAsync$lambda$3((Function1)new Function1<T, T>(this, aggregateRootType, aggregateRootId){
            final /* synthetic */ DefaultMemoryCache this$0;
            final /* synthetic */ Class<T> $aggregateRootType;
            final /* synthetic */ String $aggregateRootId;
            {
                this.this$0 = $receiver;
                this.$aggregateRootType = $aggregateRootType;
                this.$aggregateRootId = $aggregateRootId;
                super(1);
            }

            public final T invoke(T aggregateRoot) {
                DefaultMemoryCache.access$resetAggregateRootCache(this.this$0, this.$aggregateRootType, this.$aggregateRootId, aggregateRoot);
                return aggregateRoot;
            }
        }, arg_0))).exceptionally(arg_0 -> DefaultMemoryCache.refreshAggregateFromEventStoreAsync$lambda$4(this, aggregateRootType, aggregateRootId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun <T : Aggreg\u2026     null\n        }\n    }");
        return completionStage;
    }

    @Override
    public void start() {
        this.scheduleService.startTask(this.taskName, () -> DefaultMemoryCache.start$lambda$5(this), this.scanExpiredAggregateIntervalMilliseconds, this.scanExpiredAggregateIntervalMilliseconds);
    }

    @Override
    public void stop() {
        this.scheduleService.stopTask(this.taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resetAggregateRootCache(Class<?> aggregateRootType, String aggregateRootId, AggregateRoot aggregateRoot) {
        AggregateCacheInfo aggregateCacheInfo = (AggregateCacheInfo)this.aggregateRootInfoDict.remove(aggregateRootId);
        if (aggregateCacheInfo != null) {
            Object[] objectArray = new Object[]{aggregateRootType.getName(), aggregateRootId, aggregateCacheInfo.getAggregateRoot().getVersion()};
            this.logger.info("Removed dirty in-memory aggregate, aggregateRootType: {}, aggregateRootId: {}, version: {}", objectArray);
        }
        Intrinsics.checkNotNull((Object)aggregateRoot);
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            AtomicBoolean cacheReset = new AtomicBoolean(false);
            AggregateCacheInfo cacheInfo2 = this.aggregateRootInfoDict.computeIfAbsent(aggregateRoot.getUniqueId(), arg_0 -> DefaultMemoryCache.resetAggregateRootCache$lambda$7$lambda$6((Function1)new Function1<String, AggregateCacheInfo>(this, aggregateRoot, cacheReset){
                final /* synthetic */ DefaultMemoryCache this$0;
                final /* synthetic */ AggregateRoot $aggregateRoot;
                final /* synthetic */ AtomicBoolean $cacheReset;
                {
                    this.this$0 = $receiver;
                    this.$aggregateRoot = $aggregateRoot;
                    this.$cacheReset = $cacheReset;
                    super(1);
                }

                public final AggregateCacheInfo invoke(String it) {
                    if (DefaultMemoryCache.access$getLogger$p(this.this$0).isDebugEnabled()) {
                        Object[] objectArray = new Object[]{this.$aggregateRoot.getClass().getName(), this.$aggregateRoot.getUniqueId(), this.$aggregateRoot.getVersion()};
                        DefaultMemoryCache.access$getLogger$p(this.this$0).debug("Aggregate root in-memory cache reset, aggregateRootType: {}, aggregateRootId: {}, aggregateRootVersion: {}", objectArray);
                    }
                    this.$cacheReset.set(true);
                    return new AggregateCacheInfo(this.$aggregateRoot);
                }
            }, arg_0));
            if (cacheReset.get()) {
                return;
            }
            AggregateCacheInfo aggregateCacheInfo2 = cacheInfo2;
            Intrinsics.checkNotNull((Object)aggregateCacheInfo2);
            int aggregateRootOldVersion = aggregateCacheInfo2.getAggregateRoot().getVersion();
            cacheInfo2.updateAggregateRoot(aggregateRoot);
            if (this.logger.isDebugEnabled()) {
                Object[] objectArray = new Object[]{aggregateRoot.getClass().getName(), aggregateRoot.getUniqueId(), aggregateRoot.getVersion(), aggregateRootOldVersion};
                this.logger.debug("Aggregate root in-memory cache reset, aggregateRootType: {}, aggregateRootId: {}, aggregateRootNewVersion: {}, aggregateRootOldVersion: {}", objectArray);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanInactiveAggregateRoot() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.aggregateRootInfoDict.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!((AggregateCacheInfo)entry.getValue()).isExpired(this.timeoutSeconds)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inactiveList = (List)destination$iv$iv;
        Iterable $this$forEach$iv = inactiveList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            if (this.aggregateRootInfoDict.remove(entry.getKey()) == null) continue;
            this.logger.info("Removed inactive aggregate root, id: {}", entry.getKey());
        }
    }

    private static final AggregateRoot getAsync$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AggregateRoot)$tmp0.invoke(p0);
    }

    private static final AggregateCacheInfo acceptAggregateRootChanges$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AggregateCacheInfo)$tmp0.invoke(p0);
    }

    private static final AggregateRoot refreshAggregateFromEventStoreAsync$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AggregateRoot)$tmp0.invoke(p0);
    }

    private static final AggregateRoot refreshAggregateFromEventStoreAsync$lambda$4(DefaultMemoryCache this$0, Class $aggregateRootType, String $aggregateRootId, Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootType, (String)"$aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        Object[] objectArray = new Object[]{this$0.typeNameProvider.getTypeName($aggregateRootType), $aggregateRootId, ex};
        this$0.logger.error("Refresh aggregate from event store has unknown exception, aggregateRootTypeName:{}, aggregateRootId:{}", objectArray);
        return null;
    }

    private static final void start$lambda$5(DefaultMemoryCache this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cleanInactiveAggregateRoot();
    }

    private static final AggregateCacheInfo resetAggregateRootCache$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AggregateCacheInfo)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$resetAggregateRootCache(DefaultMemoryCache $this, Class aggregateRootType, String aggregateRootId, AggregateRoot aggregateRoot) {
        $this.resetAggregateRootCache(aggregateRootType, aggregateRootId, aggregateRoot);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultMemoryCache $this) {
        return $this.logger;
    }
}

