/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain.impl;

import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.MemoryCache;
import org.enodeframework.domain.Repository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J!\u0010\r\u001a\u00020\u000e\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u0002H\u0007H\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/enodeframework/domain/impl/DefaultRepository;", "Lorg/enodeframework/domain/Repository;", "memoryCache", "Lorg/enodeframework/domain/MemoryCache;", "(Lorg/enodeframework/domain/MemoryCache;)V", "getAsync", "Ljava/util/concurrent/CompletableFuture;", "T", "Lorg/enodeframework/domain/AggregateRoot;", "aggregateRootType", "Ljava/lang/Class;", "aggregateRootId", "", "refreshAggregate", "", "aggregateRoot", "(Lorg/enodeframework/domain/AggregateRoot;)V", "enode"})
public final class DefaultRepository
implements Repository {
    @NotNull
    private final MemoryCache memoryCache;

    public DefaultRepository(@NotNull MemoryCache memoryCache) {
        Intrinsics.checkNotNullParameter((Object)memoryCache, (String)"memoryCache");
        this.memoryCache = memoryCache;
    }

    @Override
    @NotNull
    public <T extends AggregateRoot> CompletableFuture<T> getAsync(@NotNull Class<T> aggregateRootType, @NotNull String aggregateRootId) {
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Assert.nonNull(aggregateRootType, "aggregateRootType");
        Assert.nonNull(aggregateRootId, "aggregateRootId");
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = new CompletableFuture();
        this.memoryCache.getAsync(aggregateRootId, aggregateRootType).whenComplete((arg_0, arg_1) -> DefaultRepository.getAsync$lambda$0((Function2)new Function2<T, Throwable, Unit>(result, this, aggregateRootType, aggregateRootId){
            final /* synthetic */ Ref.ObjectRef<CompletableFuture<T>> $result;
            final /* synthetic */ DefaultRepository this$0;
            final /* synthetic */ Class<T> $aggregateRootType;
            final /* synthetic */ String $aggregateRootId;
            {
                this.$result = $result;
                this.this$0 = $receiver;
                this.$aggregateRootType = $aggregateRootType;
                this.$aggregateRootId = $aggregateRootId;
                super(2);
            }

            public final void invoke(T aggregateRoot, Throwable throwable) {
                if (aggregateRoot != null) {
                    ((CompletableFuture)this.$result.element).complete(aggregateRoot);
                } else {
                    this.$result.element = DefaultRepository.access$getMemoryCache$p(this.this$0).refreshAggregateFromEventStoreAsync(this.$aggregateRootType, this.$aggregateRootId);
                }
            }
        }, arg_0, arg_1));
        return (CompletableFuture)result.element;
    }

    @Override
    public <T extends AggregateRoot> void refreshAggregate(T aggregateRoot) {
        T t = aggregateRoot;
        Intrinsics.checkNotNull(t);
        this.memoryCache.refreshAggregate(t);
    }

    private static final void getAsync$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ MemoryCache access$getMemoryCache$p(DefaultRepository $this) {
        return $this.memoryCache;
    }
}

