/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.enodeframework.common.exception.AggregateRootInvalidException;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.AggregateRootFactory;
import org.enodeframework.domain.AggregateSnapshotter;
import org.enodeframework.domain.AggregateStorage;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EventStore;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ0\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J;\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u0002H\u00102\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002\u00a2\u0006\u0002\u0010\u0019J5\u0010\u001a\u001a\u0002H\u0010\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eJ0\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0013H\u0002JH\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u000f2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\fH\u0002J8\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\fH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/enodeframework/domain/impl/EventSourcingAggregateStorage;", "Lorg/enodeframework/domain/AggregateStorage;", "eventStore", "Lorg/enodeframework/eventing/EventStore;", "aggregateRootFactory", "Lorg/enodeframework/domain/AggregateRootFactory;", "aggregateSnapshotter", "Lorg/enodeframework/domain/AggregateSnapshotter;", "typeNameProvider", "Lorg/enodeframework/infrastructure/TypeNameProvider;", "(Lorg/enodeframework/eventing/EventStore;Lorg/enodeframework/domain/AggregateRootFactory;Lorg/enodeframework/domain/AggregateSnapshotter;Lorg/enodeframework/infrastructure/TypeNameProvider;)V", "MAX_VERSION", "", "MIN_VERSION", "getAsync", "Ljava/util/concurrent/CompletableFuture;", "T", "Lorg/enodeframework/domain/AggregateRoot;", "aggregateRootType", "Ljava/lang/Class;", "aggregateRootId", "", "queryAggregateEvents", "queryAggregateEventsSnapshot", "aggregateRoot", "(Lorg/enodeframework/domain/AggregateRoot;Ljava/lang/String;Ljava/lang/Class;)Ljava/util/concurrent/CompletableFuture;", "rebuildAggregateRoot", "eventStreams", "", "Lorg/enodeframework/eventing/DomainEventStream;", "(Ljava/lang/Class;Ljava/util/List;)Lorg/enodeframework/domain/AggregateRoot;", "tryGetFromSnapshot", "tryQueryAggregateEventsAsync", "aggregateRootTypeName", "minVersion", "maxVersion", "retryTimes", "tryRestoreFromSnapshotAsync", "enode"})
public final class EventSourcingAggregateStorage
implements AggregateStorage {
    @NotNull
    private final EventStore eventStore;
    @NotNull
    private final AggregateRootFactory aggregateRootFactory;
    @NotNull
    private final AggregateSnapshotter aggregateSnapshotter;
    @NotNull
    private final TypeNameProvider typeNameProvider;
    private final int MIN_VERSION;
    private final int MAX_VERSION;

    public EventSourcingAggregateStorage(@NotNull EventStore eventStore, @NotNull AggregateRootFactory aggregateRootFactory, @NotNull AggregateSnapshotter aggregateSnapshotter, @NotNull TypeNameProvider typeNameProvider) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)aggregateRootFactory, (String)"aggregateRootFactory");
        Intrinsics.checkNotNullParameter((Object)aggregateSnapshotter, (String)"aggregateSnapshotter");
        Intrinsics.checkNotNullParameter((Object)typeNameProvider, (String)"typeNameProvider");
        this.eventStore = eventStore;
        this.aggregateRootFactory = aggregateRootFactory;
        this.aggregateSnapshotter = aggregateSnapshotter;
        this.typeNameProvider = typeNameProvider;
        this.MIN_VERSION = 1;
        this.MAX_VERSION = Integer.MAX_VALUE;
    }

    private final <T extends AggregateRoot> CompletableFuture<T> tryRestoreFromSnapshotAsync(Class<T> aggregateRootType, String aggregateRootId, int retryTimes) {
        CompletableFuture taskSource = new CompletableFuture();
        IOHelper.tryAsyncActionRecursively("TryRestoreFromSnapshotAsync", () -> EventSourcingAggregateStorage.tryRestoreFromSnapshotAsync$lambda$0(this, aggregateRootType, aggregateRootId), arg_0 -> EventSourcingAggregateStorage.tryRestoreFromSnapshotAsync$lambda$1(taskSource, arg_0), () -> EventSourcingAggregateStorage.tryRestoreFromSnapshotAsync$lambda$2(aggregateRootType, aggregateRootId), null, retryTimes, true);
        return taskSource;
    }

    private final CompletableFuture<List<DomainEventStream>> tryQueryAggregateEventsAsync(Class<?> aggregateRootType, String aggregateRootTypeName, String aggregateRootId, int minVersion, int maxVersion, int retryTimes) {
        CompletableFuture<List<DomainEventStream>> taskSource = new CompletableFuture<List<DomainEventStream>>();
        IOHelper.tryAsyncActionRecursively("TryQueryAggregateEventsAsync", () -> EventSourcingAggregateStorage.tryQueryAggregateEventsAsync$lambda$3(this, aggregateRootId, aggregateRootTypeName, minVersion, maxVersion), arg_0 -> EventSourcingAggregateStorage.tryQueryAggregateEventsAsync$lambda$4(taskSource, arg_0), () -> EventSourcingAggregateStorage.tryQueryAggregateEventsAsync$lambda$5(aggregateRootTypeName, aggregateRootId), null, retryTimes, true);
        return taskSource;
    }

    private final <T extends AggregateRoot> CompletableFuture<T> tryGetFromSnapshot(String aggregateRootId, Class<T> aggregateRootType) {
        CompletionStage completionStage = this.tryRestoreFromSnapshotAsync(aggregateRootType, aggregateRootId, 0).thenCompose(arg_0 -> EventSourcingAggregateStorage.tryGetFromSnapshot$lambda$6((Function1)new Function1<T, CompletionStage<T>>(this, aggregateRootId, aggregateRootType){
            final /* synthetic */ EventSourcingAggregateStorage this$0;
            final /* synthetic */ String $aggregateRootId;
            final /* synthetic */ Class<T> $aggregateRootType;
            {
                this.this$0 = $receiver;
                this.$aggregateRootId = $aggregateRootId;
                this.$aggregateRootType = $aggregateRootType;
                super(1);
            }

            public final CompletionStage<T> invoke(T aggregateRoot) {
                return EventSourcingAggregateStorage.access$queryAggregateEventsSnapshot(this.this$0, aggregateRoot, this.$aggregateRootId, this.$aggregateRootType);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"private fun <T : Aggrega\u2026RootType)\n        }\n    }");
        return completionStage;
    }

    private final <T extends AggregateRoot> CompletableFuture<T> queryAggregateEventsSnapshot(T aggregateRoot, String aggregateRootId, Class<?> aggregateRootType) {
        if (aggregateRoot == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(null)");
            return completableFuture;
        }
        if (!Intrinsics.areEqual(aggregateRoot.getClass(), aggregateRootType) || !Intrinsics.areEqual((Object)aggregateRoot.getUniqueId(), (Object)aggregateRootId)) {
            String string = "AggregateRoot recovery from snapshot is invalid as the aggregateRootType or aggregateRootId is not matched. Snapshot: [aggregateRootType: %s, aggregateRootId: %s], expected: [aggregateRootType: %s, aggregateRootId: %s]";
            Object[] objectArray = new Object[]{aggregateRoot.getClass(), aggregateRoot.getUniqueId(), aggregateRootType, aggregateRootId};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            throw new AggregateRootInvalidException(string2);
        }
        String aggregateRootTypeName = this.typeNameProvider.getTypeName(aggregateRootType);
        CompletionStage completionStage = this.tryQueryAggregateEventsAsync(aggregateRootType, aggregateRootTypeName, aggregateRootId, aggregateRoot.getVersion() + 1, this.MAX_VERSION, 0).thenApply(arg_0 -> EventSourcingAggregateStorage.queryAggregateEventsSnapshot$lambda$7((Function1)new Function1<List<? extends DomainEventStream>, T>(aggregateRoot){
            final /* synthetic */ T $aggregateRoot;
            {
                this.$aggregateRoot = $aggregateRoot;
                super(1);
            }

            public final T invoke(@NotNull List<DomainEventStream> eventStreams) {
                Intrinsics.checkNotNullParameter(eventStreams, (String)"eventStreams");
                this.$aggregateRoot.replayEvents(eventStreams);
                return this.$aggregateRoot;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"aggregateRoot: T, aggreg\u2026  aggregateRoot\n        }");
        return completionStage;
    }

    private final <T extends AggregateRoot> T rebuildAggregateRoot(Class<T> aggregateRootType, List<DomainEventStream> eventStreams) {
        T aggregateRoot;
        block0: {
            boolean it = !((Collection)eventStreams).isEmpty();
            boolean bl = false;
            T t = aggregateRoot = this.aggregateRootFactory.createAggregateRoot(aggregateRootType);
            if (t == null) break block0;
            t.replayEvents(eventStreams);
        }
        return aggregateRoot;
    }

    @Override
    @NotNull
    public <T extends AggregateRoot> CompletableFuture<T> getAsync(@NotNull Class<T> aggregateRootType, @NotNull String aggregateRootId) {
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Assert.nonNull(aggregateRootId, "aggregateRootId");
        Assert.nonNull(aggregateRootType, "aggregateRootType");
        CompletableFuture<T> future = this.tryGetFromSnapshot(aggregateRootId, aggregateRootType);
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = new CompletableFuture();
        future.whenComplete((arg_0, arg_1) -> EventSourcingAggregateStorage.getAsync$lambda$9((Function2)new Function2<T, Throwable, Unit>(result, this, aggregateRootType, aggregateRootId){
            final /* synthetic */ Ref.ObjectRef<CompletableFuture<T>> $result;
            final /* synthetic */ EventSourcingAggregateStorage this$0;
            final /* synthetic */ Class<T> $aggregateRootType;
            final /* synthetic */ String $aggregateRootId;
            {
                this.$result = $result;
                this.this$0 = $receiver;
                this.$aggregateRootType = $aggregateRootType;
                this.$aggregateRootId = $aggregateRootId;
                super(2);
            }

            public final void invoke(T aggregateRoot, Throwable throwable) {
                if (aggregateRoot != null) {
                    ((CompletableFuture)this.$result.element).complete(aggregateRoot);
                } else {
                    this.$result.element = EventSourcingAggregateStorage.access$queryAggregateEvents(this.this$0, this.$aggregateRootType, this.$aggregateRootId);
                }
            }
        }, arg_0, arg_1));
        return (CompletableFuture)result.element;
    }

    private final <T extends AggregateRoot> CompletableFuture<T> queryAggregateEvents(Class<T> aggregateRootType, String aggregateRootId) {
        String aggregateRootTypeName = this.typeNameProvider.getTypeName(aggregateRootType);
        CompletionStage completionStage = this.tryQueryAggregateEventsAsync(aggregateRootType, aggregateRootTypeName, aggregateRootId, this.MIN_VERSION, this.MAX_VERSION, 0).thenApply(arg_0 -> EventSourcingAggregateStorage.queryAggregateEvents$lambda$10((Function1)new Function1<List<? extends DomainEventStream>, T>(this, aggregateRootType){
            final /* synthetic */ EventSourcingAggregateStorage this$0;
            final /* synthetic */ Class<T> $aggregateRootType;
            {
                this.this$0 = $receiver;
                this.$aggregateRootType = $aggregateRootType;
                super(1);
            }

            public final T invoke(List<DomainEventStream> eventStreams) {
                Intrinsics.checkNotNullExpressionValue(eventStreams, (String)"eventStreams");
                return (T)EventSourcingAggregateStorage.access$rebuildAggregateRoot(this.this$0, this.$aggregateRootType, eventStreams);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"private fun <T : Aggrega\u2026tStreams)\n        }\n    }");
        return completionStage;
    }

    private static final CompletableFuture tryRestoreFromSnapshotAsync$lambda$0(EventSourcingAggregateStorage this$0, Class $aggregateRootType, String $aggregateRootId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootType, (String)"$aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        return this$0.aggregateSnapshotter.restoreFromSnapshotAsync($aggregateRootType, $aggregateRootId);
    }

    private static final void tryRestoreFromSnapshotAsync$lambda$1(CompletableFuture $taskSource, AggregateRoot value) {
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        $taskSource.complete(value);
    }

    private static final String tryRestoreFromSnapshotAsync$lambda$2(Class $aggregateRootType, String $aggregateRootId) {
        Intrinsics.checkNotNullParameter((Object)$aggregateRootType, (String)"$aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        return "tryRestoreFromSnapshotAsync has unknown exception, aggregateRootType: " + $aggregateRootType.getName() + ", aggregateRootId: " + $aggregateRootId;
    }

    private static final CompletableFuture tryQueryAggregateEventsAsync$lambda$3(EventSourcingAggregateStorage this$0, String $aggregateRootId, String $aggregateRootTypeName, int $minVersion, int $maxVersion) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootTypeName, (String)"$aggregateRootTypeName");
        return this$0.eventStore.queryAggregateEventsAsync($aggregateRootId, $aggregateRootTypeName, $minVersion, $maxVersion);
    }

    private static final void tryQueryAggregateEventsAsync$lambda$4(CompletableFuture $taskSource, List value) {
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $taskSource.complete(value);
    }

    private static final String tryQueryAggregateEventsAsync$lambda$5(String $aggregateRootTypeName, String $aggregateRootId) {
        Intrinsics.checkNotNullParameter((Object)$aggregateRootTypeName, (String)"$aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        return "eventStore.queryAggregateEventsAsync has unknown exception, aggregateRootType: " + $aggregateRootTypeName + ", aggregateRootId: " + $aggregateRootId;
    }

    private static final CompletionStage tryGetFromSnapshot$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final AggregateRoot queryAggregateEventsSnapshot$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AggregateRoot)$tmp0.invoke(p0);
    }

    private static final void getAsync$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final AggregateRoot queryAggregateEvents$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AggregateRoot)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ CompletableFuture access$queryAggregateEventsSnapshot(EventSourcingAggregateStorage $this, AggregateRoot aggregateRoot, String aggregateRootId, Class aggregateRootType) {
        return $this.queryAggregateEventsSnapshot(aggregateRoot, aggregateRootId, aggregateRootType);
    }

    public static final /* synthetic */ CompletableFuture access$queryAggregateEvents(EventSourcingAggregateStorage $this, Class aggregateRootType, String aggregateRootId) {
        return $this.queryAggregateEvents(aggregateRootType, aggregateRootId);
    }

    public static final /* synthetic */ AggregateRoot access$rebuildAggregateRoot(EventSourcingAggregateStorage $this, Class aggregateRootType, List eventStreams) {
        return $this.rebuildAggregateRoot(aggregateRootType, eventStreams);
    }
}

