/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.eventing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.exception.DomainEventInvalidException;
import org.enodeframework.eventing.DomainEventMessage;
import org.enodeframework.messaging.AbstractMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002BI\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fBI\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lorg/enodeframework/eventing/DomainEventStream;", "Lorg/enodeframework/messaging/AbstractMessage;", "()V", "commandId", "", "aggregateRootId", "version", "", "aggregateRootTypeName", "events", "", "Lorg/enodeframework/eventing/DomainEventMessage;", "items", "", "", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/util/List;Ljava/util/Map;)V", "timestamp", "Ljava/util/Date;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Date;Ljava/util/List;Ljava/util/Map;)V", "getAggregateRootId", "()Ljava/lang/String;", "setAggregateRootId", "(Ljava/lang/String;)V", "getAggregateRootTypeName", "setAggregateRootTypeName", "getCommandId", "setCommandId", "getEvents", "()Ljava/util/List;", "setEvents", "(Ljava/util/List;)V", "getItems", "()Ljava/util/Map;", "setItems", "(Ljava/util/Map;)V", "getTimestamp", "()Ljava/util/Date;", "setTimestamp", "(Ljava/util/Date;)V", "getVersion", "()I", "setVersion", "(I)V", "enode"})
public final class DomainEventStream
extends AbstractMessage {
    @NotNull
    private String commandId;
    @NotNull
    private String aggregateRootTypeName;
    @NotNull
    private String aggregateRootId;
    private int version;
    @NotNull
    private List<? extends DomainEventMessage> events;
    @NotNull
    private Map<String, Object> items;
    @NotNull
    private Date timestamp;

    @NotNull
    public final String getCommandId() {
        return this.commandId;
    }

    public final void setCommandId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.commandId = string;
    }

    @NotNull
    public final String getAggregateRootTypeName() {
        return this.aggregateRootTypeName;
    }

    public final void setAggregateRootTypeName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.aggregateRootTypeName = string;
    }

    @NotNull
    public final String getAggregateRootId() {
        return this.aggregateRootId;
    }

    public final void setAggregateRootId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.aggregateRootId = string;
    }

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int n) {
        this.version = n;
    }

    @NotNull
    public final List<DomainEventMessage> getEvents() {
        return this.events;
    }

    public final void setEvents(@NotNull List<? extends DomainEventMessage> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.events = list;
    }

    @Override
    @NotNull
    public Map<String, Object> getItems() {
        return this.items;
    }

    @Override
    public void setItems(@NotNull Map<String, Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.items = map;
    }

    @Override
    @NotNull
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"<set-?>");
        this.timestamp = date;
    }

    public DomainEventStream() {
        super(null, 1, null);
        this.commandId = "";
        this.aggregateRootTypeName = "";
        this.aggregateRootId = "";
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList()");
        this.events = arrayList;
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap()");
        this.items = hashMap;
        this.timestamp = new Date();
    }

    public DomainEventStream(@NotNull String commandId, @NotNull String aggregateRootId, int version, @NotNull String aggregateRootTypeName, @NotNull List<? extends DomainEventMessage> events, @NotNull Map<String, Object> items) {
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        super(null, 1, null);
        this.commandId = "";
        this.aggregateRootTypeName = "";
        this.aggregateRootId = "";
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList()");
        this.events = arrayList;
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap()");
        this.items = hashMap;
        this.timestamp = new Date();
        this.commandId = commandId;
        this.aggregateRootId = aggregateRootId;
        this.aggregateRootTypeName = aggregateRootTypeName;
        this.version = version;
        this.events = events;
        this.setItems(items);
    }

    public DomainEventStream(@NotNull String commandId, @NotNull String aggregateRootId, @NotNull String aggregateRootTypeName, @NotNull Date timestamp, @NotNull List<? extends DomainEventMessage> events, @NotNull Map<String, Object> items) {
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        super(null, 1, null);
        this.commandId = "";
        this.aggregateRootTypeName = "";
        this.aggregateRootId = "";
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList()");
        this.events = arrayList;
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap()");
        this.items = hashMap;
        this.timestamp = new Date();
        if (!(!((Collection)events).isEmpty())) {
            boolean bl = false;
            String string = "events cannot be empty. aggregateRootId: " + aggregateRootId;
            throw new IllegalArgumentException(string.toString());
        }
        this.commandId = commandId;
        this.aggregateRootId = aggregateRootId;
        this.aggregateRootTypeName = aggregateRootTypeName;
        Integer n = events.stream().findFirst().map(arg_0 -> DomainEventStream._init_$lambda$1((Function1)2.INSTANCE, arg_0)).orElse(0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"events.stream().findFirs\u2026ssage::version).orElse(0)");
        this.version = ((Number)n).intValue();
        this.setTimestamp(timestamp);
        this.events = events;
        this.setItems(items);
        this.setId(aggregateRootId + '_' + this.version);
        int sequence = 1;
        for (DomainEventMessage domainEventMessage : events) {
            if (domainEventMessage.getVersion() != this.version) {
                throw new DomainEventInvalidException("Invalid domain event version, aggregateRootTypeName: " + aggregateRootTypeName + " aggregateRootId: " + aggregateRootId + " expected version: " + this.version + ", but was: " + domainEventMessage.getVersion());
            }
            domainEventMessage.setCommandId(commandId);
            domainEventMessage.setAggregateRootTypeName(aggregateRootTypeName);
            domainEventMessage.setSequence(sequence++);
            domainEventMessage.setTimestamp(timestamp);
            domainEventMessage.mergeItems(items);
        }
    }

    private static final Integer _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }
}

