/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.eventing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.enodeframework.common.exception.MailBoxProcessException;
import org.enodeframework.common.extensions.SystemClock;
import org.enodeframework.common.function.Action1;
import org.enodeframework.common.io.Task;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EnqueueMessageResult;
import org.enodeframework.eventing.ProcessingEvent;
import org.enodeframework.eventing.ProcessingEventMailBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\tH\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\tJ\u0006\u0010%\u001a\u00020 J\u0006\u0010&\u001a\u00020\u0019J\u0006\u0010'\u001a\u00020\u0019J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0019J\u0006\u0010\u000e\u001a\u00020)J\u0006\u0010\u0010\u001a\u00020)J\u0006\u0010+\u001a\u00020 J\b\u0010,\u001a\u00020 H\u0002J\b\u0010-\u001a\u00020 H\u0002J\b\u0010.\u001a\u00020 H\u0002J\u000e\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u0019J\b\u00101\u001a\u00020 H\u0002J\u0010\u00102\u001a\u00020 2\u0006\u00100\u001a\u00020\u0019H\u0002J\b\u00103\u001a\u00020 H\u0002J\u0006\u00104\u001a\u00020)R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\t0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/enodeframework/eventing/ProcessingEventMailBox;", "", "aggregateRootTypeName", "", "aggregateRootId", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "handleProcessingEventAction", "Lorg/enodeframework/common/function/Action1;", "Lorg/enodeframework/eventing/ProcessingEvent;", "(Ljava/lang/String;Ljava/lang/String;Lkotlinx/coroutines/CoroutineDispatcher;Lorg/enodeframework/common/function/Action1;)V", "getAggregateRootId", "()Ljava/lang/String;", "getAggregateRootTypeName", "isRemoved", "Ljava/util/concurrent/atomic/AtomicInteger;", "isRunning", "isUsing", "lastActiveTime", "Ljava/util/Date;", "lockObj", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "nextExpectingEventVersion", "", "Ljava/lang/Integer;", "processingEventQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "waitingProcessingEventDict", "Ljava/util/concurrent/ConcurrentHashMap;", "completeRun", "", "enqueueEventStream", "processingEvent", "enqueueMessage", "Lorg/enodeframework/eventing/EnqueueMessageResult;", "exitUsing", "getTotalUnHandledMessageCount", "getWaitingMessageCount", "isInactive", "", "timeoutSeconds", "markAsRemoved", "processMessage", "setAsNotRunning", "setAsRunning", "setNextExpectingEventVersion", "version", "tryEnqueueValidWaitingMessage", "tryRemovedInvalidWaitingMessages", "tryRun", "tryUsing", "enode"})
@SourceDebugExtension(value={"SMAP\nProcessingEventMailBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessingEventMailBox.kt\norg/enodeframework/eventing/ProcessingEventMailBox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,256:1\n766#2:257\n857#2,2:258\n1855#2,2:260\n*S KotlinDebug\n*F\n+ 1 ProcessingEventMailBox.kt\norg/enodeframework/eventing/ProcessingEventMailBox\n*L\n32#1:257\n32#1:258,2\n32#1:260,2\n*E\n"})
public final class ProcessingEventMailBox {
    @NotNull
    private final String aggregateRootTypeName;
    @NotNull
    private final String aggregateRootId;
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    @NotNull
    private Action1<ProcessingEvent> handleProcessingEventAction;
    @NotNull
    private final Object lockObj;
    @NotNull
    private final AtomicInteger isUsing;
    @NotNull
    private final AtomicInteger isRemoved;
    @NotNull
    private final AtomicInteger isRunning;
    @NotNull
    private ConcurrentHashMap<Integer, ProcessingEvent> waitingProcessingEventDict;
    @NotNull
    private ConcurrentLinkedQueue<ProcessingEvent> processingEventQueue;
    @NotNull
    private Date lastActiveTime;
    @Nullable
    private Integer nextExpectingEventVersion;
    private final Logger logger;

    public ProcessingEventMailBox(@NotNull String aggregateRootTypeName, @NotNull String aggregateRootId, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull Action1<ProcessingEvent> handleProcessingEventAction) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter(handleProcessingEventAction, (String)"handleProcessingEventAction");
        this.aggregateRootTypeName = aggregateRootTypeName;
        this.aggregateRootId = aggregateRootId;
        this.coroutineDispatcher = coroutineDispatcher;
        this.handleProcessingEventAction = handleProcessingEventAction;
        this.lockObj = new Object();
        this.isUsing = new AtomicInteger(0);
        this.isRemoved = new AtomicInteger(0);
        this.isRunning = new AtomicInteger(0);
        this.waitingProcessingEventDict = new ConcurrentHashMap();
        this.processingEventQueue = new ConcurrentLinkedQueue();
        this.logger = LoggerFactory.getLogger(ProcessingEventMailBox.class);
        this.lastActiveTime = new Date();
    }

    @NotNull
    public final String getAggregateRootTypeName() {
        return this.aggregateRootTypeName;
    }

    @NotNull
    public final String getAggregateRootId() {
        return this.aggregateRootId;
    }

    /*
     * WARNING - void declaration
     */
    private final void tryRemovedInvalidWaitingMessages(int version) {
        void $this$filterTo$iv$iv;
        Set set = this.waitingProcessingEventDict.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"waitingProcessingEventDict.keys");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int x = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(x < version)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessingEvent processingEvent;
            int key = ((Number)element$iv).intValue();
            boolean bl = false;
            if (!this.waitingProcessingEventDict.containsKey(key)) continue;
            ProcessingEvent processingEvent2 = processingEvent = this.waitingProcessingEventDict.remove(key);
            Intrinsics.checkNotNull((Object)processingEvent2);
            processingEvent2.complete();
            Object[] objectArray = new Object[]{this.getClass().getName(), processingEvent.getMessage().getAggregateRootTypeName(), processingEvent.getMessage().getAggregateRootId(), processingEvent.getMessage().getCommandId(), processingEvent.getMessage().getVersion(), processingEvent.getMessage().getId(), CollectionsKt.joinToString$default((Iterable)processingEvent.getMessage().getEvents(), (CharSequence)"|", null, null, (int)0, null, (Function1)tryRemovedInvalidWaitingMessages.2.1.INSTANCE, (int)30, null), CollectionsKt.joinToString$default((Iterable)processingEvent.getMessage().getEvents(), (CharSequence)"|", null, null, (int)0, null, (Function1)tryRemovedInvalidWaitingMessages.2.2.INSTANCE, (int)30, null), version};
            this.logger.warn("{} invalid waiting message removed, aggregateRootType: {}, aggregateRootId: {}, commandId: {}, eventVersion: {}, eventStreamId: {}, eventTypes: {}, eventIds: {}, nextExpectingEventVersion: {}", objectArray);
        }
    }

    private final void tryEnqueueValidWaitingMessage() {
        if (this.nextExpectingEventVersion == null) {
            return;
        }
        while (((Map)this.waitingProcessingEventDict).containsKey(this.nextExpectingEventVersion)) {
            Object[] objectArray = (Object[])this.waitingProcessingEventDict;
            Integer n = this.nextExpectingEventVersion;
            ProcessingEvent nextProcessingEvent = (ProcessingEvent)TypeIntrinsics.asMutableMap((Object)objectArray).remove(n);
            if (nextProcessingEvent == null) continue;
            this.enqueueEventStream(nextProcessingEvent);
            objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, this.aggregateRootTypeName, nextProcessingEvent.getMessage().getVersion()};
            this.logger.info("{} enqueued waiting processingEvent, aggregateRootId: {}, aggregateRootTypeName: {}, eventVersion: {}", objectArray);
        }
    }

    public final int getTotalUnHandledMessageCount() {
        return ((Collection)this.processingEventQueue).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void setNextExpectingEventVersion(int version) {
        var2_2 = this.lockObj;
        synchronized (var2_2) {
            $i$a$-synchronized-ProcessingEventMailBox$setNextExpectingEventVersion$1 = false;
            this.tryRemovedInvalidWaitingMessages(version);
            if (this.nextExpectingEventVersion == null) ** GOTO lbl-1000
            v0 = this.nextExpectingEventVersion;
            Intrinsics.checkNotNull((Object)v0);
            if (version > v0) lbl-1000:
            // 2 sources

            {
                this.nextExpectingEventVersion = version;
                var4_6 = new Object[]{this.getClass().getName(), this.aggregateRootId, this.aggregateRootTypeName, this.nextExpectingEventVersion};
                this.logger.info("{} refreshed nextExpectingEventVersion, aggregateRootId: {}, aggregateRootTypeName: {}, version: {}", var4_6);
                this.tryEnqueueValidWaitingMessage();
                this.lastActiveTime = new Date();
                this.tryRun();
            } else {
                v1 = this.nextExpectingEventVersion;
                if (v1 != null && version == v1) {
                    var4_7 = new Object[]{this.getClass().getName(), this.aggregateRootId, this.aggregateRootTypeName, version, this.nextExpectingEventVersion};
                    this.logger.info("{} equals nextExpectingEventVersion ignored, aggregateRootId: {}, aggregateRootTypeName: {}, version: {}, current nextExpectingEventVersion: {}", var4_7);
                } else {
                    var4_8 = new Object[]{this.getClass().getName(), this.aggregateRootId, this.aggregateRootTypeName, version, this.nextExpectingEventVersion};
                    this.logger.info("{} nextExpectingEventVersion ignored, aggregateRootId: {}, aggregateRootTypeName: {}, version: {}, current nextExpectingEventVersion: {}", var4_8);
                }
            }
            var3_4 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void enqueueEventStream(ProcessingEvent processingEvent) {
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            processingEvent.setMailbox(this);
            this.processingEventQueue.add(processingEvent);
            this.nextExpectingEventVersion = processingEvent.getMessage().getVersion() + 1;
            if (this.logger.isDebugEnabled()) {
                Object[] objectArray = new Object[]{this.getClass().getName(), processingEvent.getMessage().getAggregateRootTypeName(), processingEvent.getMessage().getAggregateRootId(), processingEvent.getMessage().getCommandId(), processingEvent.getMessage().getVersion(), processingEvent.getMessage().getId(), CollectionsKt.joinToString$default((Iterable)processingEvent.getMessage().getEvents(), (CharSequence)"|", null, null, (int)0, null, (Function1)enqueueEventStream.1.1.INSTANCE, (int)30, null), CollectionsKt.joinToString$default((Iterable)processingEvent.getMessage().getEvents(), (CharSequence)"|", null, null, (int)0, null, (Function1)enqueueEventStream.1.2.INSTANCE, (int)30, null)};
                this.logger.debug("{} enqueued new message, aggregateRootType: {}, aggregateRootId: {}, commandId: {}, eventVersion: {}, eventStreamId: {}, eventTypes: {}, eventIds: {}", objectArray);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final EnqueueMessageResult enqueueMessage(@NotNull ProcessingEvent processingEvent) {
        Intrinsics.checkNotNullParameter((Object)processingEvent, (String)"processingEvent");
        Object object = this.lockObj;
        synchronized (object) {
            block9: {
                DomainEventStream eventStream;
                block8: {
                    boolean bl = false;
                    if (this.isRemoved()) {
                        throw new MailBoxProcessException("ProcessingEventMailBox was removed, cannot allow to enqueue message, aggregateRootTypeName: " + this.aggregateRootTypeName + ", aggregateRootId: " + this.aggregateRootId);
                    }
                    eventStream = processingEvent.getMessage();
                    if (this.nextExpectingEventVersion != null) {
                        int n = eventStream.getVersion();
                        Integer n2 = this.nextExpectingEventVersion;
                        Intrinsics.checkNotNull((Object)n2);
                        if (n <= n2) break block8;
                    }
                    if (this.waitingProcessingEventDict.putIfAbsent(eventStream.getVersion(), processingEvent) == null) {
                        Object[] objectArray = new Object[]{this.getClass().getName(), eventStream.getAggregateRootTypeName(), eventStream.getAggregateRootId(), eventStream.getCommandId(), eventStream.getVersion(), eventStream.getId(), CollectionsKt.joinToString$default((Iterable)processingEvent.getMessage().getEvents(), (CharSequence)"|", null, null, (int)0, null, (Function1)enqueueMessage.1.1.INSTANCE, (int)30, null), CollectionsKt.joinToString$default((Iterable)processingEvent.getMessage().getEvents(), (CharSequence)"|", null, null, (int)0, null, (Function1)enqueueMessage.1.2.INSTANCE, (int)30, null), this.nextExpectingEventVersion};
                        this.logger.warn("{} waiting message added, aggregateRootType: {}, aggregateRootId: {}, commandId: {}, eventVersion: {}, eventStreamId: {}, eventTypes: {}, eventIds: {}, nextExpectingEventVersion: {}", objectArray);
                    }
                    EnqueueMessageResult enqueueMessageResult = EnqueueMessageResult.AddToWaitingList;
                    return enqueueMessageResult;
                }
                Integer n = this.nextExpectingEventVersion;
                if (n == null || eventStream.getVersion() != n.intValue()) break block9;
                this.enqueueEventStream(processingEvent);
                this.tryEnqueueValidWaitingMessage();
                this.lastActiveTime = new Date();
                this.tryRun();
                EnqueueMessageResult enqueueMessageResult = EnqueueMessageResult.Success;
                return enqueueMessageResult;
            }
            EnqueueMessageResult enqueueMessageResult = EnqueueMessageResult.Ignored;
            return enqueueMessageResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryRun() {
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            if (this.isRunning()) {
                return;
            }
            this.setAsRunning();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} start run, aggregateRootId: {}", (Object)this.getClass().getName(), (Object)this.aggregateRootId);
            }
            BuildersKt.async$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.coroutineDispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ProcessingEventMailBox this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ProcessingEventMailBox.access$processMessage(this.this$0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return;
        }
    }

    public final void completeRun() {
        this.lastActiveTime = new Date();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} complete run, aggregateRootId: {}", (Object)this.getClass().getName(), (Object)this.aggregateRootId);
        }
        this.setAsNotRunning();
        if (this.getTotalUnHandledMessageCount() > 0) {
            this.tryRun();
        }
    }

    public final boolean isInactive(int timeoutSeconds) {
        return SystemClock.now() - this.lastActiveTime.getTime() >= (long)timeoutSeconds;
    }

    private final void processMessage() {
        ProcessingEvent message = this.processingEventQueue.poll();
        if (message != null) {
            this.lastActiveTime = new Date();
            try {
                this.handleProcessingEventAction.apply(message);
            }
            catch (Exception ex) {
                Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, ex};
                this.logger.error("{} run has unknown exception, aggregateRootId: {}", objectArray);
                Task.sleep(1L);
                this.completeRun();
            }
        } else {
            this.completeRun();
        }
    }

    public final boolean tryUsing() {
        return this.isUsing.compareAndSet(0, 1);
    }

    public final void exitUsing() {
        this.isUsing.set(0);
    }

    public final void markAsRemoved() {
        this.isRemoved.set(1);
    }

    private final void setAsRunning() {
        this.isRunning.set(1);
    }

    public final boolean isRunning() {
        return this.isRunning.get() == 1;
    }

    public final boolean isRemoved() {
        return this.isRemoved.get() == 1;
    }

    private final void setAsNotRunning() {
        this.isRunning.set(0);
    }

    public final int getWaitingMessageCount() {
        return this.waitingProcessingEventDict.size();
    }

    public static final /* synthetic */ void access$processMessage(ProcessingEventMailBox $this) {
        $this.processMessage();
    }
}

