/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.eventing.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.CommandStatus;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.commanding.ProcessingCommandMailbox;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.MemoryCache;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EventAppendResult;
import org.enodeframework.eventing.EventCommittingContext;
import org.enodeframework.eventing.EventCommittingContextMailBox;
import org.enodeframework.eventing.EventCommittingService;
import org.enodeframework.eventing.EventStore;
import org.enodeframework.eventing.impl.DefaultEventCommittingService;
import org.enodeframework.messaging.Message;
import org.enodeframework.messaging.MessagePublisher;
import org.enodeframework.queue.SendMessageResult;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00017B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rBG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)H\u0002J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J&\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u000f2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u001b2\u0006\u00100\u001a\u00020\u0014H\u0002J\u001e\u00101\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u00102\u001a\u00020\nH\u0016J&\u00101\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u00102\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J.\u00103\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010+\u001a\u00020\u001c2\u0006\u00104\u001a\u0002052\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010\u001bH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/enodeframework/eventing/impl/DefaultEventCommittingService;", "Lorg/enodeframework/eventing/EventCommittingService;", "memoryCache", "Lorg/enodeframework/domain/MemoryCache;", "eventStore", "Lorg/enodeframework/eventing/EventStore;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "domainEventPublisher", "Lorg/enodeframework/messaging/MessagePublisher;", "Lorg/enodeframework/eventing/DomainEventStream;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lorg/enodeframework/domain/MemoryCache;Lorg/enodeframework/eventing/EventStore;Lorg/enodeframework/common/serializing/SerializeService;Lorg/enodeframework/messaging/MessagePublisher;Lkotlinx/coroutines/CoroutineDispatcher;)V", "eventMailBoxCount", "", "eventMailBoxPersistenceMaxBatchSize", "(Lorg/enodeframework/domain/MemoryCache;Lorg/enodeframework/eventing/EventStore;Lorg/enodeframework/common/serializing/SerializeService;Lorg/enodeframework/messaging/MessagePublisher;Lkotlinx/coroutines/CoroutineDispatcher;II)V", "eventCommittingContextMailBoxList", "", "Lorg/enodeframework/eventing/EventCommittingContextMailBox;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "batchPersistEventAsync", "", "committingContexts", "", "Lorg/enodeframework/eventing/EventCommittingContext;", "retryTimes", "commitDomainEventAsync", "eventCommittingContext", "completeCommand", "Ljava/util/concurrent/CompletableFuture;", "", "processingCommand", "Lorg/enodeframework/commanding/ProcessingCommand;", "commandResult", "Lorg/enodeframework/commanding/CommandResult;", "getEventMailBoxIndex", "aggregateRootId", "", "handleFirstEventDuplicationAsync", "context", "processDuplicateAggregateRootRecursively", "index", "contexts", "Lorg/enodeframework/eventing/impl/DefaultEventCommittingService$EventAppendContext;", "eventMailBox", "publishDomainEventAsync", "eventStream", "resetCommandMailBoxConsumingSequence", "consumingSequence", "", "duplicateCommandIdList", "EventAppendContext", "enode"})
@SourceDebugExtension(value={"SMAP\nDefaultEventCommittingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultEventCommittingService.kt\norg/enodeframework/eventing/impl/DefaultEventCommittingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n1549#2:334\n1620#2,3:335\n766#2:338\n857#2,2:339\n1855#2,2:341\n766#2:343\n857#2,2:344\n288#2,2:346\n766#2:348\n857#2,2:349\n288#2,2:351\n*S KotlinDebug\n*F\n+ 1 DefaultEventCommittingService.kt\norg/enodeframework/eventing/impl/DefaultEventCommittingService\n*L\n83#1:334\n83#1:335,3\n90#1:338\n90#1:339,2\n91#1:341,2\n110#1:343\n110#1:344,2\n111#1:346,2\n127#1:348\n127#1:349,2\n128#1:351,2\n*E\n"})
public final class DefaultEventCommittingService
implements EventCommittingService {
    @NotNull
    private final MemoryCache memoryCache;
    @NotNull
    private final EventStore eventStore;
    @NotNull
    private final SerializeService serializeService;
    @NotNull
    private final MessagePublisher<DomainEventStream> domainEventPublisher;
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    private final int eventMailBoxCount;
    private final int eventMailBoxPersistenceMaxBatchSize;
    @NotNull
    private final List<EventCommittingContextMailBox> eventCommittingContextMailBoxList;
    private final Logger logger;

    public DefaultEventCommittingService(@NotNull MemoryCache memoryCache, @NotNull EventStore eventStore, @NotNull SerializeService serializeService, @NotNull MessagePublisher<DomainEventStream> domainEventPublisher, @NotNull CoroutineDispatcher coroutineDispatcher, int eventMailBoxCount, int eventMailBoxPersistenceMaxBatchSize) {
        Intrinsics.checkNotNullParameter((Object)memoryCache, (String)"memoryCache");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        Intrinsics.checkNotNullParameter(domainEventPublisher, (String)"domainEventPublisher");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        this.memoryCache = memoryCache;
        this.eventStore = eventStore;
        this.serializeService = serializeService;
        this.domainEventPublisher = domainEventPublisher;
        this.coroutineDispatcher = coroutineDispatcher;
        this.eventMailBoxCount = eventMailBoxCount;
        this.eventMailBoxPersistenceMaxBatchSize = eventMailBoxPersistenceMaxBatchSize;
        this.eventCommittingContextMailBoxList = new ArrayList();
        this.logger = LoggerFactory.getLogger(DefaultEventCommittingService.class);
        int n = this.eventMailBoxCount;
        for (int i = 0; i < n; ++i) {
            EventCommittingContextMailBox mailBox = new EventCommittingContextMailBox(i, this.eventMailBoxPersistenceMaxBatchSize, this.coroutineDispatcher, arg_0 -> DefaultEventCommittingService._init_$lambda$24(this, arg_0));
            this.eventCommittingContextMailBoxList.add(mailBox);
        }
    }

    public /* synthetic */ DefaultEventCommittingService(MemoryCache memoryCache, EventStore eventStore, SerializeService serializeService, MessagePublisher messagePublisher, CoroutineDispatcher coroutineDispatcher, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            n = 4;
        }
        if ((n3 & 0x40) != 0) {
            n2 = 1000;
        }
        this(memoryCache, eventStore, serializeService, messagePublisher, coroutineDispatcher, n, n2);
    }

    public DefaultEventCommittingService(@NotNull MemoryCache memoryCache, @NotNull EventStore eventStore, @NotNull SerializeService serializeService, @NotNull MessagePublisher<DomainEventStream> domainEventPublisher, @NotNull CoroutineDispatcher coroutineDispatcher) {
        Intrinsics.checkNotNullParameter((Object)memoryCache, (String)"memoryCache");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        Intrinsics.checkNotNullParameter(domainEventPublisher, (String)"domainEventPublisher");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        this(memoryCache, eventStore, serializeService, domainEventPublisher, coroutineDispatcher, 4, 1000);
    }

    @Override
    public void commitDomainEventAsync(@NotNull EventCommittingContext eventCommittingContext) {
        Intrinsics.checkNotNullParameter((Object)eventCommittingContext, (String)"eventCommittingContext");
        int eventMailboxIndex = this.getEventMailBoxIndex(eventCommittingContext.getEventStream().getAggregateRootId());
        EventCommittingContextMailBox eventMailbox = this.eventCommittingContextMailBoxList.get(eventMailboxIndex);
        eventMailbox.enqueueMessage(eventCommittingContext);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> publishDomainEventAsync(@NotNull ProcessingCommand processingCommand, @NotNull DomainEventStream eventStream) {
        Intrinsics.checkNotNullParameter((Object)processingCommand, (String)"processingCommand");
        Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
        eventStream.mergeItems(processingCommand.getItems());
        DomainEventStream eventStreamMessage = new DomainEventStream(processingCommand.getMessage().getId(), eventStream.getAggregateRootId(), eventStream.getVersion(), eventStream.getAggregateRootTypeName(), eventStream.getEvents(), eventStream.getItems());
        return this.publishDomainEventAsync(processingCommand, eventStreamMessage, 0);
    }

    private final int getEventMailBoxIndex(String aggregateRootId) {
        int hash = 23;
        char[] cArray = aggregateRootId.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        for (char c : cArray) {
            hash = (hash << 5) - hash + c;
        }
        if (hash < 0) {
            hash = Math.abs(hash);
        }
        return hash % this.eventMailBoxCount;
    }

    private final void batchPersistEventAsync(List<EventCommittingContext> committingContexts, int retryTimes) {
        if (committingContexts.isEmpty()) {
            return;
        }
        IOHelper.tryAsyncActionRecursively("BatchPersistEventAsync", () -> DefaultEventCommittingService.batchPersistEventAsync$lambda$1(this, committingContexts), arg_0 -> DefaultEventCommittingService.batchPersistEventAsync$lambda$8(committingContexts, this, arg_0), () -> DefaultEventCommittingService.batchPersistEventAsync$lambda$9(committingContexts), null, retryTimes, true);
    }

    private final void processDuplicateAggregateRootRecursively(int index, List<EventAppendContext> contexts, EventCommittingContextMailBox eventMailBox) {
        if (contexts.isEmpty()) {
            return;
        }
        if (index == contexts.size()) {
            eventMailBox.completeRun();
            return;
        }
        EventAppendContext context = contexts.get(index);
        EventCommittingContext eventCommittingContext = context.getCommittingContext();
        List<String> duplicateCommandIdList = context.getDuplicateCommandIdList();
        if (context.getSuccess()) {
            this.publishDomainEventAsync(eventCommittingContext.getProcessingCommand(), eventCommittingContext.getEventStream()).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.processDuplicateAggregateRootRecursively$lambda$10((Function2)new Function2<Boolean, Throwable, Unit>(this, index, contexts, eventMailBox){
                final /* synthetic */ DefaultEventCommittingService this$0;
                final /* synthetic */ int $index;
                final /* synthetic */ List<EventAppendContext> $contexts;
                final /* synthetic */ EventCommittingContextMailBox $eventMailBox;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                    this.$contexts = $contexts;
                    this.$eventMailBox = $eventMailBox;
                    super(2);
                }

                public final void invoke(Boolean bl, Throwable throwable) {
                    DefaultEventCommittingService.access$processDuplicateAggregateRootRecursively(this.this$0, this.$index + 1, this.$contexts, this.$eventMailBox);
                }
            }, arg_0, arg_1));
            return;
        }
        if (eventCommittingContext.getEventStream().getVersion() == 1) {
            this.handleFirstEventDuplicationAsync(eventCommittingContext, 0).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.processDuplicateAggregateRootRecursively$lambda$11((Function2)new Function2<Boolean, Throwable, Unit>(this, index, contexts, eventMailBox){
                final /* synthetic */ DefaultEventCommittingService this$0;
                final /* synthetic */ int $index;
                final /* synthetic */ List<EventAppendContext> $contexts;
                final /* synthetic */ EventCommittingContextMailBox $eventMailBox;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                    this.$contexts = $contexts;
                    this.$eventMailBox = $eventMailBox;
                    super(2);
                }

                public final void invoke(Boolean bl, Throwable throwable) {
                    DefaultEventCommittingService.access$processDuplicateAggregateRootRecursively(this.this$0, this.$index + 1, this.$contexts, this.$eventMailBox);
                }
            }, arg_0, arg_1));
        } else {
            this.resetCommandMailBoxConsumingSequence(eventCommittingContext, eventCommittingContext.getProcessingCommand().getSequence(), duplicateCommandIdList).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.processDuplicateAggregateRootRecursively$lambda$12((Function2)new Function2<Boolean, Throwable, Unit>(this, index, contexts, eventMailBox){
                final /* synthetic */ DefaultEventCommittingService this$0;
                final /* synthetic */ int $index;
                final /* synthetic */ List<EventAppendContext> $contexts;
                final /* synthetic */ EventCommittingContextMailBox $eventMailBox;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                    this.$contexts = $contexts;
                    this.$eventMailBox = $eventMailBox;
                    super(2);
                }

                public final void invoke(Boolean bl, Throwable throwable) {
                    DefaultEventCommittingService.access$processDuplicateAggregateRootRecursively(this.this$0, this.$index + 1, this.$contexts, this.$eventMailBox);
                }
            }, arg_0, arg_1));
        }
    }

    private final CompletableFuture<Boolean> resetCommandMailBoxConsumingSequence(EventCommittingContext context, long consumingSequence, List<String> duplicateCommandIdList) {
        ProcessingCommandMailbox commandMailBox = context.getProcessingCommand().getMailBox();
        EventCommittingContextMailBox eventMailBox = context.getMailBox();
        String aggregateRootId = context.getEventStream().getAggregateRootId();
        commandMailBox.pause();
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        eventMailBox.removeAggregateAllEventCommittingContexts(aggregateRootId);
        this.memoryCache.refreshAggregateFromEventStoreAsync(context.getEventStream().getAggregateRootTypeName(), aggregateRootId).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.resetCommandMailBoxConsumingSequence$lambda$13((Function2)new Function2<AggregateRoot, Throwable, Unit>(duplicateCommandIdList, commandMailBox, consumingSequence, future){
            final /* synthetic */ List<String> $duplicateCommandIdList;
            final /* synthetic */ ProcessingCommandMailbox $commandMailBox;
            final /* synthetic */ long $consumingSequence;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            {
                this.$duplicateCommandIdList = $duplicateCommandIdList;
                this.$commandMailBox = $commandMailBox;
                this.$consumingSequence = $consumingSequence;
                this.$future = $future;
                super(2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(AggregateRoot aggregateRoot, Throwable throwable) {
                try {
                    if (this.$duplicateCommandIdList != null) {
                        for (String commandId : this.$duplicateCommandIdList) {
                            this.$commandMailBox.addDuplicateCommandId(commandId);
                        }
                    }
                    this.$commandMailBox.resetConsumingSequence(this.$consumingSequence);
                }
                finally {
                    this.$commandMailBox.resume();
                    this.$commandMailBox.tryRun();
                }
                this.$future.complete(true);
            }
        }, arg_0, arg_1));
        return future;
    }

    private final CompletableFuture<Boolean> handleFirstEventDuplicationAsync(EventCommittingContext context, int retryTimes) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        IOHelper.tryAsyncActionRecursively("FindFirstEventByVersion", () -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda$14(this, context), arg_0 -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda$18(context, this, future, arg_0), () -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda$19(this, context), null, retryTimes, true);
        return future;
    }

    private final CompletableFuture<Boolean> publishDomainEventAsync(ProcessingCommand processingCommand, DomainEventStream eventStream, int retryTimes) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        IOHelper.tryAsyncActionRecursivelyWithoutResult("PublishDomainEventAsync", () -> DefaultEventCommittingService.publishDomainEventAsync$lambda$20(this, eventStream), arg_0 -> DefaultEventCommittingService.publishDomainEventAsync$lambda$22(this, eventStream, processingCommand, future, arg_0), () -> DefaultEventCommittingService.publishDomainEventAsync$lambda$23(this, eventStream), null, retryTimes, true);
        return future;
    }

    private final CompletableFuture<Boolean> completeCommand(ProcessingCommand processingCommand, CommandResult commandResult) {
        return processingCommand.getMailBox().completeMessage(processingCommand, commandResult);
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture batchPersistEventAsync$lambda$1(DefaultEventCommittingService this$0, List $committingContexts) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$committingContexts, (String)"$committingContexts");
        Iterable iterable = $committingContexts;
        EventStore eventStore = this$0.eventStore;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void obj;
            EventCommittingContext eventCommittingContext = (EventCommittingContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(obj.getEventStream());
        }
        return eventStore.batchAppendAsync((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final void batchPersistEventAsync$lambda$8(List $committingContexts, DefaultEventCommittingService this$0, EventAppendResult result) {
        Iterable $this$firstOrNull$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$committingContexts, (String)"$committingContexts");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        EventCommittingContextMailBox eventMailBox = ((EventCommittingContext)CollectionsKt.first((List)$committingContexts)).getMailBox();
        ArrayList<EventAppendContext> appendContextList = new ArrayList<EventAppendContext>();
        if (result.getSuccessAggregateRootIdList().size() > 0) {
            for (String string : result.getSuccessAggregateRootIdList()) {
                void $this$forEach$iv;
                $this$filter$iv = $committingContexts;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    EventCommittingContext x = (EventCommittingContext)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)x.getEventStream().getAggregateRootId(), (Object)string)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                $this$filterTo$iv$iv = $this$forEach$iv.iterator();
                while ($this$filterTo$iv$iv.hasNext()) {
                    Object element$iv = $this$filterTo$iv$iv.next();
                    EventCommittingContext eventCommittingContext = (EventCommittingContext)element$iv;
                    boolean bl = false;
                    EventAppendContext context = new EventAppendContext();
                    context.setSuccess(true);
                    context.setDuplicateCommandIdList(new ArrayList());
                    context.setCommittingContext(eventCommittingContext);
                    appendContextList.add(context);
                }
            }
            if (this$0.logger.isDebugEnabled()) {
                Logger logger = this$0.logger;
                eventMailBox.getNumber();
                logger.debug("Batch persist events success, mailboxNumber: {}, result: {}", (Object)Unit.INSTANCE, (Object)this$0.serializeService.serialize(result.getSuccessAggregateRootIdList()));
            }
        }
        if (!result.getDuplicateCommandAggregateRootIdList().isEmpty()) {
            block3: for (Map.Entry entry : result.getDuplicateCommandAggregateRootIdList().entrySet()) {
                Iterator $this$filterTo$iv$iv2;
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                Iterable $this$filter$iv2 = $committingContexts;
                boolean $i$f$filter = false;
                Iterable eventCommittingContext = $this$filter$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator x = $this$filterTo$iv$iv2.iterator();
                while (x.hasNext()) {
                    Object element$iv$iv = x.next();
                    EventCommittingContext x2 = (EventCommittingContext)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)key, (Object)x2.getEventStream().getAggregateRootId())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                $this$filterTo$iv$iv2 = $this$firstOrNull$iv.iterator();
                while ($this$filterTo$iv$iv2.hasNext()) {
                    Object element$iv = $this$filterTo$iv$iv2.next();
                    EventCommittingContext eventCommittingContext2 = (EventCommittingContext)element$iv;
                    boolean bl = false;
                    EventAppendContext context = new EventAppendContext();
                    context.setDuplicateCommandIdList(value);
                    context.setCommittingContext(eventCommittingContext2);
                    if (!appendContextList.add(context)) continue;
                    continue block3;
                }
            }
            Logger logger = this$0.logger;
            eventMailBox.getNumber();
            logger.warn("Batch persist events has duplicate commandIds, mailboxNumber: {}, result: {}", (Object)Unit.INSTANCE, (Object)this$0.serializeService.serialize(result.getDuplicateCommandAggregateRootIdList()));
        }
        if (result.getDuplicateEventAggregateRootIdList().size() > 0) {
            block6: for (String string : result.getDuplicateEventAggregateRootIdList()) {
                void $this$firstOrNull$iv2;
                $this$filter$iv = $committingContexts;
                boolean $i$f$filter = false;
                $this$firstOrNull$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator element$iv = $this$filterTo$iv$iv.iterator();
                while (element$iv.hasNext()) {
                    Object element$iv$iv = element$iv.next();
                    EventCommittingContext x = (EventCommittingContext)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)x.getEventStream().getAggregateRootId(), (Object)string)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv2) {
                    EventCommittingContext eventCommittingContext = (EventCommittingContext)element$iv2;
                    boolean bl = false;
                    EventAppendContext context = new EventAppendContext();
                    context.setDuplicateCommandIdList(new ArrayList());
                    context.setCommittingContext(eventCommittingContext);
                    if (!appendContextList.add(context)) continue;
                    continue block6;
                }
            }
            Logger logger = this$0.logger;
            eventMailBox.getNumber();
            logger.warn("Batch persist events duplicated, mailboxNumber: {}, result: {}", (Object)Unit.INSTANCE, (Object)this$0.serializeService.serialize(result.getDuplicateEventAggregateRootIdList()));
        }
        this$0.processDuplicateAggregateRootRecursively(0, (List<EventAppendContext>)appendContextList, eventMailBox);
    }

    private static final String batchPersistEventAsync$lambda$9(List $committingContexts) {
        Intrinsics.checkNotNullParameter((Object)$committingContexts, (String)"$committingContexts");
        return "[contextListCount: " + $committingContexts.size() + ']';
    }

    private static final void processDuplicateAggregateRootRecursively$lambda$10(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void processDuplicateAggregateRootRecursively$lambda$11(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void processDuplicateAggregateRootRecursively$lambda$12(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void resetCommandMailBoxConsumingSequence$lambda$13(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final CompletableFuture handleFirstEventDuplicationAsync$lambda$14(DefaultEventCommittingService this$0, EventCommittingContext $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        return this$0.eventStore.findAsync($context.getEventStream().getAggregateRootId(), 1);
    }

    private static final void handleFirstEventDuplicationAsync$lambda$18$lambda$15(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void handleFirstEventDuplicationAsync$lambda$18$lambda$16(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void handleFirstEventDuplicationAsync$lambda$18$lambda$17(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void handleFirstEventDuplicationAsync$lambda$18(EventCommittingContext $context, DefaultEventCommittingService this$0, CompletableFuture $future, DomainEventStream result) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        if (result != null) {
            if (Intrinsics.areEqual((Object)$context.getProcessingCommand().getMessage().getId(), (Object)result.getCommandId())) {
                this$0.resetCommandMailBoxConsumingSequence($context, $context.getProcessingCommand().getSequence() + 1L, null).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda$18$lambda$15((Function2)new Function2<Boolean, Throwable, Unit>(this$0, $context, result, (CompletableFuture<Boolean>)$future){
                    final /* synthetic */ DefaultEventCommittingService this$0;
                    final /* synthetic */ EventCommittingContext $context;
                    final /* synthetic */ DomainEventStream $result;
                    final /* synthetic */ CompletableFuture<Boolean> $future;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        this.$result = $result;
                        this.$future = $future;
                        super(2);
                    }

                    public final void invoke(Boolean bl, Throwable throwable) {
                        this.this$0.publishDomainEventAsync(this.$context.getProcessingCommand(), this.$result).whenComplete((arg_0, arg_1) -> handleFirstEventDuplicationAsync.2.1.invoke$lambda$0((Function2)new Function2<Boolean, Throwable, Unit>(this.$future){
                            final /* synthetic */ CompletableFuture<Boolean> $future;
                            {
                                this.$future = $future;
                                super(2);
                            }

                            public final void invoke(Boolean bl, Throwable throwable) {
                                this.$future.complete(true);
                            }
                        }, arg_0, arg_1));
                    }

                    private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0, p1);
                    }
                }, arg_0, arg_1));
            } else {
                String errorMessage = "Duplicate aggregate creation. current commandId:" + $context.getProcessingCommand().getMessage().getId() + ", existing commandId:" + result.getCommandId() + ", aggregateRootId:" + result.getAggregateRootId() + ", aggregateRootTypeName:" + result.getAggregateRootTypeName();
                this$0.logger.error(errorMessage);
                this$0.resetCommandMailBoxConsumingSequence($context, $context.getProcessingCommand().getSequence() + 1L, null).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda$18$lambda$16((Function2)new Function2<Boolean, Throwable, Unit>($context, this$0, (CompletableFuture<Boolean>)$future){
                    final /* synthetic */ EventCommittingContext $context;
                    final /* synthetic */ DefaultEventCommittingService this$0;
                    final /* synthetic */ CompletableFuture<Boolean> $future;
                    {
                        this.$context = $context;
                        this.this$0 = $receiver;
                        this.$future = $future;
                        super(2);
                    }

                    public final void invoke(Boolean bl, Throwable throwable) {
                        String string = this.$context.getProcessingCommand().getMessage().getId();
                        String string2 = this.$context.getEventStream().getAggregateRootId();
                        String string3 = String.class.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"String::class.java.name");
                        CommandResult commandResult = new CommandResult(CommandStatus.Failed, string, string2, "Duplicate aggregate creation.", string3);
                        DefaultEventCommittingService.access$completeCommand(this.this$0, this.$context.getProcessingCommand(), commandResult).whenComplete((arg_0, arg_1) -> handleFirstEventDuplicationAsync.2.2.invoke$lambda$0((Function2)new Function2<Boolean, Throwable, Unit>(this.$future){
                            final /* synthetic */ CompletableFuture<Boolean> $future;
                            {
                                this.$future = $future;
                                super(2);
                            }

                            public final void invoke(Boolean bl, Throwable throwable) {
                                this.$future.complete(true);
                            }
                        }, arg_0, arg_1));
                    }

                    private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0, p1);
                    }
                }, arg_0, arg_1));
            }
        } else {
            String errorMessage = "Duplicate aggregate creation, but we cannot find the existing eventstream from eventstore. commandId:" + $context.getEventStream().getCommandId() + ", aggregateRootId:" + $context.getEventStream().getAggregateRootId() + ", aggregateRootTypeName:" + $context.getEventStream().getAggregateRootTypeName();
            this$0.logger.error(errorMessage);
            this$0.resetCommandMailBoxConsumingSequence($context, $context.getProcessingCommand().getSequence() + 1L, null).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda$18$lambda$17((Function2)new Function2<Boolean, Throwable, Unit>($context, this$0, (CompletableFuture<Boolean>)$future){
                final /* synthetic */ EventCommittingContext $context;
                final /* synthetic */ DefaultEventCommittingService this$0;
                final /* synthetic */ CompletableFuture<Boolean> $future;
                {
                    this.$context = $context;
                    this.this$0 = $receiver;
                    this.$future = $future;
                    super(2);
                }

                public final void invoke(Boolean bl, Throwable throwable) {
                    String string = this.$context.getProcessingCommand().getMessage().getId();
                    String string2 = this.$context.getEventStream().getAggregateRootId();
                    String string3 = String.class.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"String::class.java.name");
                    CommandResult commandResult = new CommandResult(CommandStatus.Failed, string, string2, "Duplicate aggregate creation, but we cannot find the existing eventstream from eventstore.", string3);
                    DefaultEventCommittingService.access$completeCommand(this.this$0, this.$context.getProcessingCommand(), commandResult).whenComplete((arg_0, arg_1) -> handleFirstEventDuplicationAsync.2.3.invoke$lambda$0((Function2)new Function2<Boolean, Throwable, Unit>(this.$future){
                        final /* synthetic */ CompletableFuture<Boolean> $future;
                        {
                            this.$future = $future;
                            super(2);
                        }

                        public final void invoke(Boolean bl, Throwable throwable) {
                            this.$future.complete(true);
                        }
                    }, arg_0, arg_1));
                }

                private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke(p0, p1);
                }
            }, arg_0, arg_1));
        }
    }

    private static final String handleFirstEventDuplicationAsync$lambda$19(DefaultEventCommittingService this$0, EventCommittingContext $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        return "[eventStream: " + this$0.serializeService.serialize($context.getEventStream()) + ']';
    }

    private static final CompletableFuture publishDomainEventAsync$lambda$20(DefaultEventCommittingService this$0, DomainEventStream $eventStream) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        return this$0.domainEventPublisher.publishAsync((DomainEventStream)((Message)$eventStream));
    }

    private static final void publishDomainEventAsync$lambda$22$lambda$21(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void publishDomainEventAsync$lambda$22(DefaultEventCommittingService this$0, DomainEventStream $eventStream, ProcessingCommand $processingCommand, CompletableFuture $future, SendMessageResult it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        Intrinsics.checkNotNullParameter((Object)$processingCommand, (String)"$processingCommand");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        if (this$0.logger.isDebugEnabled()) {
            this$0.logger.debug("Publish domain events success, {}", (Object)this$0.serializeService.serialize($eventStream));
        }
        String commandHandleResult = $processingCommand.getCommandExecuteContext().getResult();
        String string = $processingCommand.getMessage().getId();
        String string2 = $eventStream.getAggregateRootId();
        String string3 = String.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"String::class.java.name");
        CommandResult commandResult = new CommandResult(CommandStatus.Success, string, string2, commandHandleResult, string3);
        this$0.completeCommand($processingCommand, commandResult).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.publishDomainEventAsync$lambda$22$lambda$21((Function2)new Function2<Boolean, Throwable, Unit>((CompletableFuture<Boolean>)$future){
            final /* synthetic */ CompletableFuture<Boolean> $future;
            {
                this.$future = $future;
                super(2);
            }

            public final void invoke(Boolean bl, Throwable throwable) {
                this.$future.complete(true);
            }
        }, arg_0, arg_1));
    }

    private static final String publishDomainEventAsync$lambda$23(DefaultEventCommittingService this$0, DomainEventStream $eventStream) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        return "[eventStream: " + this$0.serializeService.serialize($eventStream) + ']';
    }

    private static final void _init_$lambda$24(DefaultEventCommittingService this$0, List x) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        this$0.batchPersistEventAsync(x, 0);
    }

    public static final /* synthetic */ void access$processDuplicateAggregateRootRecursively(DefaultEventCommittingService $this, int index, List contexts, EventCommittingContextMailBox eventMailBox) {
        $this.processDuplicateAggregateRootRecursively(index, contexts, eventMailBox);
    }

    public static final /* synthetic */ CompletableFuture access$completeCommand(DefaultEventCommittingService $this, ProcessingCommand processingCommand, CommandResult commandResult) {
        return $this.completeCommand(processingCommand, commandResult);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/enodeframework/eventing/impl/DefaultEventCommittingService$EventAppendContext;", "", "()V", "committingContext", "Lorg/enodeframework/eventing/EventCommittingContext;", "getCommittingContext", "()Lorg/enodeframework/eventing/EventCommittingContext;", "setCommittingContext", "(Lorg/enodeframework/eventing/EventCommittingContext;)V", "duplicateCommandIdList", "", "", "getDuplicateCommandIdList", "()Ljava/util/List;", "setDuplicateCommandIdList", "(Ljava/util/List;)V", "success", "", "getSuccess", "()Z", "setSuccess", "(Z)V", "enode"})
    public static final class EventAppendContext {
        public EventCommittingContext committingContext;
        @NotNull
        private List<String> duplicateCommandIdList = new ArrayList();
        private boolean success;

        @NotNull
        public final EventCommittingContext getCommittingContext() {
            EventCommittingContext eventCommittingContext = this.committingContext;
            if (eventCommittingContext != null) {
                return eventCommittingContext;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"committingContext");
            return null;
        }

        public final void setCommittingContext(@NotNull EventCommittingContext eventCommittingContext) {
            Intrinsics.checkNotNullParameter((Object)eventCommittingContext, (String)"<set-?>");
            this.committingContext = eventCommittingContext;
        }

        @NotNull
        public final List<String> getDuplicateCommandIdList() {
            return this.duplicateCommandIdList;
        }

        public final void setDuplicateCommandIdList(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.duplicateCommandIdList = list;
        }

        public final boolean getSuccess() {
            return this.success;
        }

        public final void setSuccess(boolean bl) {
            this.success = bl;
        }
    }
}

