/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.eventing.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import org.enodeframework.common.extensions.SystemClock;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.scheduling.ScheduleService;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EnqueueMessageResult;
import org.enodeframework.eventing.ProcessingEvent;
import org.enodeframework.eventing.ProcessingEventMailBox;
import org.enodeframework.eventing.ProcessingEventProcessor;
import org.enodeframework.eventing.PublishedVersionStore;
import org.enodeframework.messaging.MessageDispatcher;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0002J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020#H\u0002J\u0018\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u001aH\u0002J\u0018\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u001aH\u0002J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0015H\u0002J\u0010\u0010/\u001a\u00020#2\u0006\u0010*\u001a\u00020'H\u0016J\b\u00100\u001a\u00020#H\u0002J\b\u00101\u001a\u00020#H\u0016J\b\u00102\u001a\u00020#H\u0016J\u0010\u00103\u001a\u00020#2\u0006\u0010-\u001a\u00020\u0015H\u0002J\u0018\u00104\u001a\u00020#2\u0006\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u001aH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001d0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/enodeframework/eventing/impl/DefaultProcessingEventProcessor;", "Lorg/enodeframework/eventing/ProcessingEventProcessor;", "scheduleService", "Lorg/enodeframework/common/scheduling/ScheduleService;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "messageDispatcher", "Lorg/enodeframework/messaging/MessageDispatcher;", "publishedVersionStore", "Lorg/enodeframework/eventing/PublishedVersionStore;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lorg/enodeframework/common/scheduling/ScheduleService;Lorg/enodeframework/common/serializing/SerializeService;Lorg/enodeframework/messaging/MessageDispatcher;Lorg/enodeframework/eventing/PublishedVersionStore;Lkotlinx/coroutines/CoroutineDispatcher;)V", "domainEventStreamMessageHandlerName", "", "(Lorg/enodeframework/common/scheduling/ScheduleService;Lorg/enodeframework/common/serializing/SerializeService;Lorg/enodeframework/messaging/MessageDispatcher;Lorg/enodeframework/eventing/PublishedVersionStore;Lkotlinx/coroutines/CoroutineDispatcher;Ljava/lang/String;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mailboxDict", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/enodeframework/eventing/ProcessingEventMailBox;", "name", "getName", "()Ljava/lang/String;", "processTryToRefreshAggregateIntervalMilliseconds", "", "processTryToRefreshAggregateTaskName", "refreshingAggregateRootDict", "", "scanExpiredAggregateIntervalMilliseconds", "scanInactiveMailBoxTaskName", "timeoutSeconds", "toRefreshAggregateRootMailBoxDict", "addToRefreshAggregateMailBoxToDict", "", "mailbox", "buildProcessingEventMailBox", "processingMessage", "Lorg/enodeframework/eventing/ProcessingEvent;", "cleanInactiveMailbox", "dispatchProcessingMessageAsync", "processingEvent", "retryTimes", "getAggregateRootLatestPublishedEventVersion", "processingEventMailBox", "isMailBoxAllowRemove", "process", "processToRefreshAggregateRootMailBoxs", "start", "stop", "tryToRefreshAggregateMailBoxNextExpectingEventVersion", "updatePublishedVersionAsync", "enode"})
@SourceDebugExtension(value={"SMAP\nDefaultProcessingEventProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultProcessingEventProcessor.kt\norg/enodeframework/eventing/impl/DefaultProcessingEventProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n1#2:250\n1855#3,2:251\n766#3:253\n857#3,2:254\n1855#3,2:256\n*S KotlinDebug\n*F\n+ 1 DefaultProcessingEventProcessor.kt\norg/enodeframework/eventing/impl/DefaultProcessingEventProcessor\n*L\n205#1:251,2\n228#1:253\n228#1:254,2\n229#1:256,2\n*E\n"})
public final class DefaultProcessingEventProcessor
implements ProcessingEventProcessor {
    @NotNull
    private final ScheduleService scheduleService;
    @NotNull
    private final SerializeService serializeService;
    @NotNull
    private final MessageDispatcher messageDispatcher;
    @NotNull
    private final PublishedVersionStore publishedVersionStore;
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    @NotNull
    private final String domainEventStreamMessageHandlerName;
    private final Logger logger;
    @NotNull
    private final String scanInactiveMailBoxTaskName;
    @NotNull
    private final String processTryToRefreshAggregateTaskName;
    @NotNull
    private final String name;
    @NotNull
    private final ConcurrentHashMap<String, ProcessingEventMailBox> toRefreshAggregateRootMailBoxDict;
    @NotNull
    private final ConcurrentHashMap<String, ProcessingEventMailBox> mailboxDict;
    @NotNull
    private final ConcurrentHashMap<String, Boolean> refreshingAggregateRootDict;
    private int timeoutSeconds;
    private int scanExpiredAggregateIntervalMilliseconds;
    private int processTryToRefreshAggregateIntervalMilliseconds;

    public DefaultProcessingEventProcessor(@NotNull ScheduleService scheduleService, @NotNull SerializeService serializeService, @NotNull MessageDispatcher messageDispatcher, @NotNull PublishedVersionStore publishedVersionStore, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull String domainEventStreamMessageHandlerName) {
        Intrinsics.checkNotNullParameter((Object)scheduleService, (String)"scheduleService");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        Intrinsics.checkNotNullParameter((Object)messageDispatcher, (String)"messageDispatcher");
        Intrinsics.checkNotNullParameter((Object)publishedVersionStore, (String)"publishedVersionStore");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)domainEventStreamMessageHandlerName, (String)"domainEventStreamMessageHandlerName");
        this.scheduleService = scheduleService;
        this.serializeService = serializeService;
        this.messageDispatcher = messageDispatcher;
        this.publishedVersionStore = publishedVersionStore;
        this.coroutineDispatcher = coroutineDispatcher;
        this.domainEventStreamMessageHandlerName = domainEventStreamMessageHandlerName;
        this.logger = LoggerFactory.getLogger(DefaultProcessingEventProcessor.class);
        this.scanInactiveMailBoxTaskName = "CleanInactiveProcessingEventMailBoxes_" + SystemClock.now() + new Random().nextInt(10000);
        this.processTryToRefreshAggregateTaskName = "ProcessTryToRefreshAggregate_" + SystemClock.now() + new Random().nextInt(10000);
        this.name = this.domainEventStreamMessageHandlerName;
        this.toRefreshAggregateRootMailBoxDict = new ConcurrentHashMap();
        this.mailboxDict = new ConcurrentHashMap();
        this.refreshingAggregateRootDict = new ConcurrentHashMap();
        this.timeoutSeconds = 259200;
        this.scanExpiredAggregateIntervalMilliseconds = 5000;
        this.processTryToRefreshAggregateIntervalMilliseconds = 1000;
    }

    public /* synthetic */ DefaultProcessingEventProcessor(ScheduleService scheduleService, SerializeService serializeService, MessageDispatcher messageDispatcher, PublishedVersionStore publishedVersionStore, CoroutineDispatcher coroutineDispatcher, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            string = "DefaultEventProcessor";
        }
        this(scheduleService, serializeService, messageDispatcher, publishedVersionStore, coroutineDispatcher, string);
    }

    public DefaultProcessingEventProcessor(@NotNull ScheduleService scheduleService, @NotNull SerializeService serializeService, @NotNull MessageDispatcher messageDispatcher, @NotNull PublishedVersionStore publishedVersionStore, @NotNull CoroutineDispatcher coroutineDispatcher) {
        Intrinsics.checkNotNullParameter((Object)scheduleService, (String)"scheduleService");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        Intrinsics.checkNotNullParameter((Object)messageDispatcher, (String)"messageDispatcher");
        Intrinsics.checkNotNullParameter((Object)publishedVersionStore, (String)"publishedVersionStore");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        this(scheduleService, serializeService, messageDispatcher, publishedVersionStore, coroutineDispatcher, "DefaultEventProcessor");
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void process(@NotNull ProcessingEvent processingEvent) {
        EnqueueMessageResult enqueueResult;
        Intrinsics.checkNotNullParameter((Object)processingEvent, (String)"processingEvent");
        String aggregateRootId = processingEvent.getMessage().getAggregateRootId();
        if (!(!Strings.isNullOrEmpty((String)aggregateRootId))) {
            boolean $i$a$-require-DefaultProcessingEventProcessor$process$22 = false;
            String $i$a$-require-DefaultProcessingEventProcessor$process$22 = "aggregateRootId of domain event stream cannot be null or empty, domainEventStreamId:" + processingEvent.getMessage().getId();
            throw new IllegalArgumentException($i$a$-require-DefaultProcessingEventProcessor$process$22.toString());
        }
        ProcessingEventMailBox processingEventMailBox = this.mailboxDict.computeIfAbsent(aggregateRootId, arg_0 -> DefaultProcessingEventProcessor.process$lambda$1((Function1)new Function1<String, ProcessingEventMailBox>(this, processingEvent){
            final /* synthetic */ DefaultProcessingEventProcessor this$0;
            final /* synthetic */ ProcessingEvent $processingEvent;
            {
                this.this$0 = $receiver;
                this.$processingEvent = $processingEvent;
                super(1);
            }

            @NotNull
            public final ProcessingEventMailBox invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DefaultProcessingEventProcessor.access$buildProcessingEventMailBox(this.this$0, this.$processingEvent);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)processingEventMailBox, (String)"override fun process(pro\u2026mailbox.exitUsing()\n    }");
        ProcessingEventMailBox mailbox2 = processingEventMailBox;
        long mailboxTryUsingCount = 0L;
        while (!mailbox2.tryUsing()) {
            Task.sleep(1L);
            long l = mailboxTryUsingCount;
            if ((mailboxTryUsingCount = l + 1L) % (long)10000 != 0L) continue;
            Object[] objectArray = new Object[]{mailboxTryUsingCount, mailbox2.getAggregateRootId(), mailbox2.getAggregateRootTypeName()};
            this.logger.warn("Event mailbox try using count: {}, aggregateRootId: {}, aggregateRootTypeName: {}", objectArray);
        }
        if (mailbox2.isRemoved()) {
            ProcessingEventMailBox processingEventMailBox2 = this.mailboxDict.computeIfAbsent(aggregateRootId, arg_0 -> DefaultProcessingEventProcessor.process$lambda$2((Function1)new Function1<String, ProcessingEventMailBox>(this, processingEvent){
                final /* synthetic */ DefaultProcessingEventProcessor this$0;
                final /* synthetic */ ProcessingEvent $processingEvent;
                {
                    this.this$0 = $receiver;
                    this.$processingEvent = $processingEvent;
                    super(1);
                }

                @NotNull
                public final ProcessingEventMailBox invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return DefaultProcessingEventProcessor.access$buildProcessingEventMailBox(this.this$0, this.$processingEvent);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)processingEventMailBox2, (String)"override fun process(pro\u2026mailbox.exitUsing()\n    }");
            mailbox2 = processingEventMailBox2;
        }
        if ((enqueueResult = mailbox2.enqueueMessage(processingEvent)) == EnqueueMessageResult.Ignored) {
            processingEvent.getProcessContext().notifyEventProcessed();
        } else if (enqueueResult == EnqueueMessageResult.AddToWaitingList) {
            this.addToRefreshAggregateMailBoxToDict(mailbox2);
        }
        mailbox2.exitUsing();
    }

    private final void addToRefreshAggregateMailBoxToDict(ProcessingEventMailBox mailbox2) {
        if (this.toRefreshAggregateRootMailBoxDict.putIfAbsent(mailbox2.getAggregateRootId(), mailbox2) == null) {
            this.logger.info("Added toRefreshPublishedVersion aggregate mailbox, aggregateRootTypeName: {}, aggregateRootId: {}", (Object)mailbox2.getAggregateRootTypeName(), (Object)mailbox2.getAggregateRootId());
            this.tryToRefreshAggregateMailBoxNextExpectingEventVersion(mailbox2);
        }
    }

    private final ProcessingEventMailBox buildProcessingEventMailBox(ProcessingEvent processingMessage) {
        return new ProcessingEventMailBox(processingMessage.getMessage().getAggregateRootTypeName(), processingMessage.getMessage().getAggregateRootId(), this.coroutineDispatcher, arg_0 -> DefaultProcessingEventProcessor.buildProcessingEventMailBox$lambda$3(this, arg_0));
    }

    private final void tryToRefreshAggregateMailBoxNextExpectingEventVersion(ProcessingEventMailBox processingEventMailBox) {
        if (this.refreshingAggregateRootDict.putIfAbsent(processingEventMailBox.getAggregateRootId(), true) == null) {
            this.getAggregateRootLatestPublishedEventVersion(processingEventMailBox, 0);
        }
    }

    private final void getAggregateRootLatestPublishedEventVersion(ProcessingEventMailBox processingEventMailBox, int retryTimes) {
        IOHelper.tryAsyncActionRecursively("GetAggregateRootLatestPublishedEventVersion", () -> DefaultProcessingEventProcessor.getAggregateRootLatestPublishedEventVersion$lambda$4(this, processingEventMailBox), arg_0 -> DefaultProcessingEventProcessor.getAggregateRootLatestPublishedEventVersion$lambda$5(processingEventMailBox, this, arg_0), () -> DefaultProcessingEventProcessor.getAggregateRootLatestPublishedEventVersion$lambda$6(processingEventMailBox), null, retryTimes, true);
    }

    @Override
    public void start() {
        this.scheduleService.startTask(this.scanInactiveMailBoxTaskName, () -> DefaultProcessingEventProcessor.start$lambda$7(this), this.scanExpiredAggregateIntervalMilliseconds, this.scanExpiredAggregateIntervalMilliseconds);
        this.scheduleService.startTask(this.processTryToRefreshAggregateTaskName, () -> DefaultProcessingEventProcessor.start$lambda$8(this), this.processTryToRefreshAggregateIntervalMilliseconds, this.processTryToRefreshAggregateIntervalMilliseconds);
    }

    @Override
    public void stop() {
        this.scheduleService.stopTask(this.scanInactiveMailBoxTaskName);
        this.scheduleService.stopTask(this.processTryToRefreshAggregateTaskName);
    }

    private final void dispatchProcessingMessageAsync(ProcessingEvent processingEvent, int retryTimes) {
        IOHelper.tryAsyncActionRecursivelyWithoutResult("DispatchProcessingMessageAsync", () -> DefaultProcessingEventProcessor.dispatchProcessingMessageAsync$lambda$9(this, processingEvent), arg_0 -> DefaultProcessingEventProcessor.dispatchProcessingMessageAsync$lambda$10(this, processingEvent, arg_0), () -> DefaultProcessingEventProcessor.dispatchProcessingMessageAsync$lambda$11(processingEvent), null, retryTimes, true);
    }

    private final void updatePublishedVersionAsync(ProcessingEvent processingEvent, int retryTimes) {
        DomainEventStream message = processingEvent.getMessage();
        IOHelper.tryAsyncActionRecursivelyWithoutResult("UpdatePublishedVersionAsync", () -> DefaultProcessingEventProcessor.updatePublishedVersionAsync$lambda$12(this, message), arg_0 -> DefaultProcessingEventProcessor.updatePublishedVersionAsync$lambda$13(this, message, processingEvent, arg_0), () -> DefaultProcessingEventProcessor.updatePublishedVersionAsync$lambda$14(message), null, retryTimes, true);
    }

    private final void processToRefreshAggregateRootMailBoxs() {
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList()");
        List remainingMailboxList = arrayList;
        ArrayList arrayList2 = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList2, (String)"newArrayList()");
        List recoveredMailboxList = arrayList2;
        Collection<ProcessingEventMailBox> collection = this.toRefreshAggregateRootMailBoxDict.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"toRefreshAggregateRootMailBoxDict.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessingEventMailBox aggregateRootMailBox = (ProcessingEventMailBox)element$iv;
            boolean bl = false;
            if (aggregateRootMailBox.getWaitingMessageCount() > 0) {
                remainingMailboxList.add(aggregateRootMailBox);
                continue;
            }
            recoveredMailboxList.add(aggregateRootMailBox);
        }
        for (ProcessingEventMailBox mailBox : remainingMailboxList) {
            this.tryToRefreshAggregateMailBoxNextExpectingEventVersion(mailBox);
        }
        for (ProcessingEventMailBox mailBox : recoveredMailboxList) {
            ProcessingEventMailBox removed = this.toRefreshAggregateRootMailBoxDict.remove(mailBox.getAggregateRootId());
            if (removed == null) continue;
            this.logger.info("Removed healthy aggregate mailbox, aggregateRootTypeName: {}, aggregateRootId: {}", (Object)removed.getAggregateRootTypeName(), (Object)removed.getAggregateRootId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanInactiveMailbox() {
        void $this$filterTo$iv$iv;
        Set<Map.Entry<String, ProcessingEventMailBox>> set = this.mailboxDict.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"mailboxDict.entries");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"entry.value");
            if (!this.isMailBoxAllowRemove((ProcessingEventMailBox)v)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inactiveList = (List)destination$iv$iv;
        Iterable $this$forEach$iv = inactiveList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessingEventMailBox removed;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            ProcessingEventMailBox value = (ProcessingEventMailBox)entry.getValue();
            if (!value.tryUsing() || !this.isMailBoxAllowRemove(value) || (removed = this.mailboxDict.remove(key)) == null) continue;
            removed.markAsRemoved();
            this.logger.info("Removed inactive domain event stream mailbox, aggregateRootTypeName: {}, aggregateRootId: {}", (Object)removed.getAggregateRootTypeName(), (Object)removed.getAggregateRootId());
        }
    }

    private final boolean isMailBoxAllowRemove(ProcessingEventMailBox mailbox2) {
        return mailbox2.isInactive(this.timeoutSeconds) && !mailbox2.isRunning() && mailbox2.getTotalUnHandledMessageCount() == 0 && mailbox2.getWaitingMessageCount() == 0;
    }

    private static final ProcessingEventMailBox process$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProcessingEventMailBox)$tmp0.invoke(p0);
    }

    private static final ProcessingEventMailBox process$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProcessingEventMailBox)$tmp0.invoke(p0);
    }

    private static final void buildProcessingEventMailBox$lambda$3(DefaultProcessingEventProcessor this$0, ProcessingEvent y) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this$0.dispatchProcessingMessageAsync(y, 0);
    }

    private static final CompletableFuture getAggregateRootLatestPublishedEventVersion$lambda$4(DefaultProcessingEventProcessor this$0, ProcessingEventMailBox $processingEventMailBox) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingEventMailBox, (String)"$processingEventMailBox");
        return this$0.publishedVersionStore.getPublishedVersionAsync(this$0.getName(), $processingEventMailBox.getAggregateRootTypeName(), $processingEventMailBox.getAggregateRootId());
    }

    private static final void getAggregateRootLatestPublishedEventVersion$lambda$5(ProcessingEventMailBox $processingEventMailBox, DefaultProcessingEventProcessor this$0, int result) {
        Intrinsics.checkNotNullParameter((Object)$processingEventMailBox, (String)"$processingEventMailBox");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $processingEventMailBox.setNextExpectingEventVersion(result + 1);
        this$0.refreshingAggregateRootDict.remove($processingEventMailBox.getAggregateRootId());
    }

    private static final String getAggregateRootLatestPublishedEventVersion$lambda$6(ProcessingEventMailBox $processingEventMailBox) {
        Intrinsics.checkNotNullParameter((Object)$processingEventMailBox, (String)"$processingEventMailBox");
        return "publishedVersionStore.GetPublishedVersionAsync has unknown exception, aggregateRootTypeName: " + $processingEventMailBox.getAggregateRootTypeName() + ", aggregateRootId: " + $processingEventMailBox.getAggregateRootId();
    }

    private static final void start$lambda$7(DefaultProcessingEventProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cleanInactiveMailbox();
    }

    private static final void start$lambda$8(DefaultProcessingEventProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.processToRefreshAggregateRootMailBoxs();
    }

    private static final CompletableFuture dispatchProcessingMessageAsync$lambda$9(DefaultProcessingEventProcessor this$0, ProcessingEvent $processingEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingEvent, (String)"$processingEvent");
        return this$0.messageDispatcher.dispatchMessagesAsync($processingEvent.getMessage().getEvents());
    }

    private static final void dispatchProcessingMessageAsync$lambda$10(DefaultProcessingEventProcessor this$0, ProcessingEvent $processingEvent, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingEvent, (String)"$processingEvent");
        if (this$0.logger.isDebugEnabled()) {
            this$0.logger.debug("dispatch messages success, msg: {}", (Object)this$0.serializeService.serialize($processingEvent.getMessage()));
        }
        this$0.updatePublishedVersionAsync($processingEvent, 0);
    }

    private static final String dispatchProcessingMessageAsync$lambda$11(ProcessingEvent $processingEvent) {
        Intrinsics.checkNotNullParameter((Object)$processingEvent, (String)"$processingEvent");
        return "sequence message [messageId:" + $processingEvent.getMessage().getId() + ", messageType:" + $processingEvent.getMessage().getClass().getName() + ", aggregateRootId:" + $processingEvent.getMessage().getAggregateRootId() + ", aggregateRootVersion:" + $processingEvent.getMessage().getVersion() + ']';
    }

    private static final CompletableFuture updatePublishedVersionAsync$lambda$12(DefaultProcessingEventProcessor this$0, DomainEventStream $message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        return this$0.publishedVersionStore.updatePublishedVersionAsync(this$0.getName(), $message.getAggregateRootTypeName(), $message.getAggregateRootId(), $message.getVersion());
    }

    private static final void updatePublishedVersionAsync$lambda$13(DefaultProcessingEventProcessor this$0, DomainEventStream $message, ProcessingEvent $processingEvent, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$processingEvent, (String)"$processingEvent");
        if (this$0.logger.isDebugEnabled()) {
            this$0.logger.debug("update published version success, message ack: {}", (Object)this$0.serializeService.serialize($message));
        }
        $processingEvent.complete();
    }

    private static final String updatePublishedVersionAsync$lambda$14(DomainEventStream $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        return "DomainEventStreamMessage [messageId:" + $message.getId() + ", messageType:" + $message.getClass().getName() + ", aggregateRootId:" + $message.getAggregateRootId() + ", aggregateRootVersion:" + $message.getVersion() + ']';
    }

    public static final /* synthetic */ ProcessingEventMailBox access$buildProcessingEventMailBox(DefaultProcessingEventProcessor $this, ProcessingEvent processingMessage) {
        return $this.buildProcessingEventMailBox(processingMessage);
    }
}

