/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.eventing.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.eventing.PublishedVersionStore;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/enodeframework/eventing/impl/InMemoryPublishedVersionStore;", "Lorg/enodeframework/eventing/PublishedVersionStore;", "()V", "versionDict", "Ljava/util/concurrent/ConcurrentMap;", "", "", "buildKey", "eventProcessorName", "aggregateRootId", "getPublishedVersionAsync", "Ljava/util/concurrent/CompletableFuture;", "processorName", "aggregateRootTypeName", "updatePublishedVersionAsync", "publishedVersion", "enode"})
public final class InMemoryPublishedVersionStore
implements PublishedVersionStore {
    @NotNull
    private final ConcurrentMap<String, Integer> versionDict = new ConcurrentHashMap();

    @Override
    @NotNull
    public CompletableFuture<Integer> updatePublishedVersionAsync(@NotNull String processorName, @NotNull String aggregateRootTypeName, @NotNull String aggregateRootId, int publishedVersion) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Integer n = publishedVersion;
        ((Map)this.versionDict).put(this.buildKey(processorName, aggregateRootId), n);
        CompletableFuture<Integer> completableFuture = CompletableFuture.completedFuture(1);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(1)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Integer> getPublishedVersionAsync(@NotNull String processorName, @NotNull String aggregateRootTypeName, @NotNull String aggregateRootId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Integer publishedVersion = this.versionDict.getOrDefault(this.buildKey(processorName, aggregateRootId), 0);
        CompletableFuture<Integer> completableFuture = CompletableFuture.completedFuture(publishedVersion);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(publishedVersion)");
        return completableFuture;
    }

    private final String buildKey(String eventProcessorName, String aggregateRootId) {
        return eventProcessorName + '-' + aggregateRootId;
    }
}

