/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.infrastructure;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.domain.AggregateRepository;
import org.enodeframework.domain.AggregateRoot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004J\u0012\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0004J\u0012\u0010\t\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a8\u0006\n"}, d2={"Lorg/enodeframework/infrastructure/TypeUtils;", "", "()V", "getGenericType", "Ljava/lang/Class;", "clazz", "isAggregateRepositoryType", "", "type", "isAggregateRoot", "enode"})
public final class TypeUtils {
    @NotNull
    public static final TypeUtils INSTANCE = new TypeUtils();

    private TypeUtils() {
    }

    public final boolean isAggregateRoot(@NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return !Modifier.isAbstract(type.getModifiers()) && AggregateRoot.class.isAssignableFrom(type);
    }

    public final boolean isAggregateRepositoryType(@NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return !Modifier.isAbstract(type.getModifiers()) && AggregateRepository.class.isAssignableFrom(type);
    }

    @NotNull
    public final Class<?> getGenericType(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Type type = clazz.getGenericSuperclass();
        Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
        Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type java.lang.Class<*>");
        return (Class)type2;
    }
}

