/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.infrastructure.impl;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.enodeframework.common.exception.EnodeClassNotFoundException;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u0014\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0014\u0010\r\u001a\u00020\u00042\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/enodeframework/infrastructure/impl/DefaultTypeNameProvider;", "Lorg/enodeframework/infrastructure/TypeNameProvider;", "typeDict", "", "", "(Ljava/util/Map;)V", "checkForAliasCircle", "", "name", "alias", "getType", "Ljava/lang/Class;", "typeName", "getTypeName", "type", "hasAlias", "", "enode"})
@SourceDebugExtension(value={"SMAP\nDefaultTypeNameProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultTypeNameProvider.kt\norg/enodeframework/infrastructure/impl/DefaultTypeNameProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,56:1\n215#2,2:57\n*S KotlinDebug\n*F\n+ 1 DefaultTypeNameProvider.kt\norg/enodeframework/infrastructure/impl/DefaultTypeNameProvider\n*L\n54#1:57,2\n*E\n"})
public final class DefaultTypeNameProvider
implements TypeNameProvider {
    @NotNull
    private final Map<String, String> typeDict;

    public DefaultTypeNameProvider(@NotNull Map<String, String> typeDict) {
        Intrinsics.checkNotNullParameter(typeDict, (String)"typeDict");
        this.typeDict = typeDict;
        Map<String, String> $this$forEach$iv = this.typeDict;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            String alias = entry.getValue();
            this.checkForAliasCircle(name, alias);
        }
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        String string = type.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.name");
        return string;
    }

    @Override
    @NotNull
    public Class<?> getType(@NotNull String typeName) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        try {
            Class<?> clazz2 = Class.forName(typeName);
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"{\n            Class.forName(typeName)\n        }");
            clazz = clazz2;
        }
        catch (ClassNotFoundException e) {
            String type = this.typeDict.get(typeName);
            if (type != null) {
                return this.getType(type);
            }
            throw new EnodeClassNotFoundException(e);
        }
        return clazz;
    }

    public final void checkForAliasCircle(@NotNull String name, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        if (!(!this.hasAlias(name, alias))) {
            boolean bl = false;
            String string = "Cannot register alias '" + alias + "' for name '" + name + "': Circular reference - '" + name + "' is a direct or indirect alias for '" + alias + "' already";
            throw new IllegalStateException(string.toString());
        }
    }

    private final boolean hasAlias(String name, String alias) {
        String registeredName = this.typeDict.get(alias);
        return Intrinsics.areEqual((Object)registeredName, (Object)name) || registeredName != null && this.hasAlias(name, registeredName);
    }
}

