/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.messaging.impl;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.messaging.Message;
import org.enodeframework.messaging.impl.DefaultMessageDispatcher;
import org.enodeframework.messaging.impl.RootDispatching;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/enodeframework/messaging/impl/QueueMessageDispatching;", "", "dispatcher", "Lorg/enodeframework/messaging/impl/DefaultMessageDispatcher;", "rootDispatching", "Lorg/enodeframework/messaging/impl/RootDispatching;", "messages", "", "Lorg/enodeframework/messaging/Message;", "(Lorg/enodeframework/messaging/impl/DefaultMessageDispatcher;Lorg/enodeframework/messaging/impl/RootDispatching;Ljava/util/List;)V", "messageQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "dequeueMessage", "onMessageHandled", "", "message", "enode"})
public final class QueueMessageDispatching {
    @NotNull
    private final DefaultMessageDispatcher dispatcher;
    @NotNull
    private final RootDispatching rootDispatching;
    @NotNull
    private final ConcurrentLinkedQueue<Message> messageQueue;

    public QueueMessageDispatching(@NotNull DefaultMessageDispatcher dispatcher, @NotNull RootDispatching rootDispatching, @NotNull List<? extends Message> messages) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)rootDispatching, (String)"rootDispatching");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        this.dispatcher = dispatcher;
        this.messageQueue = new ConcurrentLinkedQueue();
        this.messageQueue.addAll((Collection<Message>)messages);
        this.rootDispatching = rootDispatching;
        this.rootDispatching.addChildDispatching(this);
    }

    @Nullable
    public final Message dequeueMessage() {
        return this.messageQueue.poll();
    }

    public final void onMessageHandled(@Nullable Message message) {
        Message nextMessage = this.dequeueMessage();
        if (nextMessage == null) {
            this.rootDispatching.onChildDispatchingFinished(this);
            return;
        }
        this.dispatcher.dispatchSingleMessage(nextMessage, this);
    }
}

