/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.enodeframework.queue.ConnectionHolder;
import org.enodeframework.queue.OutboundDeliveryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointToPointEventBus {
    private static final Logger log = LoggerFactory.getLogger(PointToPointEventBus.class);
    private final EventBusOptions options;
    private final NetClient client;
    private final Vertx vertx;
    private final ConcurrentMap<String, ConnectionHolder> connections = new ConcurrentHashMap<String, ConnectionHolder>();

    public PointToPointEventBus(Vertx vertx, VertxOptions options) {
        this.vertx = vertx;
        this.options = options.getEventBusOptions();
        this.client = vertx.createNetClient(new NetClientOptions(this.options.toJson()));
    }

    NetClient client() {
        return this.client;
    }

    public void send(String address, JsonObject message) {
        OutboundDeliveryContext ctx = new OutboundDeliveryContext(message);
        this.sendToNode(ctx, address);
    }

    public void close() {
        if (this.client != null) {
            this.client.close(serverClose -> {
                if (serverClose.failed()) {
                    log.error("Failed to close server", serverClose.cause());
                }
                for (ConnectionHolder holder : this.connections.values()) {
                    holder.close();
                }
            });
        }
    }

    private void sendToNode(OutboundDeliveryContext sendContext, String nodeId) {
        this.sendRemote(sendContext, nodeId);
    }

    private void sendRemote(OutboundDeliveryContext sendContext, String remoteNodeId) {
        ConnectionHolder holder = (ConnectionHolder)this.connections.get(remoteNodeId);
        if (holder == null) {
            holder = new ConnectionHolder(this, remoteNodeId);
            ConnectionHolder prevHolder = this.connections.putIfAbsent(remoteNodeId, holder);
            if (prevHolder != null) {
                holder = prevHolder;
            } else {
                holder.connect();
            }
        }
        holder.writeMessage(sendContext);
    }

    ConcurrentMap<String, ConnectionHolder> connections() {
        return this.connections;
    }

    EventBusOptions options() {
        return this.options;
    }

    Vertx vertx() {
        return this.vertx;
    }
}

