/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.applicationmessage;

import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.enodeframework.messaging.ApplicationMessage;
import org.enodeframework.messaging.MessagePublisher;
import org.enodeframework.queue.MessageTypeCode;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.SendMessageResult;
import org.enodeframework.queue.SendMessageService;
import org.enodeframework.queue.applicationmessage.GenericApplicationMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/enodeframework/queue/applicationmessage/DefaultApplicationMessagePublisher;", "Lorg/enodeframework/messaging/MessagePublisher;", "Lorg/enodeframework/messaging/ApplicationMessage;", "topic", "", "tag", "producer", "Lorg/enodeframework/queue/SendMessageService;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "typeNameProvider", "Lorg/enodeframework/infrastructure/TypeNameProvider;", "(Ljava/lang/String;Ljava/lang/String;Lorg/enodeframework/queue/SendMessageService;Lorg/enodeframework/common/serializing/SerializeService;Lorg/enodeframework/infrastructure/TypeNameProvider;)V", "createApplicationMessage", "Lorg/enodeframework/queue/QueueMessage;", "message", "publishAsync", "Ljava/util/concurrent/CompletableFuture;", "Lorg/enodeframework/queue/SendMessageResult;", "enode"})
public final class DefaultApplicationMessagePublisher
implements MessagePublisher<ApplicationMessage> {
    @NotNull
    private final String topic;
    @NotNull
    private final String tag;
    @NotNull
    private final SendMessageService producer;
    @NotNull
    private final SerializeService serializeService;
    @NotNull
    private final TypeNameProvider typeNameProvider;

    public DefaultApplicationMessagePublisher(@NotNull String topic, @NotNull String tag, @NotNull SendMessageService producer, @NotNull SerializeService serializeService, @NotNull TypeNameProvider typeNameProvider) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        Intrinsics.checkNotNullParameter((Object)typeNameProvider, (String)"typeNameProvider");
        this.topic = topic;
        this.tag = tag;
        this.producer = producer;
        this.serializeService = serializeService;
        this.typeNameProvider = typeNameProvider;
    }

    private final QueueMessage createApplicationMessage(ApplicationMessage message) {
        Assert.nonNull(this.topic, "topic");
        String appMessageData = this.serializeService.serialize(message);
        GenericApplicationMessage applicationMessage = new GenericApplicationMessage();
        applicationMessage.setApplicationMessageData(appMessageData);
        applicationMessage.setApplicationMessageType(this.typeNameProvider.getTypeName(message.getClass()));
        String data = this.serializeService.serialize(applicationMessage);
        String routeKey = message.getId();
        QueueMessage queueMessage = new QueueMessage();
        queueMessage.setBody(data);
        queueMessage.setRouteKey(routeKey);
        queueMessage.setKey(message.getId());
        queueMessage.setTopic(this.topic);
        queueMessage.setTag(this.tag);
        queueMessage.setType(MessageTypeCode.ApplicationMessage.getValue());
        return queueMessage;
    }

    @Override
    @NotNull
    public CompletableFuture<SendMessageResult> publishAsync(@NotNull ApplicationMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.producer.sendMessageAsync(this.createApplicationMessage(message));
    }
}

