/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.command;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.commanding.CommandMessage;
import org.enodeframework.commanding.CommandProcessor;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.commanding.impl.DefaultCommandExecuteContext;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.domain.AggregateStorage;
import org.enodeframework.domain.Repository;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.enodeframework.queue.MessageContext;
import org.enodeframework.queue.MessageHandler;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.SendReplyService;
import org.enodeframework.queue.command.GenericCommandMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/enodeframework/queue/command/DefaultCommandMessageHandler;", "Lorg/enodeframework/queue/MessageHandler;", "sendReplyService", "Lorg/enodeframework/queue/SendReplyService;", "typeNameProvider", "Lorg/enodeframework/infrastructure/TypeNameProvider;", "commandProcessor", "Lorg/enodeframework/commanding/CommandProcessor;", "repository", "Lorg/enodeframework/domain/Repository;", "aggregateRootStorage", "Lorg/enodeframework/domain/AggregateStorage;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "(Lorg/enodeframework/queue/SendReplyService;Lorg/enodeframework/infrastructure/TypeNameProvider;Lorg/enodeframework/commanding/CommandProcessor;Lorg/enodeframework/domain/Repository;Lorg/enodeframework/domain/AggregateStorage;Lorg/enodeframework/common/serializing/SerializeService;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "handle", "", "queueMessage", "Lorg/enodeframework/queue/QueueMessage;", "context", "Lorg/enodeframework/queue/MessageContext;", "enode"})
public final class DefaultCommandMessageHandler
implements MessageHandler {
    @NotNull
    private final SendReplyService sendReplyService;
    @NotNull
    private final TypeNameProvider typeNameProvider;
    @NotNull
    private final CommandProcessor commandProcessor;
    @NotNull
    private final Repository repository;
    @NotNull
    private final AggregateStorage aggregateRootStorage;
    @NotNull
    private final SerializeService serializeService;
    private final Logger logger;

    public DefaultCommandMessageHandler(@NotNull SendReplyService sendReplyService, @NotNull TypeNameProvider typeNameProvider, @NotNull CommandProcessor commandProcessor, @NotNull Repository repository, @NotNull AggregateStorage aggregateRootStorage, @NotNull SerializeService serializeService) {
        Intrinsics.checkNotNullParameter((Object)sendReplyService, (String)"sendReplyService");
        Intrinsics.checkNotNullParameter((Object)typeNameProvider, (String)"typeNameProvider");
        Intrinsics.checkNotNullParameter((Object)commandProcessor, (String)"commandProcessor");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)aggregateRootStorage, (String)"aggregateRootStorage");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        this.sendReplyService = sendReplyService;
        this.typeNameProvider = typeNameProvider;
        this.commandProcessor = commandProcessor;
        this.repository = repository;
        this.aggregateRootStorage = aggregateRootStorage;
        this.serializeService = serializeService;
        this.logger = LoggerFactory.getLogger(DefaultCommandMessageHandler.class);
    }

    @Override
    public void handle(@NotNull QueueMessage queueMessage, @NotNull MessageContext context) {
        Intrinsics.checkNotNullParameter((Object)queueMessage, (String)"queueMessage");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logger.info("Received command message: {}", (Object)queueMessage);
        GenericCommandMessage commandMessage = this.serializeService.deserialize(queueMessage.getBody(), GenericCommandMessage.class);
        Class<?> commandType = this.typeNameProvider.getType(commandMessage.getCommandType());
        Object obj = this.serializeService.deserialize(commandMessage.getCommandData(), commandType);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.enodeframework.commanding.CommandMessage");
        CommandMessage command = (CommandMessage)obj;
        DefaultCommandExecuteContext commandExecuteContext = new DefaultCommandExecuteContext(this.repository, this.aggregateRootStorage, queueMessage, context, commandMessage, this.sendReplyService);
        Map commandItems = new HashMap();
        String uri = commandMessage.getReplyAddress();
        if (!Strings.isNullOrEmpty((String)uri)) {
            commandItems.put("COMMAND_REPLY_ADDRESS", uri);
        }
        this.commandProcessor.process(new ProcessingCommand(command, commandExecuteContext, commandItems));
    }
}

