/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.command;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalNotification;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetServerOptions;
import io.vertx.ext.bridge.BridgeOptions;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.commanding.CommandMessage;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.CommandReturnType;
import org.enodeframework.commanding.CommandStatus;
import org.enodeframework.common.exception.DuplicateCommandRegisterException;
import org.enodeframework.common.extensions.SystemClock;
import org.enodeframework.common.scheduling.ScheduleService;
import org.enodeframework.common.scheduling.Worker;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.queue.command.CommandResultProcessor;
import org.enodeframework.queue.command.CommandTaskCompletionSource;
import org.enodeframework.queue.domainevent.DomainEventHandledMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010 \u001a\u00020\u0013H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0016H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u000eH\u0002J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0002J\u001a\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00132\b\u0010.\u001a\u0004\u0018\u00010\u0014H\u0002J&\u0010/\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000e03H\u0016J\b\u00104\u001a\u00020\"H\u0016J\b\u00105\u001a\u00020\"H\u0002J\b\u00106\u001a\u00020\"H\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/enodeframework/queue/command/DefaultCommandResultProcessor;", "Lio/vertx/core/AbstractVerticle;", "Lorg/enodeframework/queue/command/CommandResultProcessor;", "scheduleService", "Lorg/enodeframework/common/scheduling/ScheduleService;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "serverOptions", "Lio/vertx/core/net/NetServerOptions;", "completionSourceTimeout", "", "(Lorg/enodeframework/common/scheduling/ScheduleService;Lorg/enodeframework/common/serializing/SerializeService;Lio/vertx/core/net/NetServerOptions;I)V", "commandExecutedMessageLocalQueue", "Ljava/util/concurrent/BlockingQueue;", "Lorg/enodeframework/commanding/CommandResult;", "commandExecutedMessageWorker", "Lorg/enodeframework/common/scheduling/Worker;", "commandTaskDict", "Lcom/google/common/cache/Cache;", "", "Lorg/enodeframework/queue/command/CommandTaskCompletionSource;", "domainEventHandledMessageLocalQueue", "Lorg/enodeframework/queue/domainevent/DomainEventHandledMessage;", "domainEventHandledMessageWorker", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scanExpireCommandTaskName", "started", "", "tcpEventBusBridge", "Lio/vertx/ext/eventbus/bridge/tcp/TcpEventBusBridge;", "getBindAddress", "processDomainEventHandledMessage", "", "message", "processExecutedCommandMessage", "commandResult", "processFailedSendingCommand", "command", "Lorg/enodeframework/commanding/CommandMessage;", "processRequestInternal", "reply", "Lio/vertx/core/json/JsonObject;", "processTimeoutCommand", "commandId", "commandTaskCompletionSource", "registerProcessingCommand", "commandReturnType", "Lorg/enodeframework/commanding/CommandReturnType;", "taskCompletionSource", "Ljava/util/concurrent/CompletableFuture;", "start", "startServer", "stop", "enode"})
public final class DefaultCommandResultProcessor
extends AbstractVerticle
implements CommandResultProcessor {
    @NotNull
    private final ScheduleService scheduleService;
    @NotNull
    private final SerializeService serializeService;
    @NotNull
    private final NetServerOptions serverOptions;
    private final int completionSourceTimeout;
    @NotNull
    private final String scanExpireCommandTaskName;
    @NotNull
    private final Cache<String, CommandTaskCompletionSource> commandTaskDict;
    @NotNull
    private final BlockingQueue<CommandResult> commandExecutedMessageLocalQueue;
    @NotNull
    private final BlockingQueue<DomainEventHandledMessage> domainEventHandledMessageLocalQueue;
    @NotNull
    private final Worker commandExecutedMessageWorker;
    @NotNull
    private final Worker domainEventHandledMessageWorker;
    private TcpEventBusBridge tcpEventBusBridge;
    private boolean started;
    private final Logger logger;

    public DefaultCommandResultProcessor(@NotNull ScheduleService scheduleService, @NotNull SerializeService serializeService, @NotNull NetServerOptions serverOptions, int completionSourceTimeout) {
        Intrinsics.checkNotNullParameter((Object)scheduleService, (String)"scheduleService");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        Intrinsics.checkNotNullParameter((Object)serverOptions, (String)"serverOptions");
        this.scheduleService = scheduleService;
        this.serializeService = serializeService;
        this.serverOptions = serverOptions;
        this.completionSourceTimeout = completionSourceTimeout;
        this.scanExpireCommandTaskName = "CleanTimeoutCommandTask_" + SystemClock.now() + new Random().nextInt(5000);
        this.logger = LoggerFactory.getLogger(DefaultCommandResultProcessor.class);
        Cache cache = CacheBuilder.newBuilder().removalListener(arg_0 -> DefaultCommandResultProcessor._init_$lambda$3((Function1)new Function1<RemovalNotification<String, CommandTaskCompletionSource>, Unit>(){

            public final void invoke(RemovalNotification<String, CommandTaskCompletionSource> notification) {
                if (notification.getCause() == RemovalCause.EXPIRED) {
                    Object object = notification.getKey();
                    Intrinsics.checkNotNull((Object)object);
                    this.processTimeoutCommand((String)object, (CommandTaskCompletionSource)notification.getValue());
                }
            }
        }, arg_0)).expireAfterWrite((long)this.completionSourceTimeout, TimeUnit.MILLISECONDS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"newBuilder()\n           \u2026NDS)\n            .build()");
        this.commandTaskDict = cache;
        this.commandExecutedMessageLocalQueue = new LinkedBlockingQueue();
        this.domainEventHandledMessageLocalQueue = new LinkedBlockingQueue();
        this.commandExecutedMessageWorker = new Worker("ProcessExecutedCommandMessage", () -> DefaultCommandResultProcessor._init_$lambda$4(this));
        this.domainEventHandledMessageWorker = new Worker("ProcessDomainEventHandledMessage", () -> DefaultCommandResultProcessor._init_$lambda$5(this));
    }

    private final void startServer() {
        String address = this.getBindAddress();
        this.vertx.eventBus().consumer(address, arg_0 -> DefaultCommandResultProcessor.startServer$lambda$0(this, arg_0));
        BridgeOptions bridgeOptions = new BridgeOptions();
        bridgeOptions.addInboundPermitted(new PermittedOptions().setAddress(address));
        bridgeOptions.addOutboundPermitted(new PermittedOptions().setAddress(address));
        TcpEventBusBridge tcpEventBusBridge = TcpEventBusBridge.create((Vertx)this.vertx, (BridgeOptions)bridgeOptions, (NetServerOptions)this.serverOptions);
        Intrinsics.checkNotNullExpressionValue((Object)tcpEventBusBridge, (String)"create(vertx, bridgeOptions, serverOptions)");
        this.tcpEventBusBridge = tcpEventBusBridge;
        TcpEventBusBridge tcpEventBusBridge2 = this.tcpEventBusBridge;
        if (tcpEventBusBridge2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tcpEventBusBridge");
            tcpEventBusBridge2 = null;
        }
        tcpEventBusBridge2.listen(this.serverOptions.getPort()).onComplete(arg_0 -> DefaultCommandResultProcessor.startServer$lambda$1(this, address, arg_0));
    }

    @Override
    public void registerProcessingCommand(@NotNull CommandMessage command, @NotNull CommandReturnType commandReturnType, @NotNull CompletableFuture<CommandResult> taskCompletionSource) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)commandReturnType), (String)"commandReturnType");
        Intrinsics.checkNotNullParameter(taskCompletionSource, (String)"taskCompletionSource");
        if (this.commandTaskDict.asMap().putIfAbsent(command.getId(), new CommandTaskCompletionSource(command.getAggregateRootId(), commandReturnType, taskCompletionSource)) != null) {
            throw new DuplicateCommandRegisterException("Duplicate processing command registration, type:" + command.getClass().getName() + ", id:" + command.getId());
        }
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.startServer();
        this.commandExecutedMessageWorker.start();
        this.domainEventHandledMessageWorker.start();
        this.scheduleService.startTask(this.scanExpireCommandTaskName, () -> DefaultCommandResultProcessor.start$lambda$2(this), this.completionSourceTimeout, this.completionSourceTimeout);
        this.started = true;
    }

    public void stop() {
        this.scheduleService.stopTask(this.scanExpireCommandTaskName);
        this.commandExecutedMessageWorker.stop();
        this.domainEventHandledMessageWorker.stop();
        TcpEventBusBridge tcpEventBusBridge = this.tcpEventBusBridge;
        if (tcpEventBusBridge == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tcpEventBusBridge");
            tcpEventBusBridge = null;
        }
        tcpEventBusBridge.close();
    }

    @Override
    @NotNull
    public String getBindAddress() {
        String string = "enode://%s:%d";
        Object[] objectArray = new Object[]{this.serverOptions.getHost(), this.serverOptions.getPort()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private final void processRequestInternal(JsonObject reply) {
        Integer code;
        Integer n = code = reply.getInteger("code", Integer.valueOf(0));
        int n2 = CommandReturnType.CommandExecuted.getValue();
        if (n != null && n == n2) {
            JsonObject result = reply.getJsonObject("commandResult");
            this.commandExecutedMessageLocalQueue.add((CommandResult)result.mapTo(CommandResult.class));
        } else {
            Integer n3 = code;
            int result = CommandReturnType.EventHandled.getValue();
            if (n3 != null && n3 == result) {
                JsonObject message = reply.getJsonObject("eventHandledMessage");
                this.domainEventHandledMessageLocalQueue.add((DomainEventHandledMessage)message.mapTo(DomainEventHandledMessage.class));
            }
        }
    }

    private final void processExecutedCommandMessage(CommandResult commandResult) {
        CommandTaskCompletionSource commandTaskCompletionSource = (CommandTaskCompletionSource)this.commandTaskDict.asMap().get(commandResult.getCommandId());
        if (commandTaskCompletionSource == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Command result return, {}, but commandTaskCompletionSource maybe timeout expired.", (Object)this.serializeService.serialize(commandResult));
            }
            return;
        }
        if (commandTaskCompletionSource.getCommandReturnType() == CommandReturnType.CommandExecuted) {
            this.commandTaskDict.asMap().remove(commandResult.getCommandId());
            if (commandTaskCompletionSource.getTaskCompletionSource().complete(commandResult) && this.logger.isDebugEnabled()) {
                this.logger.debug("Command result return CommandExecuted, {}", (Object)this.serializeService.serialize(commandResult));
            }
        } else if (commandTaskCompletionSource.getCommandReturnType() == CommandReturnType.EventHandled && (CommandStatus.Failed == commandResult.getStatus() || CommandStatus.NothingChanged == commandResult.getStatus())) {
            this.commandTaskDict.asMap().remove(commandResult.getCommandId());
            if (commandTaskCompletionSource.getTaskCompletionSource().complete(commandResult) && this.logger.isDebugEnabled()) {
                this.logger.debug("Command result return EventHandled, {}", (Object)this.serializeService.serialize(commandResult));
            }
        }
    }

    private final void processTimeoutCommand(String commandId, CommandTaskCompletionSource commandTaskCompletionSource) {
        if (commandTaskCompletionSource != null) {
            this.logger.error("Wait command notify timeout, commandId: {}", (Object)commandId);
            String string = commandTaskCompletionSource.getAggregateRootId();
            String string2 = String.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"String::class.java.name");
            CommandResult commandResult = new CommandResult(CommandStatus.Failed, commandId, string, "Wait command notify timeout.", string2);
            commandTaskCompletionSource.getTaskCompletionSource().complete(commandResult);
        }
    }

    @Override
    public void processFailedSendingCommand(@NotNull CommandMessage command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        CommandTaskCompletionSource commandTaskCompletionSource = (CommandTaskCompletionSource)this.commandTaskDict.asMap().remove(command.getId());
        if (commandTaskCompletionSource != null) {
            String string = command.getId();
            String string2 = command.getAggregateRootId();
            String string3 = String.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"String::class.java.name");
            CommandResult commandResult = new CommandResult(CommandStatus.Failed, string, string2, "Failed to send the command.", string3);
            commandTaskCompletionSource.getTaskCompletionSource().complete(commandResult);
        }
    }

    private final void processDomainEventHandledMessage(DomainEventHandledMessage message) {
        CommandTaskCompletionSource commandTaskCompletionSource = (CommandTaskCompletionSource)this.commandTaskDict.asMap().get(message.getCommandId());
        if (commandTaskCompletionSource != null) {
            if (CommandReturnType.EventHandled != commandTaskCompletionSource.getCommandReturnType()) {
                this.logger.warn("event arrived early than command: {}", (Object)this.serializeService.serialize(message));
                return;
            }
            this.commandTaskDict.asMap().remove(message.getCommandId());
            CommandResult commandResult = new CommandResult(CommandStatus.Success, message.getCommandId(), message.getAggregateRootId(), message.getCommandResult(), "");
            commandTaskCompletionSource.getTaskCompletionSource().complete(commandResult);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("DomainEvent result return, {}", (Object)this.serializeService.serialize(message));
            }
        }
    }

    private static final void startServer$lambda$0(DefaultCommandResultProcessor this$0, Message msg) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Object object = msg.body();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"msg.body()");
        this$0.processRequestInternal((JsonObject)object);
    }

    private static final void startServer$lambda$1(DefaultCommandResultProcessor this$0, String $address, AsyncResult res) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
        if (!res.succeeded()) {
            this$0.logger.error("vertx netServer start failed. addr: {}", (Object)$address, (Object)res.cause());
        }
    }

    private static final void start$lambda$2(DefaultCommandResultProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.commandTaskDict.cleanUp();
    }

    private static final void _init_$lambda$3(Function1 $tmp0, RemovalNotification notification) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)notification);
    }

    private static final void _init_$lambda$4(DefaultCommandResultProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CommandResult commandResult = this$0.commandExecutedMessageLocalQueue.take();
        Intrinsics.checkNotNullExpressionValue((Object)commandResult, (String)"commandExecutedMessageLocalQueue.take()");
        this$0.processExecutedCommandMessage(commandResult);
    }

    private static final void _init_$lambda$5(DefaultCommandResultProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DomainEventHandledMessage domainEventHandledMessage = this$0.domainEventHandledMessageLocalQueue.take();
        Intrinsics.checkNotNullExpressionValue((Object)domainEventHandledMessage, (String)"domainEventHandledMessageLocalQueue.take()");
        this$0.processDomainEventHandledMessage(domainEventHandledMessage);
    }
}

