/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.domainevent;

import com.google.common.base.Strings;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EventProcessContext;
import org.enodeframework.eventing.EventSerializer;
import org.enodeframework.eventing.ProcessingEvent;
import org.enodeframework.eventing.ProcessingEventProcessor;
import org.enodeframework.queue.MessageContext;
import org.enodeframework.queue.MessageHandler;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.SendReplyService;
import org.enodeframework.queue.domainevent.DomainEventHandledMessage;
import org.enodeframework.queue.domainevent.GenericDomainEventMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/enodeframework/queue/domainevent/DefaultDomainEventMessageHandler;", "Lorg/enodeframework/queue/MessageHandler;", "sendReplyService", "Lorg/enodeframework/queue/SendReplyService;", "domainEventMessageProcessor", "Lorg/enodeframework/eventing/ProcessingEventProcessor;", "eventSerializer", "Lorg/enodeframework/eventing/EventSerializer;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "(Lorg/enodeframework/queue/SendReplyService;Lorg/enodeframework/eventing/ProcessingEventProcessor;Lorg/enodeframework/eventing/EventSerializer;Lorg/enodeframework/common/serializing/SerializeService;)V", "isSendEventHandledMessage", "", "()Z", "setSendEventHandledMessage", "(Z)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getSendReplyService", "()Lorg/enodeframework/queue/SendReplyService;", "convertToDomainEventStream", "Lorg/enodeframework/eventing/DomainEventStream;", "message", "Lorg/enodeframework/queue/domainevent/GenericDomainEventMessage;", "handle", "", "queueMessage", "Lorg/enodeframework/queue/QueueMessage;", "context", "Lorg/enodeframework/queue/MessageContext;", "DomainEventStreamProcessContext", "enode"})
public final class DefaultDomainEventMessageHandler
implements MessageHandler {
    @NotNull
    private final SendReplyService sendReplyService;
    @NotNull
    private final ProcessingEventProcessor domainEventMessageProcessor;
    @NotNull
    private final EventSerializer eventSerializer;
    @NotNull
    private final SerializeService serializeService;
    private final Logger logger;
    private boolean isSendEventHandledMessage;

    public DefaultDomainEventMessageHandler(@NotNull SendReplyService sendReplyService, @NotNull ProcessingEventProcessor domainEventMessageProcessor, @NotNull EventSerializer eventSerializer, @NotNull SerializeService serializeService) {
        Intrinsics.checkNotNullParameter((Object)sendReplyService, (String)"sendReplyService");
        Intrinsics.checkNotNullParameter((Object)domainEventMessageProcessor, (String)"domainEventMessageProcessor");
        Intrinsics.checkNotNullParameter((Object)eventSerializer, (String)"eventSerializer");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        this.sendReplyService = sendReplyService;
        this.domainEventMessageProcessor = domainEventMessageProcessor;
        this.eventSerializer = eventSerializer;
        this.serializeService = serializeService;
        this.logger = LoggerFactory.getLogger(DefaultDomainEventMessageHandler.class);
        this.isSendEventHandledMessage = true;
    }

    @NotNull
    public final SendReplyService getSendReplyService() {
        return this.sendReplyService;
    }

    public final boolean isSendEventHandledMessage() {
        return this.isSendEventHandledMessage;
    }

    public final void setSendEventHandledMessage(boolean bl) {
        this.isSendEventHandledMessage = bl;
    }

    @Override
    public void handle(@NotNull QueueMessage queueMessage, @NotNull MessageContext context) {
        Intrinsics.checkNotNullParameter((Object)queueMessage, (String)"queueMessage");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logger.info("Received event stream message: {}", (Object)queueMessage);
        GenericDomainEventMessage message = this.serializeService.deserialize(queueMessage.getBody(), GenericDomainEventMessage.class);
        DomainEventStream domainEventStreamMessage = this.convertToDomainEventStream(message);
        DomainEventStreamProcessContext processContext = new DomainEventStreamProcessContext(this, domainEventStreamMessage, queueMessage, context);
        ProcessingEvent processingMessage = new ProcessingEvent(domainEventStreamMessage, processContext);
        this.domainEventMessageProcessor.process(processingMessage);
    }

    private final DomainEventStream convertToDomainEventStream(GenericDomainEventMessage message) {
        DomainEventStream domainEventStreamMessage = new DomainEventStream(message.getCommandId(), message.getAggregateRootId(), message.getVersion(), message.getAggregateRootTypeName(), this.eventSerializer.deserialize(message.getEvents()), message.getItems());
        domainEventStreamMessage.setId(message.getId());
        domainEventStreamMessage.setTimestamp(message.getTimestamp());
        return domainEventStreamMessage;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/enodeframework/queue/domainevent/DefaultDomainEventMessageHandler$DomainEventStreamProcessContext;", "Lorg/enodeframework/eventing/EventProcessContext;", "eventConsumer", "Lorg/enodeframework/queue/domainevent/DefaultDomainEventMessageHandler;", "domainEventStreamMessage", "Lorg/enodeframework/eventing/DomainEventStream;", "queueMessage", "Lorg/enodeframework/queue/QueueMessage;", "messageContext", "Lorg/enodeframework/queue/MessageContext;", "(Lorg/enodeframework/queue/domainevent/DefaultDomainEventMessageHandler;Lorg/enodeframework/eventing/DomainEventStream;Lorg/enodeframework/queue/QueueMessage;Lorg/enodeframework/queue/MessageContext;)V", "notifyEventProcessed", "Ljava/util/concurrent/CompletableFuture;", "", "enode"})
    public static final class DomainEventStreamProcessContext
    implements EventProcessContext {
        @NotNull
        private final DefaultDomainEventMessageHandler eventConsumer;
        @NotNull
        private final DomainEventStream domainEventStreamMessage;
        @NotNull
        private final QueueMessage queueMessage;
        @NotNull
        private final MessageContext messageContext;

        public DomainEventStreamProcessContext(@NotNull DefaultDomainEventMessageHandler eventConsumer, @NotNull DomainEventStream domainEventStreamMessage, @NotNull QueueMessage queueMessage, @NotNull MessageContext messageContext) {
            Intrinsics.checkNotNullParameter((Object)eventConsumer, (String)"eventConsumer");
            Intrinsics.checkNotNullParameter((Object)domainEventStreamMessage, (String)"domainEventStreamMessage");
            Intrinsics.checkNotNullParameter((Object)queueMessage, (String)"queueMessage");
            Intrinsics.checkNotNullParameter((Object)messageContext, (String)"messageContext");
            this.eventConsumer = eventConsumer;
            this.domainEventStreamMessage = domainEventStreamMessage;
            this.queueMessage = queueMessage;
            this.messageContext = messageContext;
        }

        @Override
        @NotNull
        public CompletableFuture<Boolean> notifyEventProcessed() {
            this.messageContext.onMessageHandled(this.queueMessage);
            if (!this.eventConsumer.isSendEventHandledMessage()) {
                return Task.completedTask;
            }
            String address = (String)this.domainEventStreamMessage.getItems().get("COMMAND_REPLY_ADDRESS");
            if (Strings.isNullOrEmpty((String)address)) {
                return Task.completedTask;
            }
            String commandResult = (String)this.domainEventStreamMessage.getItems().get("COMMAND_RESULT");
            DomainEventHandledMessage domainEventHandledMessage = new DomainEventHandledMessage();
            domainEventHandledMessage.setCommandId(this.domainEventStreamMessage.getCommandId());
            domainEventHandledMessage.setAggregateRootId(this.domainEventStreamMessage.getAggregateRootId());
            String string = commandResult;
            if (string == null) {
                string = "";
            }
            domainEventHandledMessage.setCommandResult(string);
            SendReplyService sendReplyService = this.eventConsumer.getSendReplyService();
            String string2 = address;
            Intrinsics.checkNotNull((Object)string2);
            return sendReplyService.sendEventReply(domainEventHandledMessage, string2);
        }
    }
}

