/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.domainevent;

import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EventSerializer;
import org.enodeframework.messaging.MessagePublisher;
import org.enodeframework.queue.MessageTypeCode;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.SendMessageResult;
import org.enodeframework.queue.SendMessageService;
import org.enodeframework.queue.domainevent.GenericDomainEventMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0004J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/enodeframework/queue/domainevent/DefaultDomainEventPublisher;", "Lorg/enodeframework/messaging/MessagePublisher;", "Lorg/enodeframework/eventing/DomainEventStream;", "topic", "", "tag", "eventSerializer", "Lorg/enodeframework/eventing/EventSerializer;", "sendMessageService", "Lorg/enodeframework/queue/SendMessageService;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "(Ljava/lang/String;Ljava/lang/String;Lorg/enodeframework/eventing/EventSerializer;Lorg/enodeframework/queue/SendMessageService;Lorg/enodeframework/common/serializing/SerializeService;)V", "createDomainEventStreamMessage", "Lorg/enodeframework/queue/QueueMessage;", "eventStream", "publishAsync", "Ljava/util/concurrent/CompletableFuture;", "Lorg/enodeframework/queue/SendMessageResult;", "message", "enode"})
public final class DefaultDomainEventPublisher
implements MessagePublisher<DomainEventStream> {
    @NotNull
    private final String topic;
    @NotNull
    private final String tag;
    @NotNull
    private final EventSerializer eventSerializer;
    @NotNull
    private final SendMessageService sendMessageService;
    @NotNull
    private final SerializeService serializeService;

    public DefaultDomainEventPublisher(@NotNull String topic, @NotNull String tag, @NotNull EventSerializer eventSerializer, @NotNull SendMessageService sendMessageService, @NotNull SerializeService serializeService) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)eventSerializer, (String)"eventSerializer");
        Intrinsics.checkNotNullParameter((Object)sendMessageService, (String)"sendMessageService");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        this.topic = topic;
        this.tag = tag;
        this.eventSerializer = eventSerializer;
        this.sendMessageService = sendMessageService;
        this.serializeService = serializeService;
    }

    @NotNull
    protected final QueueMessage createDomainEventStreamMessage(@NotNull DomainEventStream eventStream) {
        Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
        Assert.nonNull(eventStream.getAggregateRootId(), "aggregateRootId");
        Assert.nonNull(this.topic, "topic");
        GenericDomainEventMessage message = new GenericDomainEventMessage();
        message.setId(eventStream.getId());
        message.setCommandId(eventStream.getCommandId());
        message.setAggregateRootTypeName(eventStream.getAggregateRootTypeName());
        message.setAggregateRootId(eventStream.getAggregateRootId());
        message.setTimestamp(eventStream.getTimestamp());
        message.setVersion(eventStream.getVersion());
        message.setEvents(this.eventSerializer.serialize(eventStream.getEvents()));
        message.setItems(eventStream.getItems());
        String data = this.serializeService.serialize(message);
        String routeKey = message.getAggregateRootId();
        QueueMessage queueMessage = new QueueMessage();
        queueMessage.setTopic(this.topic);
        queueMessage.setTag(this.tag);
        queueMessage.setBody(data);
        queueMessage.setType(MessageTypeCode.DomainEventMessage.getValue());
        queueMessage.setRouteKey(routeKey);
        queueMessage.setKey(message.getId() + "_evt_agg_" + message.getAggregateRootId());
        return queueMessage;
    }

    @Override
    @NotNull
    public CompletableFuture<SendMessageResult> publishAsync(@NotNull DomainEventStream message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.sendMessageService.sendMessageAsync(this.createDomainEventStreamMessage(message));
    }
}

