/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.publishableexceptions;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.exception.MessageInstanceCreateException;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.domain.DomainExceptionMessage;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.enodeframework.messaging.MessageDispatcher;
import org.enodeframework.queue.MessageContext;
import org.enodeframework.queue.MessageHandler;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.publishableexceptions.GenericPublishableExceptionMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/enodeframework/queue/publishableexceptions/DefaultPublishableExceptionMessageHandler;", "Lorg/enodeframework/queue/MessageHandler;", "typeNameProvider", "Lorg/enodeframework/infrastructure/TypeNameProvider;", "messageDispatcher", "Lorg/enodeframework/messaging/MessageDispatcher;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "(Lorg/enodeframework/infrastructure/TypeNameProvider;Lorg/enodeframework/messaging/MessageDispatcher;Lorg/enodeframework/common/serializing/SerializeService;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "handle", "", "queueMessage", "Lorg/enodeframework/queue/QueueMessage;", "context", "Lorg/enodeframework/queue/MessageContext;", "enode"})
public final class DefaultPublishableExceptionMessageHandler
implements MessageHandler {
    @NotNull
    private final TypeNameProvider typeNameProvider;
    @NotNull
    private final MessageDispatcher messageDispatcher;
    @NotNull
    private final SerializeService serializeService;
    private final Logger logger;

    public DefaultPublishableExceptionMessageHandler(@NotNull TypeNameProvider typeNameProvider, @NotNull MessageDispatcher messageDispatcher, @NotNull SerializeService serializeService) {
        Intrinsics.checkNotNullParameter((Object)typeNameProvider, (String)"typeNameProvider");
        Intrinsics.checkNotNullParameter((Object)messageDispatcher, (String)"messageDispatcher");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        this.typeNameProvider = typeNameProvider;
        this.messageDispatcher = messageDispatcher;
        this.serializeService = serializeService;
        this.logger = LoggerFactory.getLogger(DefaultPublishableExceptionMessageHandler.class);
    }

    @Override
    public void handle(@NotNull QueueMessage queueMessage, @NotNull MessageContext context) {
        DomainExceptionMessage domainExceptionMessage;
        Intrinsics.checkNotNullParameter((Object)queueMessage, (String)"queueMessage");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logger.info("Received domain exception message: {}", (Object)queueMessage);
        GenericPublishableExceptionMessage exceptionMessage = this.serializeService.deserialize(queueMessage.getBody(), GenericPublishableExceptionMessage.class);
        Class<?> exceptionType = this.typeNameProvider.getType(exceptionMessage.getExceptionType());
        try {
            Object obj = exceptionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.enodeframework.domain.DomainExceptionMessage");
            domainExceptionMessage = (DomainExceptionMessage)obj;
        }
        catch (Exception e) {
            throw new MessageInstanceCreateException(e);
        }
        DomainExceptionMessage exception = domainExceptionMessage;
        exception.setId(exceptionMessage.getUniqueId());
        exception.setTimestamp(exceptionMessage.getTimestamp());
        exception.setItems(exceptionMessage.getItems());
        exception.restoreFrom(exceptionMessage.getSerializableInfo());
        this.messageDispatcher.dispatchMessageAsync(exception).whenComplete((arg_0, arg_1) -> DefaultPublishableExceptionMessageHandler.handle$lambda$0((Function2)new Function2<Boolean, Throwable, Unit>(context, queueMessage){
            final /* synthetic */ MessageContext $context;
            final /* synthetic */ QueueMessage $queueMessage;
            {
                this.$context = $context;
                this.$queueMessage = $queueMessage;
                super(2);
            }

            public final void invoke(Boolean bl, Throwable throwable) {
                this.$context.onMessageHandled(this.$queueMessage);
            }
        }, arg_0, arg_1));
    }

    private static final void handle$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }
}

