/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.publishableexceptions;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.domain.DomainExceptionMessage;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.enodeframework.messaging.MessagePublisher;
import org.enodeframework.queue.MessageTypeCode;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.SendMessageResult;
import org.enodeframework.queue.SendMessageService;
import org.enodeframework.queue.publishableexceptions.GenericPublishableExceptionMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0004J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/enodeframework/queue/publishableexceptions/DefaultPublishableExceptionPublisher;", "Lorg/enodeframework/messaging/MessagePublisher;", "Lorg/enodeframework/domain/DomainExceptionMessage;", "topic", "", "tag", "sendMessageService", "Lorg/enodeframework/queue/SendMessageService;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "typeNameProvider", "Lorg/enodeframework/infrastructure/TypeNameProvider;", "(Ljava/lang/String;Ljava/lang/String;Lorg/enodeframework/queue/SendMessageService;Lorg/enodeframework/common/serializing/SerializeService;Lorg/enodeframework/infrastructure/TypeNameProvider;)V", "createExceptionMessage", "Lorg/enodeframework/queue/QueueMessage;", "exception", "publishAsync", "Ljava/util/concurrent/CompletableFuture;", "Lorg/enodeframework/queue/SendMessageResult;", "message", "enode"})
public final class DefaultPublishableExceptionPublisher
implements MessagePublisher<DomainExceptionMessage> {
    @NotNull
    private final String topic;
    @NotNull
    private final String tag;
    @NotNull
    private final SendMessageService sendMessageService;
    @NotNull
    private final SerializeService serializeService;
    @NotNull
    private final TypeNameProvider typeNameProvider;

    public DefaultPublishableExceptionPublisher(@NotNull String topic, @NotNull String tag, @NotNull SendMessageService sendMessageService, @NotNull SerializeService serializeService, @NotNull TypeNameProvider typeNameProvider) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)sendMessageService, (String)"sendMessageService");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        Intrinsics.checkNotNullParameter((Object)typeNameProvider, (String)"typeNameProvider");
        this.topic = topic;
        this.tag = tag;
        this.sendMessageService = sendMessageService;
        this.serializeService = serializeService;
        this.typeNameProvider = typeNameProvider;
    }

    @NotNull
    protected final QueueMessage createExceptionMessage(@NotNull DomainExceptionMessage exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Assert.nonNull(this.topic, "topic");
        Map serializableInfo = new HashMap();
        exception.serializeTo(serializableInfo);
        GenericPublishableExceptionMessage exceptionMessage = new GenericPublishableExceptionMessage();
        exceptionMessage.setUniqueId(exception.getId());
        exceptionMessage.setExceptionType(this.typeNameProvider.getTypeName(exception.getClass()));
        exceptionMessage.setTimestamp(exception.getTimestamp());
        exceptionMessage.setSerializableInfo(serializableInfo);
        exceptionMessage.setItems(exception.getItems());
        String data = this.serializeService.serialize(exceptionMessage);
        String routeKey = exception.getId();
        QueueMessage queueMessage = new QueueMessage();
        queueMessage.setTopic(this.topic);
        queueMessage.setTag(this.tag);
        queueMessage.setBody(data);
        queueMessage.setRouteKey(routeKey);
        queueMessage.setType(MessageTypeCode.ExceptionMessage.getValue());
        queueMessage.setKey(exceptionMessage.getUniqueId());
        return queueMessage;
    }

    @Override
    @NotNull
    public CompletableFuture<SendMessageResult> publishAsync(@NotNull DomainExceptionMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.sendMessageService.sendMessageAsync(this.createExceptionMessage(message));
    }
}

