/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import java.net.URL;
import org.entur.jwt.client.AbstractAccessTokenProvidersBuilder;
import org.entur.jwt.client.AbstractUrlAccessTokenProvider;
import org.entur.jwt.client.AccessTokenProvider;
import org.entur.jwt.client.ClientCredentials;
import org.entur.jwt.client.StatefulUrlAccessTokenProvider;
import org.entur.jwt.client.UrlAccessTokenProvider;

public class AccessTokenProviderBuilder
extends AbstractAccessTokenProvidersBuilder<AccessTokenProviderBuilder> {
    public static AccessTokenProviderBuilder newBuilder(ClientCredentials credentials) {
        return AccessTokenProviderBuilder.newBuilder(credentials, null, null);
    }

    public static AccessTokenProviderBuilder newBuilder(ClientCredentials credentials, Integer connectTimeout, Integer readTimeout) {
        URL revokeUrl = credentials.getRevokeURL();
        URL refreshUrl = credentials.getRefreshURL();
        if (revokeUrl == null && refreshUrl != null) {
            throw new IllegalStateException("Expected revoke url when refresh url is present");
        }
        if (revokeUrl != null && refreshUrl == null) {
            throw new IllegalStateException("Expected refresh url when revoke url is present");
        }
        AbstractUrlAccessTokenProvider accessTokenProvider = revokeUrl != null && refreshUrl != null ? new StatefulUrlAccessTokenProvider(credentials.getIssueURL(), credentials.getParameters(), credentials.getHeaders(), connectTimeout, readTimeout, refreshUrl, revokeUrl) : new UrlAccessTokenProvider(credentials.getIssueURL(), credentials.getParameters(), credentials.getHeaders(), connectTimeout, readTimeout);
        return new AccessTokenProviderBuilder(accessTokenProvider);
    }

    public AccessTokenProviderBuilder(AccessTokenProvider accessTokenProvider) {
        super(accessTokenProvider);
    }
}

