/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import java.io.IOException;
import org.entur.jwt.client.AccessToken;
import org.entur.jwt.client.AccessTokenException;
import org.entur.jwt.client.AccessTokenHealth;
import org.entur.jwt.client.AccessTokenProvider;
import org.entur.jwt.client.BaseAccessTokenProvider;

public class DefaultAccessTokenHealthProvider
extends BaseAccessTokenProvider {
    private volatile AccessTokenHealth status;
    private AccessTokenProvider refreshProvider;

    public DefaultAccessTokenHealthProvider(AccessTokenProvider provider) {
        super(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccessToken getAccessToken(boolean forceRefresh) throws AccessTokenException {
        long time = System.currentTimeMillis();
        AccessToken accessToken = null;
        try {
            accessToken = this.provider.getAccessToken(forceRefresh);
            this.status = new AccessTokenHealth(time, accessToken != null);
        }
        catch (Throwable throwable) {
            this.status = new AccessTokenHealth(time, accessToken != null);
            throw throwable;
        }
        return accessToken;
    }

    @Override
    public void close() throws IOException {
        this.provider.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccessTokenHealth getHealth(boolean refresh) {
        AccessTokenHealth threadSafeStatus = this.status;
        if (refresh && (threadSafeStatus == null || !threadSafeStatus.isSuccess())) {
            try {
                this.refreshProvider.getAccessToken(false);
            }
            catch (Exception e) {
                logger.warn("Exception refreshing health status.", (Throwable)e);
            }
            finally {
                threadSafeStatus = this.status != threadSafeStatus ? this.status : new AccessTokenHealth(System.currentTimeMillis(), true);
            }
        }
        return threadSafeStatus;
    }

    public void setRefreshProvider(AccessTokenProvider top) {
        this.refreshProvider = top;
    }
}

