/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.entur.jwt.client.AbstractCachedAccessTokenProvider;
import org.entur.jwt.client.AccessToken;
import org.entur.jwt.client.AccessTokenException;
import org.entur.jwt.client.AccessTokenProvider;
import org.entur.jwt.client.AccessTokenUnavailableException;

public class DefaultCachedAccessTokenProvider
extends AbstractCachedAccessTokenProvider {
    protected final ReentrantLock lock = new ReentrantLock();
    protected final long minimumTimeToLive;
    protected final long refreshTimeout;

    public DefaultCachedAccessTokenProvider(AccessTokenProvider provider, long minimumTimeToLiveUnits, TimeUnit minimumTimeToLiveUnit, long refreshTimeoutUnits, TimeUnit refreshTimeoutUnit) {
        this(provider, minimumTimeToLiveUnit.toMillis(minimumTimeToLiveUnits), refreshTimeoutUnit.toMillis(refreshTimeoutUnits));
    }

    public DefaultCachedAccessTokenProvider(AccessTokenProvider provider, long minimumTimeToLive, long refreshTimeout) {
        super(provider);
        this.minimumTimeToLive = minimumTimeToLive;
        this.refreshTimeout = refreshTimeout;
    }

    public AccessToken getCachedAccessToken() {
        return this.getCachedAccessToken(System.currentTimeMillis());
    }

    @Override
    protected AccessToken getAccessToken(long time, boolean forceUpdate) throws AccessTokenException {
        AbstractCachedAccessTokenProvider.AccessTokenCacheItem cache = this.cache;
        if (forceUpdate || cache == null || !cache.isValid(time)) {
            return this.getAccessTokenBlocking(time, cache);
        }
        return cache.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AccessToken getAccessTokenBlocking(long time, AbstractCachedAccessTokenProvider.AccessTokenCacheItem cache) throws AccessTokenException {
        try {
            if (this.lock.tryLock(this.refreshTimeout, TimeUnit.MILLISECONDS)) {
                if (cache == this.cache) {
                    try {
                        AccessToken accessToken = this.provider.getAccessToken(false);
                        this.cache = cache = new AbstractCachedAccessTokenProvider.AccessTokenCacheItem(accessToken, accessToken.getExpires() - this.minimumTimeToLive);
                    }
                    finally {
                        this.lock.unlock();
                    }
                } else {
                    cache = this.cache;
                }
            } else {
                throw new AccessTokenUnavailableException("Timeout while waiting for refreshed cache (limit of " + this.refreshTimeout + "ms exceed).");
            }
            if (cache != null && cache.isValid(time)) {
                return cache.getValue();
            }
            throw new AccessTokenUnavailableException("Unable to refresh cache");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AccessTokenUnavailableException("Interrupted while waiting for refreshed cache", e);
        }
    }

    ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    public void close() throws IOException {
        this.provider.close();
    }

    long getExpires(long time) {
        AbstractCachedAccessTokenProvider.AccessTokenCacheItem cache = this.cache;
        if (cache == null) {
            return -1L;
        }
        return cache.getExpires() + time;
    }

    public long getMinimumTimeToLive() {
        return this.minimumTimeToLive;
    }

    public long getRefreshTimeout() {
        return this.refreshTimeout;
    }
}

