/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import java.util.concurrent.TimeUnit;
import org.entur.jwt.client.AccessTokenProvider;
import org.entur.jwt.client.AccessTokenProviderBuilderException;
import org.entur.jwt.client.DefaultAccessTokenHealthProvider;
import org.entur.jwt.client.DefaultCachedAccessTokenProvider;
import org.entur.jwt.client.PreemptiveCachedAccessTokenProvider;
import org.entur.jwt.client.RetryingAccessTokenProvider;

public abstract class AbstractAccessTokenProvidersBuilder<B extends AbstractAccessTokenProvidersBuilder<B>> {
    protected final AccessTokenProvider accessTokenProvider;
    protected boolean cached = true;
    protected TimeUnit minimumTimeToLiveUnit = TimeUnit.SECONDS;
    protected long minimumTimeToLiveUnits = 15L;
    protected TimeUnit refreshExpiresUnit = TimeUnit.SECONDS;
    protected long refreshExpiresIn = 15L;
    protected boolean preemptiveRefresh = true;
    protected TimeUnit preemptiveRefreshTimeUnit = TimeUnit.SECONDS;
    protected long preemptiveRefreshTimeUnits = 30L;
    protected boolean health = true;
    protected boolean retrying = true;

    public AbstractAccessTokenProvidersBuilder(AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = accessTokenProvider;
    }

    public B cached(boolean cached) {
        this.cached = cached;
        if (!cached) {
            this.preemptiveRefresh = false;
        }
        return (B)this;
    }

    public B health(boolean enabled) {
        this.health = enabled;
        return (B)this;
    }

    public B cached(long minimumTimeToLiveLeft, TimeUnit minimumTimeToLiveLeftUnit, long refreshExpiresIn, TimeUnit refreshExpiresInUnit) {
        this.cached = true;
        this.minimumTimeToLiveUnits = minimumTimeToLiveLeft;
        this.minimumTimeToLiveUnit = minimumTimeToLiveLeftUnit;
        this.refreshExpiresIn = refreshExpiresIn;
        this.refreshExpiresUnit = refreshExpiresInUnit;
        return (B)this;
    }

    public B preemptiveCacheRefresh(long timeout, TimeUnit unit) {
        this.cached = true;
        this.preemptiveRefresh = true;
        this.preemptiveRefreshTimeUnits = timeout;
        this.preemptiveRefreshTimeUnit = unit;
        return (B)this;
    }

    public B preemptiveCacheRefresh(boolean preemptive) {
        if (preemptive) {
            this.cached = true;
        }
        this.preemptiveRefresh = preemptive;
        return (B)this;
    }

    public AccessTokenProvider build() {
        return this.build(this.accessTokenProvider);
    }

    protected AccessTokenProvider build(AccessTokenProvider provider) {
        if (!this.cached && this.preemptiveRefresh) {
            throw new AccessTokenProviderBuilderException("Premptive cache refresh configured without caching");
        }
        if (this.retrying) {
            provider = new RetryingAccessTokenProvider(provider);
        }
        DefaultAccessTokenHealthProvider defaultAccessTokenHealthProvider = null;
        if (this.health) {
            defaultAccessTokenHealthProvider = new DefaultAccessTokenHealthProvider(provider);
            provider = defaultAccessTokenHealthProvider;
        }
        if (this.preemptiveRefresh) {
            provider = new PreemptiveCachedAccessTokenProvider(provider, this.minimumTimeToLiveUnits, this.minimumTimeToLiveUnit, this.refreshExpiresIn, this.refreshExpiresUnit, this.preemptiveRefreshTimeUnits, this.preemptiveRefreshTimeUnit);
        } else if (this.cached) {
            provider = new DefaultCachedAccessTokenProvider(provider, this.minimumTimeToLiveUnits, this.minimumTimeToLiveUnit, this.refreshExpiresIn, this.refreshExpiresUnit);
        }
        if (defaultAccessTokenHealthProvider != null) {
            defaultAccessTokenHealthProvider.setRefreshProvider(provider);
        }
        return provider;
    }

    public B retrying(boolean retrying) {
        this.retrying = retrying;
        return (B)this;
    }
}

