/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import org.entur.jwt.client.AccessToken;
import org.entur.jwt.client.AccessTokenException;
import org.entur.jwt.client.AccessTokenProvider;
import org.entur.jwt.client.BaseAccessTokenProvider;

public abstract class AbstractCachedAccessTokenProvider
extends BaseAccessTokenProvider {
    protected volatile AccessTokenCacheItem cache;

    public AbstractCachedAccessTokenProvider(AccessTokenProvider provider) {
        super(provider);
    }

    @Override
    public AccessToken getAccessToken(boolean forceRefresh) throws AccessTokenException {
        return this.getAccessToken(System.currentTimeMillis(), forceRefresh);
    }

    abstract AccessToken getAccessToken(long var1, boolean var3) throws AccessTokenException;

    protected AccessToken getCachedAccessToken(long time) {
        AccessTokenCacheItem threadSafeCache = this.cache;
        if (threadSafeCache != null && threadSafeCache.isValid(time)) {
            return threadSafeCache.getValue();
        }
        return null;
    }

    protected AccessTokenCacheItem getCache() {
        return this.cache;
    }

    protected static class AccessTokenCacheItem {
        private final AccessToken value;
        private final long expires;

        public AccessTokenCacheItem(AccessToken value, long expires) {
            this.value = value;
            this.expires = expires;
        }

        public boolean isValid(long time) {
            return time <= this.expires;
        }

        public AccessToken getValue() {
            return this.value;
        }

        public long getExpires() {
            return this.expires;
        }
    }
}

