/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.entur.jwt.client.ClientCredentials;
import org.entur.jwt.client.DefaultClientCredentials;

public abstract class AbstractClientCredentialsBuilder<B extends AbstractClientCredentialsBuilder<B>> {
    protected static final String KEY_AUDIENCE = "audience";
    protected static final String KEY_SCOPE = "scope";
    protected static final String HEADER_AUTHORIZATION = "authorization";
    protected static final String KEY_CLIENT_CREDENTIALS = "client_credentials";
    protected static final String KEY_GRANT_TYPE = "grant_type";
    protected static final String KEY_CLIENT_ID = "client_id";
    protected static final String KEY_SECRET = "client_secret";
    protected String protocol = "https";
    protected int port = -1;
    protected String host;
    protected String issuePath;
    protected String refreshPath;
    protected String revokePath;
    protected String clientId;
    protected String secret;
    protected String audience;
    protected String scope;

    protected static String createHeader(String clientId, String secret) {
        StringBuilder buf = new StringBuilder(clientId);
        buf.append(':').append(secret);
        return "Basic " + Base64.getUrlEncoder().encodeToString(buf.toString().getBytes(StandardCharsets.UTF_8));
    }

    public B withHost(String host) {
        this.host = host;
        return (B)this;
    }

    public B withProtocol(String protocol) {
        this.protocol = protocol;
        return (B)this;
    }

    public B withIssuePath(String issuePath) {
        this.issuePath = issuePath;
        return (B)this;
    }

    public B withRefreshPath(String refreshPath) {
        this.refreshPath = refreshPath;
        return (B)this;
    }

    public B withRevokePath(String revokePath) {
        this.revokePath = revokePath;
        return (B)this;
    }

    public B withClientId(String clientId) {
        this.clientId = clientId;
        return (B)this;
    }

    public B withSecret(String secret) {
        this.secret = secret;
        return (B)this;
    }

    public B withAudience(String audience) {
        this.audience = audience;
        return (B)this;
    }

    public B withScope(String scope) {
        this.scope = scope;
        return (B)this;
    }

    public abstract ClientCredentials build();

    protected ClientCredentials build(boolean authorizationHeader) {
        if (this.clientId == null) {
            throw new IllegalStateException("Expected client-id");
        }
        if (this.host == null) {
            throw new IllegalStateException("Expected host");
        }
        if (this.issuePath == null) {
            throw new IllegalStateException("Expected issue (token) path");
        }
        if (this.secret == null) {
            throw new IllegalStateException("Expected secret");
        }
        DefaultClientCredentials credentials = this.newClientCredentials();
        credentials.setProtocol(this.protocol);
        credentials.setPort(this.port);
        credentials.setHost(this.host);
        credentials.setIssuePath(this.issuePath);
        credentials.setRefreshPath(this.refreshPath);
        credentials.setRevokePath(this.revokePath);
        if (authorizationHeader) {
            credentials.addHeader("Authorization", AbstractClientCredentialsBuilder.createHeader(this.clientId, this.secret));
        } else {
            credentials.addParameter(KEY_CLIENT_ID, this.clientId);
            credentials.addParameter(KEY_SECRET, this.secret);
        }
        credentials.addParameter(KEY_GRANT_TYPE, KEY_CLIENT_CREDENTIALS);
        if (this.audience != null) {
            credentials.addParameter(KEY_AUDIENCE, this.audience);
        }
        if (this.scope != null) {
            credentials.addParameter(KEY_SCOPE, this.scope);
        }
        return credentials;
    }

    protected DefaultClientCredentials newClientCredentials() {
        return new DefaultClientCredentials();
    }
}

