/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.entur.jwt.client.AccessToken;
import org.entur.jwt.client.AccessTokenException;
import org.entur.jwt.client.AccessTokenProvider;
import org.entur.jwt.client.AccessTokenUnavailableException;
import org.entur.jwt.client.ClientCredentialsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUrlAccessTokenProvider<T>
implements AccessTokenProvider {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractUrlAccessTokenProvider.class);
    protected static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    protected static final String KEY_GRANT_TYPE = "grant_type";
    protected final URL issueUrl;
    protected final byte[] issueBody;
    protected final Map<String, Object> issueHeaders;
    protected final ObjectReader reader;

    public AbstractUrlAccessTokenProvider(URL issueUrl, Map<String, Object> parameters, Map<String, Object> headers) {
        this.checkArgument(issueUrl != null, "A non-null url is required");
        this.checkArgument(parameters != null, "A non-null body parameters is required");
        this.checkArgument(headers != null, "A non-null headers is required");
        this.issueUrl = issueUrl;
        this.issueBody = this.createBody(parameters);
        this.issueHeaders = headers;
        ObjectMapper mapper = new ObjectMapper();
        this.reader = mapper.readerFor(ClientCredentialsResponse.class);
    }

    protected void checkArgument(boolean valid, String message) {
        if (!valid) {
            throw new IllegalArgumentException(message);
        }
    }

    protected byte[] createBody(Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        if (!map.isEmpty()) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                builder.append(entry.getKey());
                builder.append('=');
                builder.append(this.encode(entry.getValue().toString()));
                builder.append('&');
            }
            builder.setLength(builder.length() - 1);
        }
        return builder.toString().getBytes(StandardCharsets.UTF_8);
    }

    protected String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ClientCredentialsResponse getToken() throws AccessTokenException {
        try {
            T request = this.request(this.issueUrl, this.issueBody, this.issueHeaders);
            int responseCode = this.getResponseStatusCode(request);
            if (responseCode != 200) {
                logger.info("Got unexpected response code {} when trying to issue token at {}", (Object)responseCode, (Object)this.issueUrl);
                if (responseCode == 503) {
                    throw new AccessTokenUnavailableException("Authorization server responded with HTTP code 503 - service unavailable. " + this.printHeadersIfPresent(request, "Retry-After"));
                }
                if (responseCode != 429) throw new AccessTokenException("Authorization server responded with HTTP unexpected response code " + responseCode);
                throw new AccessTokenUnavailableException("Authorization server responded with HTTP code 429 - too many requests. " + this.printHeadersIfPresent(request, "X-RateLimit-Limit", "X-RateLimit-Remaining", "X-RateLimit-Reset"));
            }
            try (InputStream inputStream = this.getResponseContent(request);){
                ClientCredentialsResponse clientCredentialsResponse = (ClientCredentialsResponse)this.reader.readValue(inputStream);
                this.validate(clientCredentialsResponse);
                ClientCredentialsResponse clientCredentialsResponse2 = clientCredentialsResponse;
                return clientCredentialsResponse2;
            }
        }
        catch (IOException e) {
            throw new AccessTokenUnavailableException(e);
        }
    }

    protected abstract int getResponseStatusCode(T var1) throws IOException;

    protected abstract InputStream getResponseContent(T var1) throws IOException;

    protected abstract StringBuilder printHeadersIfPresent(T var1, String ... var2);

    protected abstract T request(URL var1, byte[] var2, Map<String, Object> var3) throws IOException;

    @Override
    public AccessToken getAccessToken(boolean forceRefresh) throws AccessTokenException {
        long time = System.currentTimeMillis();
        ClientCredentialsResponse token = this.getToken();
        return new AccessToken(token.getAccessToken(), token.getTokenType(), time + token.getExpiresIn() * 1000L);
    }

    @Override
    public void close() throws IOException {
    }

    protected void validate(ClientCredentialsResponse clientCredentialsResponse) throws AccessTokenUnavailableException {
        if (clientCredentialsResponse.getExpiresIn() == null) {
            throw new AccessTokenUnavailableException("Expires-in is not specified");
        }
        if (clientCredentialsResponse.getTokenType() == null) {
            throw new AccessTokenUnavailableException("Token-type is not specified");
        }
        if (clientCredentialsResponse.getAccessToken() == null) {
            throw new AccessTokenUnavailableException("Access-token is not specified");
        }
    }
}

