/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.entur.jwt.client.AbstractCachedAccessTokenProvider;
import org.entur.jwt.client.AccessToken;
import org.entur.jwt.client.AccessTokenException;
import org.entur.jwt.client.AccessTokenProvider;
import org.entur.jwt.client.DefaultCachedAccessTokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreemptiveCachedAccessTokenProvider
extends DefaultCachedAccessTokenProvider {
    protected static final Logger logger = LoggerFactory.getLogger(PreemptiveCachedAccessTokenProvider.class);
    private final long preemptiveRefresh;
    private final ReentrantLock lazyLock = new ReentrantLock();
    private final ExecutorService executorService;
    private volatile long cacheExpires;

    public PreemptiveCachedAccessTokenProvider(AccessTokenProvider provider, long minimumTimeToLiveUnits, TimeUnit minimumTimeToLiveUnit, long refreshTimeoutUnits, TimeUnit refreshTimeoutUnit, long preemptiveTimeoutUnits, TimeUnit preemptiveTimeoutUnit) {
        this(provider, minimumTimeToLiveUnit.toMillis(minimumTimeToLiveUnits), refreshTimeoutUnit.toMillis(refreshTimeoutUnits), preemptiveTimeoutUnit.toMillis(preemptiveTimeoutUnits), Executors.newSingleThreadExecutor());
    }

    public PreemptiveCachedAccessTokenProvider(AccessTokenProvider provider, long minimumTimeToLive, long refreshTimeout, long preemptiveRefresh) {
        this(provider, minimumTimeToLive, refreshTimeout, preemptiveRefresh, Executors.newSingleThreadExecutor());
    }

    public PreemptiveCachedAccessTokenProvider(AccessTokenProvider provider, long minimumTimeToLive, long refreshTimeout, long preemptiveRefresh, ExecutorService executorService) {
        super(provider, minimumTimeToLive, refreshTimeout);
        if (preemptiveRefresh < minimumTimeToLive) {
            throw new IllegalArgumentException("Minimum time to live must be less than preemptive refresh limit");
        }
        this.preemptiveRefresh = preemptiveRefresh;
        this.executorService = executorService;
    }

    @Override
    public AccessToken getAccessToken(long time, boolean forceUpdate) throws AccessTokenException {
        AbstractCachedAccessTokenProvider.AccessTokenCacheItem cache = this.cache;
        if (forceUpdate || cache == null || !cache.isValid(time)) {
            return super.getAccessTokenBlocking(time, cache);
        }
        this.preemptiveUpdate(time, cache);
        return cache.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preemptiveUpdate(long time, AbstractCachedAccessTokenProvider.AccessTokenCacheItem cache) {
        if (!cache.isValid(time + this.preemptiveRefresh) && this.cacheExpires < cache.getExpires() && this.lazyLock.tryLock()) {
            try {
                if (this.cacheExpires < cache.getExpires()) {
                    this.cacheExpires = cache.getExpires();
                    this.executorService.execute(() -> {
                        try {
                            PreemptiveCachedAccessTokenProvider.super.getAccessTokenBlocking(time, cache);
                        }
                        catch (AccessTokenException e) {
                            this.cacheExpires = -1L;
                            logger.warn("Preemptive cache refresh failed", (Throwable)e);
                        }
                    });
                }
            }
            finally {
                this.lazyLock.unlock();
            }
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    ReentrantLock getLazyLock() {
        return this.lazyLock;
    }
}

