/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import org.entur.jwt.client.AccessToken;
import org.entur.jwt.client.AccessTokenException;
import org.entur.jwt.client.AccessTokenHealth;
import org.entur.jwt.client.AccessTokenProvider;
import org.entur.jwt.client.BaseAccessTokenProvider;

public abstract class AbstractAccessTokenHealthProvider
extends BaseAccessTokenProvider {
    protected volatile AccessTokenHealth providerStatus;
    protected volatile AccessTokenHealth status;
    protected AccessTokenProvider refreshProvider;

    public AbstractAccessTokenHealthProvider(AccessTokenProvider provider) {
        super(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccessToken getAccessToken(boolean forceRefresh) throws AccessTokenException {
        long time = System.currentTimeMillis();
        AccessToken accessToken = null;
        try {
            accessToken = this.provider.getAccessToken(forceRefresh);
            this.providerStatus = new AccessTokenHealth(time, accessToken != null);
        }
        catch (Throwable throwable) {
            this.providerStatus = new AccessTokenHealth(time, accessToken != null);
            throw throwable;
        }
        return accessToken;
    }

    @Override
    public AccessTokenHealth getHealth(boolean refresh) {
        if (!refresh) {
            AccessTokenHealth threadSafeStatus = this.status;
            if (threadSafeStatus != null) {
                return threadSafeStatus;
            }
            return this.providerStatus;
        }
        return this.getRefreshHealth();
    }

    protected abstract AccessTokenHealth getRefreshHealth();

    public void setRefreshProvider(AccessTokenProvider top) {
        this.refreshProvider = top;
    }
}

