/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import java.io.Serializable;

public class AccessToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String value;
    protected final String type;
    protected final long expires;

    public static AccessToken newInstance(String value, String type, long expires) {
        return new AccessToken(value, type, expires);
    }

    public AccessToken(String value, String type, long expiresAt) {
        this.value = value;
        this.type = type;
        this.expires = expiresAt;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public long getExpires() {
        return this.expires;
    }

    public boolean isValid(long time) {
        return time <= this.expires;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.expires ^ this.expires >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessToken other = (AccessToken)obj;
        if (this.expires != other.expires) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

