/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.entur.jwt.client.AbstractUrlAccessTokenProvider;
import org.entur.jwt.client.AccessToken;
import org.entur.jwt.client.AccessTokenException;
import org.entur.jwt.client.AccessTokenUnavailableException;
import org.entur.jwt.client.ClientCredentialsResponse;
import org.entur.jwt.client.RefreshToken;
import org.entur.jwt.client.RefreshTokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatefulUrlAccessTokenProvider<T>
extends AbstractUrlAccessTokenProvider<T> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractStatefulUrlAccessTokenProvider.class);
    protected static final String KEY_REFRESH_TOKEN = "refresh_token";
    protected final URL revokeUrl;
    protected final URL refreshUrl;
    protected volatile RefreshToken refreshToken;

    public AbstractStatefulUrlAccessTokenProvider(URL issueUrl, Map<String, Object> parameters, Map<String, Object> headers, URL refreshUrl, URL revokeUrl) {
        super(issueUrl, parameters, headers);
        this.refreshUrl = refreshUrl;
        this.revokeUrl = revokeUrl;
    }

    @Override
    public void close() {
        this.close(System.currentTimeMillis());
    }

    protected void close(long time) {
        RefreshToken threadSafeRefreshToken = this.refreshToken;
        if (threadSafeRefreshToken != null && threadSafeRefreshToken.isValid(time)) {
            this.refreshToken = null;
            StringBuilder builder = new StringBuilder();
            builder.append(KEY_REFRESH_TOKEN);
            builder.append('=');
            builder.append(this.encode(threadSafeRefreshToken.getValue()));
            byte[] revokeBody = builder.toString().getBytes(StandardCharsets.UTF_8);
            try {
                Object request = this.request(this.revokeUrl, revokeBody, Collections.emptyMap());
                int responseStatusCode = this.getResponseStatusCode(request);
                if (this.getResponseStatusCode(request) != 200) {
                    logger.info("Unexpected response code {} when revoking refresh token", (Object)responseStatusCode);
                }
            }
            catch (IOException e) {
                logger.warn("Unable to revoke token", (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ClientCredentialsResponse getToken(RefreshToken response) throws AccessTokenException {
        StringBuilder builder = new StringBuilder();
        builder.append("grant_type");
        builder.append('=');
        builder.append(KEY_REFRESH_TOKEN);
        builder.append('&');
        builder.append(KEY_REFRESH_TOKEN);
        builder.append('=');
        builder.append(this.encode(response.getValue()));
        byte[] refreshBody = builder.toString().getBytes(StandardCharsets.UTF_8);
        try {
            Object request = this.request(this.refreshUrl, refreshBody, Collections.emptyMap());
            int responseCode = this.getResponseStatusCode(request);
            if (responseCode != 200) {
                logger.info("Got unexpected response code {} when trying to refresh token at {}", (Object)responseCode, (Object)this.refreshUrl);
                if (responseCode == 503) {
                    throw new AccessTokenUnavailableException("Authorization server responded with HTTP code 503 - service unavailable. " + this.printHeadersIfPresent(request, "Retry-After"));
                }
                if (responseCode != 429) throw new RefreshTokenException("Authorization server responded with HTTP unexpected response code " + responseCode);
                throw new AccessTokenUnavailableException("Authorization server responded with HTTP code 429 - too many requests. " + this.printHeadersIfPresent(request, "X-RateLimit-Limit", "X-RateLimit-Remaining", "X-RateLimit-Reset"));
            }
            try (InputStream inputStream = this.getResponseContent(request);){
                ClientCredentialsResponse clientCredentialsResponse = (ClientCredentialsResponse)this.reader.readValue(inputStream);
                this.validate(clientCredentialsResponse);
                ClientCredentialsResponse clientCredentialsResponse2 = clientCredentialsResponse;
                return clientCredentialsResponse2;
            }
        }
        catch (IOException e) {
            throw new AccessTokenUnavailableException(e);
        }
    }

    @Override
    public AccessToken getAccessToken(boolean forceRefresh) throws AccessTokenException {
        return this.getAccessToken(System.currentTimeMillis());
    }

    public AccessToken getAccessToken(long time) throws AccessTokenException {
        ClientCredentialsResponse token;
        RefreshToken threadSafeRefreshToken = this.refreshToken;
        if (threadSafeRefreshToken != null && threadSafeRefreshToken.isValid(time)) {
            try {
                token = this.getToken(threadSafeRefreshToken);
            }
            catch (RefreshTokenException e) {
                token = this.getToken();
            }
        } else {
            token = this.getToken();
        }
        if (token.getRefreshToken() != null) {
            long expires = token.getRefreshExpiresIn() != null ? time + token.getRefreshExpiresIn() * 1000L : -1L;
            this.refreshToken = new RefreshToken(token.getRefreshToken(), expires);
        } else {
            this.refreshToken = null;
        }
        return new AccessToken(token.getAccessToken(), token.getTokenType(), time + token.getExpiresIn() * 1000L);
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public boolean supportsHealth() {
        return false;
    }
}

