/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.entur.jwt.client.ClientCredentials;

public class DefaultClientCredentials
implements ClientCredentials {
    protected String protocol = "https";
    protected int port = -1;
    protected String host;
    protected String issuePath;
    protected String refreshPath;
    protected String revokePath;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected Map<String, Object> headers = new HashMap<String, Object>();

    @Override
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public URL getIssueURL() {
        return this.urlForPath(this.issuePath);
    }

    @Override
    public URL getRevokeURL() {
        if (this.revokePath != null) {
            return this.urlForPath(this.revokePath);
        }
        return null;
    }

    @Override
    public URL getRefreshURL() {
        if (this.refreshPath != null) {
            return this.urlForPath(this.refreshPath);
        }
        return null;
    }

    protected URL urlForPath(String path) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(this.protocol);
            if (!this.protocol.contains("://")) {
                builder.append("://");
            }
            builder.append(this.host);
            if (this.port != -1) {
                builder.append(':');
                builder.append(this.port);
            }
            builder.append(path);
            return new URL(builder.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void addParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    public void addHeader(String key, Object value) {
        this.headers.put(key, value);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getIssuePath() {
        return this.issuePath;
    }

    public void setIssuePath(String issuePath) {
        this.issuePath = issuePath;
    }

    public String getRefreshPath() {
        return this.refreshPath;
    }

    public void setRefreshPath(String refreshPath) {
        this.refreshPath = refreshPath;
    }

    public String getRevokePath() {
        return this.revokePath;
    }

    public void setRevokePath(String revokePath) {
        this.revokePath = revokePath;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public Object getHeader(String key) {
        return this.headers.get(key);
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }
}

