/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.entur.jwt.client.AbstractCachedAccessTokenProvider;
import org.entur.jwt.client.AccessToken;
import org.entur.jwt.client.AccessTokenException;
import org.entur.jwt.client.AccessTokenProvider;
import org.entur.jwt.client.DefaultCachedAccessTokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreemptiveCachedAccessTokenProvider
extends DefaultCachedAccessTokenProvider {
    protected static final Logger logger = LoggerFactory.getLogger(PreemptiveCachedAccessTokenProvider.class);
    private final long preemptiveRefresh;
    private final ReentrantLock lazyLock = new ReentrantLock();
    private final ExecutorService executorService;
    private final boolean shutdownExecutorOnClose;
    private final ScheduledExecutorService scheduledExecutorService;
    private final int refreshConstraintInPercent;
    private ScheduledFuture<?> eagerScheduledFuture;
    private volatile long cacheExpires;

    public PreemptiveCachedAccessTokenProvider(AccessTokenProvider provider, long minimumTimeToLiveUnits, TimeUnit minimumTimeToLiveUnit, long refreshTimeoutUnits, TimeUnit refreshTimeoutUnit, long preemptiveTimeoutUnits, TimeUnit preemptiveTimeoutUnit, int refreshConstraintInPercent, boolean eager) {
        this(provider, minimumTimeToLiveUnit.toMillis(minimumTimeToLiveUnits), refreshTimeoutUnit.toMillis(refreshTimeoutUnits), preemptiveTimeoutUnit.toMillis(preemptiveTimeoutUnits), refreshConstraintInPercent, eager, Executors.newSingleThreadExecutor(), true);
    }

    public PreemptiveCachedAccessTokenProvider(AccessTokenProvider provider, long minimumTimeToLive, long refreshTimeout, long preemptiveRefresh, int refreshConstraintInPercent, boolean eager) {
        this(provider, minimumTimeToLive, refreshTimeout, preemptiveRefresh, refreshConstraintInPercent, eager, Executors.newSingleThreadExecutor(), true);
    }

    public PreemptiveCachedAccessTokenProvider(AccessTokenProvider provider, long minimumTimeToLive, long refreshTimeout, long preemptiveRefresh, int refreshConstraintInPercent, boolean eager, ExecutorService executorService, boolean shutdownExecutorOnClose) {
        super(provider, minimumTimeToLive, refreshTimeout);
        if (preemptiveRefresh < minimumTimeToLive) {
            throw new IllegalArgumentException("Minimum time to live must be less than preemptive refresh limit");
        }
        this.preemptiveRefresh = preemptiveRefresh;
        this.executorService = executorService;
        this.shutdownExecutorOnClose = shutdownExecutorOnClose;
        this.refreshConstraintInPercent = refreshConstraintInPercent;
        this.scheduledExecutorService = eager ? Executors.newSingleThreadScheduledExecutor() : null;
    }

    @Override
    public AccessToken getAccessToken(long time, boolean forceUpdate) throws AccessTokenException {
        AbstractCachedAccessTokenProvider.AccessTokenCacheItem cache = this.cache;
        if (forceUpdate || cache == null || !cache.isValid(time)) {
            return super.getAccessTokenBlocking(time, cache).getValue();
        }
        this.preemptiveRefresh(time, cache, false);
        return cache.getValue();
    }

    protected void schedulePreemptiveRefresh(long time, AbstractCachedAccessTokenProvider.AccessTokenCacheItem cache) {
        long delay;
        if (this.eagerScheduledFuture != null) {
            this.eagerScheduledFuture.cancel(false);
        }
        if ((delay = cache.getRefreshable() - this.refreshTimeout - time) > 0L) {
            this.eagerScheduledFuture = this.scheduledExecutorService.schedule(() -> {
                try {
                    this.preemptiveRefresh(System.currentTimeMillis(), cache, true);
                }
                catch (Exception e) {
                    logger.warn("Scheduled eager access-token refresh failed", (Throwable)e);
                }
            }, delay, TimeUnit.MILLISECONDS);
            logger.info("Scheduled next eager access-token refresh in " + this.getTime(delay));
        } else {
            logger.warn("Not scheduling eager access-token refresh");
        }
    }

    @Override
    protected AbstractCachedAccessTokenProvider.AccessTokenCacheItem loadAccessTokenFromProvider(long time) throws AccessTokenException {
        AbstractCachedAccessTokenProvider.AccessTokenCacheItem item = super.loadAccessTokenFromProvider(time);
        if (this.scheduledExecutorService != null) {
            this.schedulePreemptiveRefresh(time, item);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preemptiveRefresh(long time, AbstractCachedAccessTokenProvider.AccessTokenCacheItem cache, boolean forceRefresh) {
        if ((cache.isRefreshable(time) || forceRefresh) && this.cacheExpires < cache.getExpires() && this.lazyLock.tryLock()) {
            try {
                if (this.cacheExpires < cache.getExpires()) {
                    this.cacheExpires = cache.getExpires();
                    this.executorService.execute(() -> {
                        try {
                            PreemptiveCachedAccessTokenProvider.super.getAccessTokenBlocking(time, cache);
                        }
                        catch (AccessTokenException e) {
                            this.cacheExpires = -1L;
                            logger.warn("Preemptive access-token refresh failed", (Throwable)e);
                        }
                    });
                }
            }
            finally {
                this.lazyLock.unlock();
            }
        }
    }

    @Override
    protected AbstractCachedAccessTokenProvider.AccessTokenCacheItem createCacheItem(long time, AccessToken accessToken) {
        long expires;
        long timeToLive = accessToken.getExpires() - time;
        long earliestRefresh = time + timeToLive * (long)this.refreshConstraintInPercent / 100L;
        long refreshable = accessToken.getExpires() - this.preemptiveRefresh;
        if (refreshable < earliestRefresh) {
            logger.warn("Token time-to-live of " + timeToLive / 1000L + "s (at " + this.refreshConstraintInPercent + "%) does not support desired preemptive refresh of " + this.preemptiveRefresh / 1000L + "s");
            refreshable = earliestRefresh;
        }
        if (refreshable > (expires = accessToken.getExpires() - this.minimumTimeToLive)) {
            refreshable = expires;
        }
        return new AbstractCachedAccessTokenProvider.AccessTokenCacheItem(accessToken, expires, refreshable);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    ReentrantLock getLazyLock() {
        return this.lazyLock;
    }

    protected String getTime(long update) {
        return Duration.ofMillis(update).toString();
    }

    protected ScheduledFuture<?> getEagerScheduledFuture() {
        return this.eagerScheduledFuture;
    }

    @Override
    public void close() throws IOException {
        ScheduledFuture<?> eagerJwkListCacheItem = this.eagerScheduledFuture;
        if (eagerJwkListCacheItem != null) {
            eagerJwkListCacheItem.cancel(true);
            logger.info("Cancelled scheduled access-token refresh");
        }
        super.close();
        if (this.shutdownExecutorOnClose) {
            this.executorService.shutdownNow();
            try {
                this.executorService.awaitTermination(this.refreshTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.info("Interrupted while waiting for executor shutdown", (Throwable)e);
            }
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            try {
                this.scheduledExecutorService.awaitTermination(this.refreshTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.info("Interrupted while waiting for scheduled executor shutdown", (Throwable)e);
            }
        }
    }

    long getRefreshable(long time) {
        AbstractCachedAccessTokenProvider.AccessTokenCacheItem cache = this.cache;
        if (cache == null) {
            return -1L;
        }
        return cache.getRefreshable() + time;
    }
}

