/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client.keycloak;

import org.entur.jwt.client.AbstractClientCredentialsBuilder;
import org.entur.jwt.client.ClientCredentials;

public class KeycloakClientCredentialsBuilder
extends AbstractClientCredentialsBuilder<KeycloakClientCredentialsBuilder> {
    private static final String TEMPLATE = "/auth/realms/%s/protocol/openid-connect";
    private static final String ISSUE_TEMPLATE = "/auth/realms/%s/protocol/openid-connect/token";
    private static final String REVOKE_TEMPLATE = "/auth/realms/%s/protocol/openid-connect/logout";
    protected String realm;

    public static KeycloakClientCredentialsBuilder newInstance() {
        return new KeycloakClientCredentialsBuilder();
    }

    @Override
    public ClientCredentials build() {
        if (this.realm == null) {
            throw new IllegalStateException("Expected realm");
        }
        this.refreshPath = this.issuePath = String.format(ISSUE_TEMPLATE, this.realm);
        this.revokePath = String.format(REVOKE_TEMPLATE, this.realm);
        return this.build(true);
    }

    public KeycloakClientCredentialsBuilder withRealm(String tenant) {
        this.realm = tenant;
        return this;
    }

    public String getRealm() {
        return this.realm;
    }
}

