/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.entur.jwt.client.AccessTokenProvider;
import org.entur.jwt.client.properties.AbstractJwtClientProperties;
import org.entur.jwt.client.properties.JwtClientCache;
import org.entur.jwt.client.properties.JwtPreemptiveRefresh;
import org.entur.jwt.client.spring.EagerContextStartedListener;
import org.entur.jwt.client.spring.SpringJwtClientProperties;
import org.entur.jwt.client.spring.actuate.AccessTokenProviderHealthIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;

public class JwtClientAutoConfiguration {
    private static Logger log = LoggerFactory.getLogger(JwtClientAutoConfiguration.class);

    protected Long getTimeout(SpringJwtClientProperties properties) {
        return this.getTimeout(properties.getAuth0(), this.getTimeout(properties.getKeycloak(), null));
    }

    protected Long getTimeout(Map<String, ? extends AbstractJwtClientProperties> map, Long timeout) {
        for (Map.Entry<String, ? extends AbstractJwtClientProperties> entry : map.entrySet()) {
            JwtClientCache cache;
            AbstractJwtClientProperties client = entry.getValue();
            if (!client.isEnabled() || (cache = client.getCache()) == null || !cache.isEnabled()) continue;
            if (timeout == null) {
                timeout = cache.getRefreshTimeout();
                continue;
            }
            timeout = Math.min(timeout, cache.getRefreshTimeout());
        }
        return timeout;
    }

    @Bean
    public static BeanDefinitionRegistryPostProcessor jwtClientBeanDefinitionRegistryPostProcessor() {
        return new JwtClientBeanDefinitionRegistryPostProcessor();
    }

    @Bean
    @ConditionalOnProperty(value={"entur.jwt.clients.health-indicator.enabled"}, matchIfMissing=true)
    public AccessTokenProviderHealthIndicator accessTokenProviderHealthIndicator(Map<String, AccessTokenProvider> providers) {
        ArrayList<String> statusProviders = new ArrayList<String>();
        for (Map.Entry<String, AccessTokenProvider> entry : providers.entrySet()) {
            AccessTokenProvider accessTokenProvider = entry.getValue();
            if (!accessTokenProvider.supportsHealth()) continue;
            statusProviders.add(entry.getKey());
        }
        Collections.sort(statusProviders);
        if (statusProviders.isEmpty()) {
            log.warn("Health-indicator is active, but none of the {} access-token provider(s) supports health", (Object)providers.size());
        } else {
            log.info("Add health-indicator for {}/{} access-token provider(s) {}", new Object[]{statusProviders.size(), providers.size(), statusProviders.stream().collect(Collectors.joining("', '", "'", "'"))});
        }
        return new AccessTokenProviderHealthIndicator(statusProviders.stream().map(key -> (AccessTokenProvider)providers.get(key)).collect(Collectors.toList()));
    }

    @Bean
    public EagerContextStartedListener eagerContextRefreshedListener(Map<String, AccessTokenProvider> providersById, SpringJwtClientProperties springJwtClientProperties) {
        HashMap<String, AccessTokenProvider> eagerAccessTokenProvidersById = new HashMap<String, AccessTokenProvider>();
        for (Map map : Arrays.asList(springJwtClientProperties.getKeycloak(), springJwtClientProperties.getAuth0())) {
            for (Map.Entry entry : map.entrySet()) {
                JwtPreemptiveRefresh preemptiveRefresh;
                JwtClientCache cache = ((AbstractJwtClientProperties)entry.getValue()).getCache();
                if (cache == null || !cache.isEnabled() || (preemptiveRefresh = cache.getPreemptiveRefresh()) == null || !preemptiveRefresh.isEnabled()) continue;
                eagerAccessTokenProvidersById.put((String)entry.getKey(), providersById.get(entry.getKey()));
            }
        }
        return new EagerContextStartedListener(eagerAccessTokenProvidersById);
    }

    public static class JwtClientBeanDefinitionRegistryPostProcessor
    implements BeanDefinitionRegistryPostProcessor,
    EnvironmentAware {
        private SpringJwtClientProperties properties;

        public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) {
        }

        public void setEnvironment(@Nullable Environment environment) {
            this.bindProperties(environment);
        }

        private void bindProperties(Environment environment) {
            this.properties = (SpringJwtClientProperties)Binder.get((Environment)environment).bind("entur.jwt.clients", SpringJwtClientProperties.class).orElse((Object)new SpringJwtClientProperties());
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
            this.add(registry, "newAuth0Instance", this.enabled(this.properties.getAuth0()));
            this.add(registry, "newKeycloakInstance", this.enabled(this.properties.getKeycloak()));
            this.add(registry, "newGenericInstance", this.enabled(this.properties.getGeneric()));
        }

        private Set<String> enabled(Map<String, ? extends AbstractJwtClientProperties> auth0) {
            ArrayList<String> enabled = new ArrayList<String>();
            for (Map.Entry<String, ? extends AbstractJwtClientProperties> entry : auth0.entrySet()) {
                if (!entry.getValue().isEnabled()) continue;
                enabled.add(entry.getKey());
            }
            Collections.sort(enabled);
            return new LinkedHashSet<String>(enabled);
        }

        private void add(BeanDefinitionRegistry registry, String method, Set<String> keySet) {
            for (String key : keySet) {
                if (registry.containsBeanDefinition(key)) continue;
                GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
                beanDefinition.setBeanClass(AccessTokenProvider.class);
                beanDefinition.setFactoryBeanName("jwtClientBeanDefinitionRegistryPostProcessorSupport");
                beanDefinition.setFactoryMethodName(method);
                beanDefinition.setDestroyMethodName("close");
                ConstructorArgumentValues constructorArgumentValues = new ConstructorArgumentValues();
                constructorArgumentValues.addGenericArgumentValue((Object)key);
                beanDefinition.setAutowireCandidate(true);
                beanDefinition.setConstructorArgumentValues(constructorArgumentValues);
                registry.registerBeanDefinition(key, (BeanDefinition)beanDefinition);
            }
        }
    }
}

